/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.AncientLogs;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.blocks.UniqueLogs;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Metal;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class AFCBlockLootProvider
extends BlockLootSubProvider {
    protected AFCBlockLootProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        for (Wood.BlockType blockType : Wood.BlockType.values()) {
            AFCBlocks.WOODS.forEach((species, map) -> this.createWood((AFCWood)((Object)((Object)species)), type));
        }
        for (TreeSpecies.BlockType blockType : TreeSpecies.BlockType.values()) {
            AFCBlocks.TREE_SPECIES.forEach((species, map) -> this.createSpecies((TreeSpecies)species, blockType));
        }
        for (UniqueLogs.BlockType blockType : UniqueLogs.BlockType.values()) {
            AFCBlocks.UNIQUE_LOGS.forEach((species, map) -> this.createUnique((UniqueLogs)species, blockType));
        }
        for (AncientLogs.BlockType blockType : AncientLogs.BlockType.values()) {
            AFCBlocks.ANCIENT_LOGS.forEach((species, map) -> this.createAncient((AncientLogs)species, blockType));
        }
        for (Metal metal : Metal.values()) {
            if (!metal.allParts()) continue;
            for (AFCWood wood : AFCWood.values()) {
                this.dropSelf((Block)AFCBlocks.CEILING_HANGING_SIGNS.get((Object)wood).get(metal).get());
                this.dropSelf((Block)AFCBlocks.WALL_HANGING_SIGNS.get((Object)wood).get(metal).get());
            }
        }
        this.dropSelf((Block)AFCBlocks.TREE_TAP.get());
    }

    protected void createWood(AFCWood species, Wood.BlockType blockType) {
        switch (blockType) {
            case LOG: 
            case STRIPPED_LOG: 
            case WOOD: 
            case STRIPPED_WOOD: {
                this.createLogDrops(species.getBlock(blockType).get());
                break;
            }
            case LEAVES: {
                this.createAFCLeavesDrops(species.getBlock(blockType).get(), species.getBlock(Wood.BlockType.SAPLING).get(), species.getSaplingDropRate());
                break;
            }
            case POTTED_SAPLING: {
                this.add(species.getBlock(blockType).get(), this.createPotFlowerItemTable((ItemLike)species.getBlock(Wood.BlockType.SAPLING).get().asItem()));
                break;
            }
            case VERTICAL_SUPPORT: 
            case HORIZONTAL_SUPPORT: {
                this.dropOther(species.getBlock(blockType).get(), AFCItems.SUPPORTS.get((Object)species));
                break;
            }
            default: {
                this.dropSelf(species.getBlock(blockType).get());
            }
        }
    }

    protected void createSpecies(TreeSpecies species, TreeSpecies.BlockType blockType) {
        switch (blockType) {
            case LEAVES: {
                this.createAFCLeavesDrops(species.getBlock(blockType).get(), species.getBlock(TreeSpecies.BlockType.SAPLING).get(), species.getSaplingDropRate());
                break;
            }
            case POTTED_SAPLING: {
                this.add(species.getBlock(blockType).get(), this.createPotFlowerItemTable((ItemLike)species.getBlock(TreeSpecies.BlockType.SAPLING).get().asItem()));
                break;
            }
            default: {
                this.dropSelf(species.getBlock(blockType).get());
            }
        }
    }

    protected void createUnique(UniqueLogs species, UniqueLogs.BlockType blockType) {
        switch (blockType) {
            case LOG: 
            case WOOD: {
                this.createLogDrops(species.getBlock(blockType).get());
                break;
            }
            default: {
                this.dropSelf(species.getBlock(blockType).get());
            }
        }
    }

    protected void createAncient(AncientLogs species, AncientLogs.BlockType blockType) {
        Item droppedLog;
        if (species.isAFCWoodType()) {
            assert (species.AFCWoodType() != null);
            droppedLog = species.AFCWoodType().getBlock(Wood.BlockType.LOG).get().asItem();
        } else {
            assert (species.TFCWoodType() != null);
            droppedLog = ((Block)species.TFCWoodType().getBlock(Wood.BlockType.LOG).get()).asItem();
        }
        switch (blockType) {
            case LOG: 
            case WOOD: {
                this.createAncientLogDrops(species.getBlock(blockType).get(), droppedLog, species.getDropChance());
                break;
            }
            default: {
                this.dropSelf(species.getBlock(blockType).get());
            }
        }
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return AFCBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }

    protected void createLogDrops(Block logBlock) {
        this.add(logBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).when(this.isHammer())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))), LootItem.lootTableItem((ItemLike)logBlock.asItem())})).when(ExplosionCondition.survivesExplosion())));
    }

    protected void createAncientLogDrops(Block block, Item drop, float dropChance) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).when(this.isHammer())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))), LootItem.lootTableItem((ItemLike)drop).when(LootItemRandomChanceCondition.randomChance((float)dropChance))})).when(ExplosionCondition.survivesExplosion())));
    }

    protected void createAFCLeavesDrops(Block leavesBlock, Block saplingBlock, float saplingDropRate) {
        this.add(leavesBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).name("self_pool").add(LootItem.lootTableItem((ItemLike)leavesBlock).when(this.hasShearsOrSilkTouch())).when(ExplosionCondition.survivesExplosion())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).name("sapling_pool").add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)saplingBlock.asItem()).when(ExplosionCondition.survivesExplosion())).when(LootItemRandomChanceCondition.randomChance((float)saplingDropRate))).when(ExplosionCondition.survivesExplosion())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).name("stick_pool").add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(TFCTags.Items.TOOLS_SHARP)))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)this.hasShearsOrSilkTouch()))).when(LootItemRandomChanceCondition.randomChance((float)0.2f))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))), ((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)this.hasShearsOrSilkTouch()))).when(LootItemRandomChanceCondition.randomChance((float)0.05f))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))})).when(ExplosionCondition.survivesExplosion())));
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)).or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder isHammer() {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(TFCTags.Items.TOOLS_HAMMER));
    }
}

