/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.therighthon.afc.AFCHelpers;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.UniqueLogs;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.DataGenerationHelpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.jetbrains.annotations.NotNull;

public class AFCRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    RecipeOutput output;
    HolderLookup.Provider lookup;

    public AFCRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cachedOutput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        this.lookup = lookup;
        return super.run(cachedOutput, lookup);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.output = recipeOutput;
        this.crafting();
    }

    private void crafting() {
        for (AFCWood aFCWood : AFCWood.values()) {
            Map<Wood.BlockType, AFCBlocks.Id<Block>> blocks = AFCBlocks.WOODS.get((Object)aFCWood);
            AFCItems.ItemId lumber = AFCItems.LUMBER.get((Object)aFCWood);
            AFCBlocks.Id<Block> planks = blocks.get(Wood.BlockType.PLANKS);
            this.recipe().input('W', (ItemLike)blocks.get(Wood.BlockType.STRIPPED_LOG)).input('G', (ItemLike)TFCItems.GLUE).pattern(new String[]{"WGW"}).shaped((ItemLike)blocks.get(Wood.BlockType.AXLE), 4);
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"L L", "L L", "LLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.BARREL));
            this.recipe().input((ItemLike)blocks.get(Wood.BlockType.AXLE)).input(this.ingredientOf(Metal.STEEL, Metal.ItemType.INGOT)).shapeless((ItemLike)blocks.get(Wood.BlockType.BLADED_AXLE));
            this.recipe().input('P', planks).pattern(new String[]{"P P", "PPP"}).shaped((ItemLike)AFCItems.BOATS.get((Object)aFCWood));
            this.recipe().input('L', (ItemLike)lumber).input('S', Tags.Items.RODS_WOODEN).pattern(new String[]{"LLL", "SSS", "LLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.BOOKSHELF));
            this.recipe().input(planks).shapeless((ItemLike)blocks.get(Wood.BlockType.BUTTON));
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"LLL", "L L", "LLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.CHEST));
            this.recipe().input((ItemLike)blocks.get(Wood.BlockType.CHEST)).input((ItemLike)Items.MINECART).shapeless((ItemLike)AFCItems.CHEST_MINECARTS.get((Object)aFCWood));
            this.recipe().input('L', (ItemLike)lumber).input('S', (ItemLike)blocks.get(Wood.BlockType.STRIPPED_LOG)).input('M', (ItemLike)TFCItems.BRASS_MECHANISMS).input('A', (ItemLike)blocks.get(Wood.BlockType.AXLE)).input('R', Tags.Items.DUSTS_REDSTONE).pattern(new String[]{"LSL", "MAR", "LSL"}).shaped((ItemLike)blocks.get(Wood.BlockType.CLUTCH), 2);
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"LL", "LL", "LL"}).shaped((ItemLike)blocks.get(Wood.BlockType.DOOR));
            this.recipe().input('L', (ItemLike)lumber).input('S', (ItemLike)blocks.get(Wood.BlockType.STRIPPED_LOG)).input('A', (ItemLike)blocks.get(Wood.BlockType.AXLE)).pattern(new String[]{" S ", "LAL", " S "}).shaped((ItemLike)blocks.get(Wood.BlockType.ENCASED_AXLE), 4);
            this.recipe().input('P', planks).input('L', (ItemLike)lumber).pattern(new String[]{"PLP", "PLP"}).shaped((ItemLike)blocks.get(Wood.BlockType.FENCE), 8);
            this.recipe().input('P', planks).input('L', (ItemLike)lumber).pattern(new String[]{"LPL", "LPL"}).shaped((ItemLike)blocks.get(Wood.BlockType.FENCE_GATE), 2);
            this.recipe().input('L', (ItemLike)lumber).input('M', (ItemLike)TFCItems.BRASS_MECHANISMS).pattern(new String[]{" L ", "LML", " L "}).shaped((ItemLike)blocks.get(Wood.BlockType.GEAR_BOX), 2);
            this.recipe().input('L', (ItemLike)lumber).input('B', (ItemLike)blocks.get(Wood.BlockType.BOOKSHELF)).pattern(new String[]{"LLL", " B ", " L "}).shaped((ItemLike)blocks.get(Wood.BlockType.LECTERN));
            this.recipe().input('P', (ItemLike)blocks.get(Wood.BlockType.LOG)).input('L', (ItemLike)lumber).pattern(new String[]{"PLP", "PLP"}).shaped((ItemLike)blocks.get(Wood.BlockType.LOG_FENCE), 8);
            this.recipe().input('L', (ItemLike)lumber).input('S', Tags.Items.RODS_WOODEN).pattern(new String[]{"LLL", "LSL", "L L"}).shaped((ItemLike)blocks.get(Wood.BlockType.LOOM));
            this.recipe("from_logs").inputIsPrimary(TFCTags.Items.TOOLS_SAW).input(this.woodLogsTagOf(Registries.ITEM, aFCWood)).damageInputs().shapeless((ItemLike)lumber, 8);
            this.recipe("from_planks").inputIsPrimary(TFCTags.Items.TOOLS_SAW).input(planks).damageInputs().shapeless((ItemLike)lumber, 4);
            this.recipe("from_stairs").inputIsPrimary(TFCTags.Items.TOOLS_SAW).input((ItemLike)blocks.get(Wood.BlockType.STAIRS)).damageInputs().shapeless((ItemLike)lumber, 3);
            this.recipe("from_slabs").inputIsPrimary(TFCTags.Items.TOOLS_SAW).input((ItemLike)blocks.get(Wood.BlockType.SLAB)).damageInputs().shapeless((ItemLike)lumber, 2);
            this.recipe().to2x2((ItemLike)lumber, planks, 1);
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"LL"}).shaped((ItemLike)blocks.get(Wood.BlockType.PRESSURE_PLATE));
            this.recipe().input('F', Tags.Items.FEATHERS).input('D', Tags.Items.DYES_BLACK).input('S', (ItemLike)blocks.get(Wood.BlockType.SLAB)).input('W', planks).pattern(new String[]{"F D", "SSS", "W W"}).shaped((ItemLike)blocks.get(Wood.BlockType.SCRIBING_TABLE));
            this.recipe().input('S', Tags.Items.TOOLS_SHEAR).input('L', Tags.Items.LEATHERS).input('P', planks).input('G', (ItemLike)blocks.get(Wood.BlockType.LOG)).pattern(new String[]{" LS", "PPP", "G G"}).shaped((ItemLike)blocks.get(Wood.BlockType.SEWING_TABLE));
            this.recipe().input('L', (ItemLike)lumber).input('P', planks).input('S', Tags.Items.RODS_WOODEN).pattern(new String[]{"PPP", "L L", "S S"}).shaped((ItemLike)blocks.get(Wood.BlockType.SHELF), 2);
            this.recipe().input('L', (ItemLike)lumber).input('S', Tags.Items.RODS_WOODEN).pattern(new String[]{"LLL", "LLL", " S "}).shaped((ItemLike)blocks.get(Wood.BlockType.SIGN), 3);
            this.recipe().input('#', planks).pattern(new String[]{"###"}).shaped((ItemLike)blocks.get(Wood.BlockType.SLAB), 6);
            this.recipe().input('#', planks).pattern(new String[]{"#  ", "## ", "###"}).shaped((ItemLike)blocks.get(Wood.BlockType.STAIRS), 8);
            this.recipe().input('L', (ItemLike)lumber).input('S', Tags.Items.RODS_WOODEN).pattern(new String[]{"  S", " SL", "SLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.SLUICE));
            this.recipe().input('L', this.woodLogsTagOf(Registries.ITEM, aFCWood)).input('S', TFCTags.Items.TOOLS_SAW).pattern(new String[]{"LS", "L "}).damageInputs().source(0, 1).shaped((ItemLike)AFCItems.SUPPORTS.get((Object)aFCWood), 8);
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"LLL", "   ", "LLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.TOOL_RACK));
            this.recipe().input('L', (ItemLike)lumber).pattern(new String[]{"LLL", "LLL"}).shaped((ItemLike)blocks.get(Wood.BlockType.TRAPDOOR), 2);
            this.recipe().input((ItemLike)blocks.get(Wood.BlockType.CHEST)).input((ItemLike)Items.TRIPWIRE_HOOK).shapeless((ItemLike)blocks.get(Wood.BlockType.TRAPPED_CHEST));
            this.recipe().input('L', (ItemLike)lumber).input('P', planks).input('A', (ItemLike)blocks.get(Wood.BlockType.AXLE)).pattern(new String[]{"LPL", "PAP", "LPL"}).shaped((ItemLike)blocks.get(Wood.BlockType.WATER_WHEEL));
            this.recipe().to2x2((ItemLike)blocks.get(Wood.BlockType.LOG), (ItemLike)blocks.get(Wood.BlockType.WOOD), 3);
            this.recipe().to2x2(planks, (ItemLike)blocks.get(Wood.BlockType.WORKBENCH), 1);
            for (Metal metal : Metal.values()) {
                if (!metal.allParts()) continue;
                this.recipe().input('L', (ItemLike)AFCItems.LUMBER.get((Object)aFCWood)).input('C', this.ingredientOf(metal, Metal.BlockType.CHAIN)).pattern(new String[]{"C C", "LLL", "LLL"}).shaped((ItemLike)AFCItems.HANGING_SIGNS.get((Object)aFCWood).get(metal), 3);
            }
        }
        for (Enum enum_ : UniqueLogs.values()) {
            Map<UniqueLogs.BlockType, AFCBlocks.Id<Block>> uBlocks = AFCBlocks.UNIQUE_LOGS.get(enum_);
            Map sBlocks = ((UniqueLogs)enum_).isAFCWoodType() ? AFCBlocks.WOODS.get((Object)((UniqueLogs)enum_).AFCWoodType()) : (Map)TFCBlocks.WOODS.get(((UniqueLogs)enum_).TFCWoodType());
            Item lumber = ((UniqueLogs)enum_).isAFCWoodType() ? AFCItems.LUMBER.get((Object)((UniqueLogs)enum_).AFCWoodType()).asItem() : ((Item)((TFCItems.ItemId)TFCItems.LUMBER.get(((UniqueLogs)enum_).TFCWoodType())).get()).asItem();
            Item planks = ((UniqueLogs)enum_).isAFCWoodType() ? AFCBlocks.WOODS.get((Object)((UniqueLogs)enum_).AFCWoodType()).get(Wood.BlockType.PLANKS).asItem() : ((TFCBlocks.Id)((Map)TFCBlocks.WOODS.get(((UniqueLogs)enum_).TFCWoodType())).get(Wood.BlockType.PLANKS)).asItem();
            Item supports = ((UniqueLogs)enum_).isAFCWoodType() ? AFCItems.SUPPORTS.get((Object)((UniqueLogs)enum_).AFCWoodType()).asItem() : ((Item)((TFCItems.ItemId)TFCItems.SUPPORTS.get(((UniqueLogs)enum_).TFCWoodType())).get()).asItem();
            this.recipe("from_" + ((UniqueLogs)enum_).getSerializedName().toLowerCase() + "_logs").input('P', (ItemLike)uBlocks.get((Object)UniqueLogs.BlockType.LOG)).input('L', (ItemLike)lumber).pattern(new String[]{"PLP", "PLP"}).shaped((ItemLike)uBlocks.get((Object)UniqueLogs.BlockType.LOG_FENCE), 8);
            this.recipe("from_" + ((UniqueLogs)enum_).getSerializedName().toLowerCase() + "_logs").inputIsPrimary(TFCTags.Items.TOOLS_SAW).input(this.uniqueLogsTagOf(Registries.ITEM, (UniqueLogs)enum_)).damageInputs().shapeless((ItemLike)lumber, 8);
            this.recipe("from_" + ((UniqueLogs)enum_).getSerializedName().toLowerCase() + "_logs").input('S', Tags.Items.TOOLS_SHEAR).input('L', Tags.Items.LEATHERS).input('P', (ItemLike)planks).input('G', (ItemLike)uBlocks.get((Object)UniqueLogs.BlockType.LOG)).pattern(new String[]{" LS", "PPP", "G G"}).shaped((ItemLike)sBlocks.get(Wood.BlockType.SEWING_TABLE));
            this.recipe("from_" + ((UniqueLogs)enum_).getSerializedName().toLowerCase() + "_logs").input('L', this.uniqueLogsTagOf(Registries.ITEM, (UniqueLogs)enum_)).input('S', TFCTags.Items.TOOLS_SAW).pattern(new String[]{"LS", "L "}).damageInputs().source(0, 1).shaped((ItemLike)supports, 8);
            this.recipe().to2x2((ItemLike)uBlocks.get((Object)UniqueLogs.BlockType.LOG), (ItemLike)uBlocks.get((Object)UniqueLogs.BlockType.WOOD), 3);
        }
    }

    private Ingredient ingredientOf(Metal metal, Metal.BlockType type) {
        return type == Metal.BlockType.BLOCK ? Ingredient.of(this.storageBlockTagOf(Registries.ITEM, metal)) : Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)((TFCBlocks.Id)((Map)TFCBlocks.METALS.get(metal)).get(type)).get()});
    }

    private Ingredient ingredientOf(Metal metal, Metal.ItemType type) {
        return type.isCommonTagPart() ? Ingredient.of(this.commonTagOf(metal, type)) : Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)((TFCItems.ItemId)((Map)TFCItems.METAL_ITEMS.get(metal)).get(type)).get()});
    }

    private TagKey<Item> commonTagOf(Metal metal, Metal.ItemType type) {
        assert (type.isCommonTagPart()) : "Non-typical use of tag for " + metal.getSerializedName() + " / " + type.name();
        assert (type.has(metal)) : "Non-typical use of " + metal.getSerializedName() + " / " + type.name();
        return this.commonTagOf(Registries.ITEM, type.name() + "s/" + metal.name());
    }

    private <T> TagKey<T> commonTagOf(ResourceKey<Registry<T>> key, String name) {
        return TagKey.create(key, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name.toLowerCase(Locale.ROOT)));
    }

    private <T> TagKey<T> woodLogsTagOf(ResourceKey<Registry<T>> registry, AFCWood wood) {
        return TagKey.create(registry, (ResourceLocation)AFCHelpers.modIdentifier(wood.getSerializedName() + "_logs"));
    }

    private <T> TagKey<T> uniqueLogsTagOf(ResourceKey<Registry<T>> registry, UniqueLogs wood) {
        return TagKey.create(registry, (ResourceLocation)AFCHelpers.modIdentifier(wood.getSerializedName() + "_logs"));
    }

    private DataGenerationHelpers.Builder recipe() {
        return new DataGenerationHelpers.Builder((name, r) -> {
            if (name != null) {
                this.add((String)name, (Recipe<?>)r);
            } else {
                this.add((Recipe<?>)r);
            }
        });
    }

    private DataGenerationHelpers.Builder recipe(String suffix) {
        return new DataGenerationHelpers.Builder((name, r) -> {
            assert (!suffix.startsWith("_")) : "recipe(String suffix) shouldn't start with an '_', it is added for you!";
            assert (name == null) : "Cannot use a named recipe and recipe(String suffix) at the same time!";
            this.add(this.nameOf((ItemLike)r.getResultItem(this.lookup).getItem()) + "_" + suffix, (Recipe<?>)r);
        });
    }

    private void add(Recipe<?> recipe) {
        this.add(this.nameOf(recipe), recipe);
    }

    private void add(String name, Recipe<?> recipe) {
        this.add(Objects.requireNonNull(BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.getType()), "No recipe type").getPath(), name, recipe);
    }

    private void add(String prefix, String name, Recipe<?> recipe) {
        this.output.accept(AFCHelpers.modIdentifier((prefix + "/" + name).toLowerCase(Locale.ROOT)), recipe, null);
    }

    private String nameOf(Recipe<?> recipe) {
        return this.nameOf((ItemLike)recipe.getResultItem(this.lookup).getItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String nameOf(Ingredient ingredient) {
        ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
        if (iCustomIngredient instanceof CompoundIngredient) {
            CompoundIngredient ing = (CompoundIngredient)iCustomIngredient;
            return this.nameOf((Ingredient)ing.children().get(0));
        }
        Ingredient.Value value = ingredient.getValues()[0];
        if (value instanceof Ingredient.TagValue) {
            TagKey tagKey;
            iCustomIngredient = (Ingredient.TagValue)value;
            TagKey tag = tagKey = iCustomIngredient.tag();
            return tag.location().getPath();
        }
        if (!(value instanceof Ingredient.ItemValue)) throw new AssertionError((Object)"Unknown ingredient value");
        iCustomIngredient = (Ingredient.ItemValue)value;
        try {
            ItemStack itemStack;
            ItemStack item = itemStack = iCustomIngredient.item();
            return this.nameOf((ItemLike)item.getItem());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private String nameOf(Fluid fluid) {
        assert (fluid != Fluids.EMPTY) : "Should never get name of Items.AIR";
        return BuiltInRegistries.FLUID.getKey((Object)fluid).getPath();
    }

    private String nameOf(ItemLike item) {
        assert (item.asItem() != Items.AIR) : "Should never get name of Items.AIR";
        assert (item.asItem() != Items.BARRIER) : "Should never get name of Items.BARRIER";
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    private <T> TagKey<T> storageBlockTagOf(ResourceKey<Registry<T>> key, Metal metal) {
        assert (metal.defaultParts()) : "Non-typical use of a non-default metal " + metal.getSerializedName();
        return this.commonTagOf(key, "storage_blocks/" + metal.getSerializedName());
    }
}

