/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.therighthon.afc.datagen.AFCBlockLootProvider;
import com.therighthon.afc.datagen.AFCBlockTagProvider;
import com.therighthon.afc.datagen.AFCFluidTagProvider;
import com.therighthon.afc.datagen.AFCItemTagProvider;
import com.therighthon.afc.datagen.AFCRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="afc")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(AFCBlockLootProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        AFCBlockTagProvider blockTagsProvider = new AFCBlockTagProvider(packOutput, lookupProvider, "afc", existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new AFCItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "afc", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AFCFluidTagProvider(packOutput, lookupProvider, "afc", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AFCRecipeProvider(packOutput, lookupProvider));
    }
}

