/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.event;

import com.therighthon.afc.AFCHelpers;
import com.therighthon.afc.client.render.blockentities.AFCHangingSignBlockEntityRenderer;
import com.therighthon.afc.client.render.blockentities.AFCSignBlockEntityRenderer;
import com.therighthon.afc.client.render.colors.AFCColors;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.fluids.AFCFluids;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.client.ColorMapReloadListener;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.extensions.FluidRendererExtension;
import net.dries007.tfc.client.extensions.ItemRendererExtension;
import net.dries007.tfc.client.model.entity.HorseChestLayer;
import net.dries007.tfc.client.render.blockentity.ChestItemRenderer;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.client.render.entity.TFCChestBoatRenderer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public final class ModEventClientBusEvents {
    public static final ResourceLocation WATER_STILL = Helpers.identifierMC((String)"block/water_still");
    public static final ResourceLocation WATER_FLOW = Helpers.identifierMC((String)"block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = Helpers.identifierMC((String)"block/water_overlay");
    public static final ResourceLocation UNDERWATER_LOCATION = Helpers.identifierMC((String)"textures/misc/underwater.png");

    public static void registerColorHandlerBlocks(RegisterColorHandlersEvent.Block event) {
        BlockColor foliageColor = (state, level, pos, tintIndex) -> TFCColors.getFoliageColor((BlockPos)pos, (int)tintIndex);
        BlockColor kapokFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getKapokFoliageColor(pos, tintIndex, TreeSpecies.RED_SILK_COTTON.autumnIndex());
        BlockColor jacarandaFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getJacarandaFoliageColor(pos, tintIndex, TreeSpecies.GIANT_ROSEWOOD.autumnIndex());
        BlockColor yellowIpeFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getYellowIpeFoliageColor(pos, tintIndex, AFCWood.IPE.autumnIndex());
        BlockColor flameOfTheForestFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getFlameOfTheForestFoliageColor(pos, tintIndex, TreeSpecies.FLAME_OF_THE_FOREST.autumnIndex());
        AFCBlocks.WOODS.forEach((wood, reg) -> event.register(wood.isConifer() ? foliageColor : (wood == AFCWood.IPE ? yellowIpeFoliageColor : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)wood.autumnIndex())), new Block[]{(Block)((AFCBlocks.Id)reg.get(Wood.BlockType.LEAVES)).get(), (Block)((AFCBlocks.Id)reg.get(Wood.BlockType.FALLEN_LEAVES)).get()}));
        AFCBlocks.TREE_SPECIES.forEach((wood, reg) -> event.register(wood.isConifer() ? foliageColor : (wood == TreeSpecies.RED_SILK_COTTON ? kapokFoliageColor : (wood == TreeSpecies.FLAME_OF_THE_FOREST ? flameOfTheForestFoliageColor : (wood == TreeSpecies.GIANT_ROSEWOOD ? jacarandaFoliageColor : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)wood.autumnIndex())))), new Block[]{(Block)((AFCBlocks.Id)reg.get((Object)TreeSpecies.BlockType.LEAVES)).get(), (Block)((AFCBlocks.Id)reg.get((Object)TreeSpecies.BlockType.FALLEN_LEAVES)).get()}));
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        ItemColors registry = event.getItemColors();
        ItemColor seasonalFoliageColor = (stack, tintIndex) -> TFCColors.getFoliageColor(null, (int)tintIndex);
        AFCBlocks.WOODS.forEach((wood, reg) -> registry.register(seasonalFoliageColor, new ItemLike[]{(ItemLike)((AFCBlocks.Id)reg.get(Wood.BlockType.LEAVES)).get(), (ItemLike)((AFCBlocks.Id)reg.get(Wood.BlockType.FALLEN_LEAVES)).get()}));
        AFCBlocks.TREE_SPECIES.forEach((key, value) -> registry.register(seasonalFoliageColor, new ItemLike[]{(ItemLike)((AFCBlocks.Id)value.get((Object)TreeSpecies.BlockType.LEAVES)).get(), (ItemLike)((AFCBlocks.Id)value.get((Object)TreeSpecies.BlockType.FALLEN_LEAVES)).get()}));
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType solid = RenderType.solid();
        RenderType cutout = RenderType.cutout();
        RenderType cutoutMipped = RenderType.cutoutMipped();
        RenderType translucent = RenderType.translucent();
        Predicate<RenderType> ghostBlock = rt -> rt == cutoutMipped || rt == Sheets.translucentCullBlockSheet();
        Predicate<RenderType> leafPredicate = layer -> Minecraft.useFancyGraphics() ? layer == cutoutMipped : layer == solid;
        AFCBlocks.WOODS.values().forEach(map -> {
            Stream.of(Wood.BlockType.SAPLING, Wood.BlockType.DOOR, Wood.BlockType.TRAPDOOR, Wood.BlockType.FENCE, Wood.BlockType.FENCE_GATE, Wood.BlockType.BUTTON, Wood.BlockType.PRESSURE_PLATE, Wood.BlockType.SLAB, Wood.BlockType.STAIRS, Wood.BlockType.TWIG, Wood.BlockType.BARREL, Wood.BlockType.SCRIBING_TABLE, Wood.BlockType.SEWING_TABLE, Wood.BlockType.SHELF, Wood.BlockType.POTTED_SAPLING, Wood.BlockType.ENCASED_AXLE, Wood.BlockType.CLUTCH, Wood.BlockType.GEAR_BOX).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((AFCBlocks.Id)map.get(type)).get()), (RenderType)cutout));
            Stream.of(Wood.BlockType.LEAVES, Wood.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((AFCBlocks.Id)map.get(type)).get()), (Predicate)leafPredicate));
        });
        AFCBlocks.TREE_SPECIES.values().forEach(map -> {
            Stream.of(TreeSpecies.BlockType.SAPLING, TreeSpecies.BlockType.POTTED_SAPLING).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((AFCBlocks.Id)map.get(type)).get()), (RenderType)cutout));
            Stream.of(TreeSpecies.BlockType.LEAVES, TreeSpecies.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((AFCBlocks.Id)map.get(type)).get()), (Predicate)leafPredicate));
        });
        event.enqueueWork(() -> AFCBlocks.WOODS.forEach((wood, map) -> {
            HorseChestLayer.registerChest((Item)((Block)((AFCBlocks.Id)map.get(Wood.BlockType.CHEST)).get()).asItem(), (ResourceLocation)AFCHelpers.modIdentifier("textures/entity/chest/horse/" + wood.getSerializedName() + ".png"));
            HorseChestLayer.registerChest((Item)((Block)((AFCBlocks.Id)map.get(Wood.BlockType.TRAPPED_CHEST)).get()).asItem(), (ResourceLocation)AFCHelpers.modIdentifier("textures/entity/chest/horse/" + wood.getSerializedName() + ".png"));
            HorseChestLayer.registerChest((Item)((Block)((AFCBlocks.Id)map.get(Wood.BlockType.BARREL)).get()).asItem(), (ResourceLocation)AFCHelpers.modIdentifier("textures/entity/chest/horse/" + wood.getSerializedName() + "_barrel.png"));
        }));
        for (AFCWood wood : AFCWood.VALUES) {
            Sheets.addWoodType((WoodType)wood.getVanillaWoodType());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)AFCBlocks.TREE_TAP.get()), (RenderType)RenderType.cutout());
    }

    public static void clientFLCompatSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.cutout();
    }

    public static void onLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition boatLayer = BoatModel.createBodyModel();
        LayerDefinition chestLayer = ChestBoatModel.createBodyModel();
        for (AFCWood wood : AFCWood.VALUES) {
            event.registerLayerDefinition(TFCBoatRenderer.boatName((String)wood.getSerializedName()), () -> boatLayer);
            event.registerLayerDefinition(TFCChestBoatRenderer.chestBoatName((String)wood.getSerializedName()), () -> chestLayer);
        }
    }

    public static void registerEntityLayers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SIGN.get(), AFCSignBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), AFCHangingSignBlockEntityRenderer::new);
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageJacarandaColors, AFCColors.FOLIAGE_JACARANDA_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageYellowColors, AFCColors.FOLIAGE_YELLOW_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageOrangeColors, AFCColors.FOLIAGE_ORANGE_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageRedColors, AFCColors.FOLIAGE_RED_COLORS_LOCATION));
    }

    public static void registerExtensions(RegisterClientExtensionsEvent event) {
        AFCBlocks.WOODS.values().forEach(map -> ModEventClientBusEvents.registerCustomItemRenderer(event, (Supplier)map.get(Wood.BlockType.CHEST), ChestItemRenderer::new));
        AFCBlocks.WOODS.values().forEach(map -> ModEventClientBusEvents.registerCustomItemRenderer(event, (Supplier)map.get(Wood.BlockType.TRAPPED_CHEST), ChestItemRenderer::new));
        AFCFluids.SIMPLE_AFC_FLUIDS.forEach((fluid, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(fluid.isTransparent() ? 0xFF000000 | fluid.getColor() : fluid.getColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), new FluidType[]{holder.getType()}));
    }

    private static <T> void registerCustomItemRenderer(RegisterClientExtensionsEvent event, @Nullable Supplier<? extends ItemLike> item, Function<T, BlockEntityWithoutLevelRenderer> renderer) {
        if (item != null) {
            event.registerItem((IClientItemExtensions)ItemRendererExtension.cached(() -> (BlockEntityWithoutLevelRenderer)renderer.apply(((ItemLike)item.get()).asItem())), new Item[]{item.get().asItem()});
        }
    }
}

