/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.therighthon.afc.common.blockentities.AFCBlockEntities;
import com.therighthon.afc.common.blockentities.TapBlockEntity;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.AncientLogs;
import com.therighthon.afc.common.blocks.TapBlock;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.blocks.UniqueLogs;
import com.therighthon.afc.common.fluids.AFCFluids;
import com.therighthon.afc.common.fluids.SimpleAFCFluid;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.wood.TFCCeilingHangingSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCWallHangingSignBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class AFCBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"afc");
    public static final DeferredRegister<Block> FLUID_BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"afc");
    public static final Map<AFCWood, Map<Metal, Id<TFCCeilingHangingSignBlock>>> CEILING_HANGING_SIGNS = AFCBlocks.registerHangingSigns("hanging_sign", TFCCeilingHangingSignBlock::new);
    public static final Map<AFCWood, Map<Metal, Id<TFCWallHangingSignBlock>>> WALL_HANGING_SIGNS = AFCBlocks.registerHangingSigns("wall_hanging_sign", TFCWallHangingSignBlock::new);
    public static final Map<AFCWood, Map<Wood.BlockType, Id<Block>>> WOODS = Helpers.mapOf(AFCWood.class, wood -> Helpers.mapOf(Wood.BlockType.class, type -> AFCBlocks.register(type.nameFor((RegistryWood)wood), AFCBlocks.createWood(wood, type), type.createBlockItem((RegistryWood)wood, new Item.Properties()))));
    public static final Map<TreeSpecies, Map<TreeSpecies.BlockType, Id<Block>>> TREE_SPECIES = Helpers.mapOf(TreeSpecies.class, wood -> Helpers.mapOf(TreeSpecies.BlockType.class, type -> AFCBlocks.register(type.nameFor((TreeSpecies)wood), AFCBlocks.createTreeSpecies(wood, type), type.createBlockItem(new Item.Properties()))));
    public static final Map<UniqueLogs, Map<UniqueLogs.BlockType, Id<Block>>> UNIQUE_LOGS = Helpers.mapOf(UniqueLogs.class, wood -> Helpers.mapOf(UniqueLogs.BlockType.class, type -> AFCBlocks.register(type.nameFor((UniqueLogs)wood), AFCBlocks.createUniqueLogs(wood, type), type.createBlockItem(new Item.Properties()))));
    public static final Map<AncientLogs, Map<AncientLogs.BlockType, Id<Block>>> ANCIENT_LOGS = Helpers.mapOf(AncientLogs.class, wood -> Helpers.mapOf(AncientLogs.BlockType.class, type -> AFCBlocks.register(type.nameFor((AncientLogs)wood), AFCBlocks.createAncientLogs(wood, type), type.createBlockItem(new Item.Properties()))));
    public static final Id<Block> TREE_TAP = AFCBlocks.register("tree_tap", () -> new TapBlock(ExtendedProperties.of((BlockBehaviour)Blocks.BRAIN_CORAL_FAN).noOcclusion().blockEntity(AFCBlockEntities.TAP_BLOCK_ENTITY).serverTicks(TapBlockEntity::serverTick)));
    public static final Map<SimpleAFCFluid, Id<LiquidBlock>> SIMPLE_FLUIDS = Helpers.mapOf(SimpleAFCFluid.class, fluid -> AFCBlocks.registerFluidNoItem("fluid/" + fluid.getId(), () -> new LiquidBlock(AFCFluids.SIMPLE_AFC_FLUIDS.get(fluid).getSource(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noLootTable())));

    public static Supplier<Block> createWood(AFCWood afcWood, Wood.BlockType blockType) {
        return blockType.create((RegistryWood)afcWood);
    }

    public static Supplier<Block> createTreeSpecies(TreeSpecies wood, TreeSpecies.BlockType blockType) {
        return blockType.create(wood);
    }

    public static Supplier<Block> createUniqueLogs(UniqueLogs wood, UniqueLogs.BlockType blockType) {
        return blockType.create(wood);
    }

    public static Supplier<Block> createAncientLogs(AncientLogs wood, AncientLogs.BlockType blockType) {
        return blockType.create(wood);
    }

    public static void registerFlowerPotFlowers() {
        FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
        WOODS.forEach((wood, map) -> pot.addPlant(((Id)map.get(Wood.BlockType.SAPLING)).getId(), (Supplier)map.get(Wood.BlockType.POTTED_SAPLING)));
        TREE_SPECIES.forEach((wood, map) -> pot.addPlant(((Id)map.get((Object)TreeSpecies.BlockType.SAPLING)).getId(), (Supplier)map.get((Object)TreeSpecies.BlockType.POTTED_SAPLING)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    protected static <T extends Block> Id<T> register(String name, Supplier<T> blockSupplier) {
        return AFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties()));
    }

    private static <T extends Block> Id<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return AFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> Id<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return new Id(RegistrationHelpers.registerBlock(BLOCKS, AFCItems.ITEMS, (String)name, blockSupplier, blockItemFactory));
    }

    private static <B extends SignBlock> Map<AFCWood, Map<Metal, Id<B>>> registerHangingSigns(String variant, BiFunction<ExtendedProperties, WoodType, B> factory) {
        return Helpers.mapOf(AFCWood.class, wood -> Helpers.mapOf(Metal.class, Metal::allParts, metal -> AFCBlocks.register("wood/planks/" + variant + "/" + metal.getSerializedName() + "/" + wood.getSerializedName(), () -> (SignBlock)factory.apply(ExtendedProperties.of((MapColor)wood.woodColor()).sound(SoundType.WOOD).noCollission().strength(1.0f).flammableLikePlanks().blockEntity((Supplier)TFCBlockEntities.HANGING_SIGN).ticks(SignBlockEntity::tick), wood.getVanillaWoodType()), (Function)null)));
    }

    private static <T extends Block> Id<T> registerFluidNoItem(String name, Supplier<T> blockSupplier) {
        return AFCBlocks.registerFluid(name, blockSupplier, null);
    }

    private static <T extends Block> Id<T> registerFluid(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return new Id(RegistrationHelpers.registerBlock(FLUID_BLOCKS, AFCItems.ITEMS, (String)name, blockSupplier, blockItemFactory));
    }

    public record Id<T extends Block>(DeferredHolder<Block, T> holder) implements RegistryHolder<Block, T>,
    ItemLike
    {
        public Item asItem() {
            return ((Block)this.get()).asItem();
        }
    }
}

