/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.therighthon.afc.AFCHelpers;
import com.therighthon.afc.common.blocks.AFCBlocks;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public enum AFCWood implements RegistryWood
{
    BAOBAB(false, MapColor.WOOD, MapColor.WOOD, 10, 212, 0.0506f),
    EUCALYPTUS(false, MapColor.WOOD, MapColor.WOOD, 10, 150, 0.0193f),
    MAHOGANY(false, MapColor.WOOD, MapColor.WOOD, 10, 10, 0.0157f),
    HEVEA(false, MapColor.WOOD, MapColor.WOOD, 10, 130, 0.0166f),
    TUALANG(false, MapColor.WOOD, MapColor.WOOD, 10, 226, 0.0166f),
    TEAK(false, MapColor.WOOD, MapColor.WOOD, 10, 240, 0.0157f),
    CYPRESS(true, MapColor.WOOD, MapColor.WOOD, 10, 0, 0.0795f),
    FIG(false, MapColor.WOOD, MapColor.WOOD, 12, 250, 0.0166f),
    IRONWOOD(false, MapColor.WOOD, MapColor.WOOD, 14, 200, 0.0145f),
    IPE(false, MapColor.WOOD, MapColor.WOOD, 11, 254, 0.0157f),
    ARAUCARIA(true, MapColor.WOOD, MapColor.WOOD, 12, 0, 0.0281f),
    BEECH(false, MapColor.WOOD, MapColor.WOOD, 11, 110, 0.017f),
    GINKGO(false, MapColor.WOOD, MapColor.WOOD, 11, 245, 0.0209f),
    MAHOE(false, MapColor.WOOD, MapColor.WOOD, 11, 212, 0.0189f);

    public static final AFCWood[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final boolean conifer;
    private final MapColor woodColor;
    private final MapColor barkColor;
    private final TreeGrower tree;
    private final int daysToGrow;
    private final BlockSetType blockSet;
    private final WoodType woodType;
    private final int autumnIndex;
    private final float saplingDropRate;

    private AFCWood(boolean evergreen, MapColor woodColor, MapColor barkColor, int daysToGrow, int autumnIndex, float saplingDropRate) {
        this.conifer = evergreen;
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.autumnIndex = autumnIndex;
        this.tree = new TreeGrower(AFCHelpers.modIdentifier(this.serializedName).toString(), Optional.empty(), Optional.of(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)AFCHelpers.modIdentifier("tree/" + this.serializedName))), Optional.empty());
        this.daysToGrow = daysToGrow;
        this.blockSet = new BlockSetType(this.serializedName);
        this.woodType = new WoodType(AFCHelpers.modIdentifier(this.serializedName).toString(), this.blockSet);
        this.saplingDropRate = saplingDropRate;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    public MapColor woodColor() {
        return this.woodColor;
    }

    public MapColor barkColor() {
        return this.barkColor;
    }

    public Supplier<Block> getBlock(Wood.BlockType type) {
        return (Supplier)((Object)AFCBlocks.WOODS.get((Object)this).get(type));
    }

    public BlockSetType getBlockSet() {
        return this.blockSet;
    }

    public WoodType getVanillaWoodType() {
        return this.woodType;
    }

    public TreeGrower tree() {
        return this.tree;
    }

    public Supplier<Integer> ticksToGrow() {
        return () -> this.daysToGrow() * 24000;
    }

    public int daysToGrow() {
        return this.defaultDaysToGrow();
    }

    public int autumnIndex() {
        return this.autumnIndex;
    }

    public float getSaplingDropRate() {
        return this.saplingDropRate;
    }

    public int defaultDaysToGrow() {
        return this.daysToGrow;
    }

    public static void registerBlockSetTypes() {
        for (AFCWood wood : VALUES) {
            BlockSetType.register((BlockSetType)wood.blockSet);
            WoodType.register((WoodType)wood.woodType);
        }
    }

    static {
        VALUES = AFCWood.values();
    }
}

