/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.fluids;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.fluids.AFCFluidId;
import com.therighthon.afc.common.fluids.SimpleAFCFluid;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class AFCFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"afc");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"afc");
    public static final int ALPHA_MASK = -16777216;
    public static final Map<SimpleAFCFluid, FluidHolder<BaseFlowingFluid>> SIMPLE_AFC_FLUIDS = Helpers.mapOf(SimpleAFCFluid.class, fluid -> AFCFluids.register(fluid.getId(), properties -> properties.block((Supplier)((Object)AFCBlocks.SIMPLE_FLUIDS.get(fluid))).bucket((Supplier)((Object)AFCItems.FLUID_BUCKETS.get(AFCFluidId.asType(fluid)))), AFCFluids.waterLike().descriptionId("fluid.afc." + fluid.getId()).canConvertToSource(false), BaseFlowingFluid.Source::new, BaseFlowingFluid.Flowing::new));

    private static <F extends FlowingFluid> FluidHolder<F> register(String name, Consumer<BaseFlowingFluid.Properties> builder, FluidType.Properties typeProperties, Function<BaseFlowingFluid.Properties, F> sourceFactory, Function<BaseFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid(FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new FluidType(typeProperties), sourceFactory, flowingFactory);
    }

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(PathType.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(true).canPushEntity(true).canSwim(true).supportsBoating(true);
    }
}

