/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.therighthon.afc.AFCHelpers;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.datagen.DataManagerProvider;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AFCFuelProvider
extends DataManagerProvider<Fuel> {
    public AFCFuelProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(Fuel.MANAGER, output, lookup);
    }

    @Override
    protected void addData(HolderLookup.Provider provider) {
        this.add(AFCWood.CYPRESS, 650.0f, 1000, 0.8f);
        this.add(AFCWood.TUALANG, 696.0f, 1300, 0.9f);
        this.add(AFCWood.HEVEA, 700.0f, 1800, 0.85f);
        this.add(AFCWood.TEAK, 720.0f, 1750, 0.95f);
        this.add(AFCWood.EUCALYPTUS, 720.0f, 2100, 0.9f);
        this.add(AFCWood.BAOBAB, 710.0f, 1100, 0.85f);
        this.add(AFCWood.FIG, 715.0f, 1900, 0.95f);
        this.add(AFCWood.MAHOGANY, 790.0f, 1600, 1.0f);
        this.add(AFCWood.IRONWOOD, 800.0f, 1400, 1.0f);
        this.add(AFCWood.IPE, 710.0f, 1700, 0.85f);
        this.add(AFCWood.ARAUCARIA, 690.0f, 1000, 0.75f);
        this.add(AFCWood.BEECH, 750.0f, 1800, 0.95f);
        this.add(AFCWood.GINKGO, 720.0f, 1800, 0.8f);
        this.add(AFCWood.MAHOE, 730.0f, 1700, 0.85f);
    }

    private void add(AFCWood wood, float temperature, int duration, float purity) {
        Map<Wood.BlockType, AFCBlocks.Id<Block>> blocks = AFCBlocks.WOODS.get((Object)wood);
        this.add(wood.getSerializedName() + "_logs", Ingredient.of(this.logsTagOf(Registries.ITEM, wood)), duration, temperature, purity);
        this.add(wood.getSerializedName() + "_planks", Ingredient.of((ItemLike[])new ItemLike[]{blocks.get(Wood.BlockType.PLANKS)}), (int)((float)duration * 0.4f), temperature + 50.0f, purity);
    }

    private void add(String name, Ingredient item, int duration, float temperature, float purity) {
        this.add(name, new Fuel(item, duration, temperature, purity));
    }

    private <T> TagKey<T> logsTagOf(ResourceKey<Registry<T>> registry, AFCWood wood) {
        return TagKey.create(registry, (ResourceLocation)AFCHelpers.modIdentifier(wood.getSerializedName() + "_logs"));
    }
}

