/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.therighthon.afc.common.AFCTags;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.AncientLogs;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.blocks.UniqueLogs;
import com.therighthon.afc.common.items.AFCItems;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class AFCItemTagProvider
extends ItemTagsProvider {
    public AFCItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, modId, existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.makeStandardLogTag(AFCWood.ARAUCARIA, AncientLogs.ANCIENT_ARAUCARIA, AFCTags.Items.ARAUCARIA_LOGS);
        this.makeStandardLogTag(AFCWood.BAOBAB, AncientLogs.ANCIENT_BAOBAB, AFCTags.Items.BAOBAB_LOGS);
        this.makeStandardLogTag(AFCWood.BEECH, AncientLogs.ANCIENT_BEECH, AFCTags.Items.BEECH_LOGS);
        this.makeStandardLogTag(AFCWood.CYPRESS, AncientLogs.ANCIENT_CYPRESS, AFCTags.Items.CYPRESS_LOGS);
        this.makeStandardLogTag(AFCWood.EUCALYPTUS, AncientLogs.ANCIENT_EUCALYPTUS, AFCTags.Items.EUCALYPTUS_LOGS);
        this.makeStandardLogTag(AFCWood.FIG, AncientLogs.ANCIENT_FIG, AFCTags.Items.FIG_LOGS);
        this.makeStandardLogTag(AFCWood.GINKGO, AncientLogs.ANCIENT_GINKGO, AFCTags.Items.GINKGO_LOGS);
        this.makeStandardLogTag(AFCWood.HEVEA, AncientLogs.ANCIENT_HEVEA, AFCTags.Items.HEVEA_LOGS);
        this.makeStandardLogTag(AFCWood.IPE, AncientLogs.ANCIENT_IPE, AFCTags.Items.IPE_LOGS);
        this.makeStandardLogTag(AFCWood.IRONWOOD, AncientLogs.ANCIENT_IRONWOOD, AFCTags.Items.IRONWOOD_LOGS);
        this.makeStandardLogTag(AFCWood.MAHOE, AncientLogs.ANCIENT_MAHOE, AFCTags.Items.MAHOE_LOGS);
        this.makeStandardLogTag(AFCWood.MAHOGANY, AncientLogs.ANCIENT_MAHOGANY, AFCTags.Items.MAHOGANY_LOGS);
        this.makeStandardLogTag(AFCWood.TEAK, AncientLogs.ANCIENT_TEAK, AFCTags.Items.TEAK_LOGS);
        this.makeStandardLogTag(AFCWood.TUALANG, AncientLogs.ANCIENT_TUALANG, AFCTags.Items.TUALANG_LOGS);
        this.makeUniqueLogTag(UniqueLogs.BLACK_OAK, AncientLogs.ANCIENT_BLACK_OAK, AFCTags.Items.BLACK_OAK_LOGS);
        this.tag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Helpers.identifier((String)"oak_logs"))).addTag(AFCTags.Items.BLACK_OAK_LOGS);
        this.makeUniqueLogTag(UniqueLogs.GUM_ARABIC, AncientLogs.ANCIENT_GUM_ARABIC, AFCTags.Items.GUM_ARABIC_LOGS);
        this.tag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Helpers.identifier((String)"acacia_logs"))).addTag(AFCTags.Items.GUM_ARABIC_LOGS);
        this.makeUniqueLogTag(UniqueLogs.POPLAR, AncientLogs.ANCIENT_POPLAR, AFCTags.Items.POPLAR_LOGS);
        this.tag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Helpers.identifier((String)"aspen_logs"))).addTag(AFCTags.Items.POPLAR_LOGS);
        this.makeUniqueLogTag(UniqueLogs.RAINBOW_EUCALYPTUS, AncientLogs.ANCIENT_RAINBOW_EUCALYPTUS, AFCTags.Items.RAINBOW_EUCALYPTUS_LOGS);
        this.tag(AFCTags.Items.EUCALYPTUS_LOGS).addTag(AFCTags.Items.RAINBOW_EUCALYPTUS_LOGS);
        this.makeUniqueLogTag(UniqueLogs.REDCEDAR, AncientLogs.ANCIENT_REDCEDAR, AFCTags.Items.REDCEDAR_LOGS);
        this.tag(AFCTags.Items.CYPRESS_LOGS).addTag(AFCTags.Items.REDCEDAR_LOGS);
        this.makeUniqueLogTag(UniqueLogs.RUBBER_FIG, AncientLogs.ANCIENT_RUBBER_FIG, AFCTags.Items.RUBBER_FIG_LOGS);
        this.tag(AFCTags.Items.FIG_LOGS).addTag(AFCTags.Items.RUBBER_FIG_LOGS);
        this.tag(ItemTags.LOGS_THAT_BURN).addTags(new TagKey[]{AFCTags.Items.BAOBAB_LOGS, AFCTags.Items.CYPRESS_LOGS, AFCTags.Items.EUCALYPTUS_LOGS, AFCTags.Items.FIG_LOGS, AFCTags.Items.HEVEA_LOGS, AFCTags.Items.IPE_LOGS, AFCTags.Items.IRONWOOD_LOGS, AFCTags.Items.MAHOGANY_LOGS, AFCTags.Items.TEAK_LOGS, AFCTags.Items.TUALANG_LOGS, AFCTags.Items.ARAUCARIA_LOGS, AFCTags.Items.BEECH_LOGS, AFCTags.Items.GINKGO_LOGS, AFCTags.Items.MAHOE_LOGS});
        this.addAllAFCWoods(Wood.BlockType.PLANKS, (TagKey<Item>)ItemTags.PLANKS);
        this.addAllAFCWoods(Wood.BlockType.DOOR, (TagKey<Item>)ItemTags.WOODEN_DOORS);
        this.addAllAFCWoods(Wood.BlockType.TRAPDOOR, (TagKey<Item>)ItemTags.WOODEN_TRAPDOORS);
        this.addAllAFCWoods(Wood.BlockType.FENCE, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        this.addAllAFCWoods(Wood.BlockType.LOG_FENCE, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        this.addAllAFCWoods(Wood.BlockType.FENCE_GATE, (TagKey<Item>)ItemTags.FENCE_GATES);
        this.addAllAFCWoods(Wood.BlockType.BUTTON, (TagKey<Item>)ItemTags.BUTTONS);
        this.addAllAFCWoods(Wood.BlockType.PRESSURE_PLATE, (TagKey<Item>)ItemTags.WOODEN_PRESSURE_PLATES);
        this.addAllAFCWoods(Wood.BlockType.SLAB, (TagKey<Item>)ItemTags.WOODEN_SLABS);
        this.addAllAFCWoods(Wood.BlockType.STAIRS, (TagKey<Item>)ItemTags.WOODEN_STAIRS);
        this.addAllAFCWoods(Wood.BlockType.WORKBENCH, (TagKey<Item>)TFCTags.Items.WORKBENCHES);
        this.addAllAFCWoods(Wood.BlockType.CHEST, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        this.addAllAFCWoods(Wood.BlockType.TRAPPED_CHEST, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        this.addAllAFCWoods(Wood.BlockType.SIGN, (TagKey<Item>)ItemTags.SIGNS);
        this.addAllUniqueAFCWoods(UniqueLogs.BlockType.LOG_FENCE, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        AFCItems.SUPPORTS.forEach((w, i) -> this.tag(TFCTags.Items.SUPPORT_BEAMS).add((Object)i.asItem()));
        AFCItems.SIGNS.forEach((w, i) -> this.tag(ItemTags.SIGNS).add((Object)i.asItem()));
        AFCItems.LUMBER.forEach((w, i) -> this.tag(TFCTags.Items.LUMBER).add((Object)i.asItem()));
        AFCItems.CHEST_MINECARTS.forEach((w, i) -> this.tag(TFCTags.Items.MINECARTS).add((Object)i.asItem()));
        AFCBlocks.WOODS.forEach((w, i) -> this.tag(TFCTags.Items.CARRIED_BY_HORSE).add((Object)w.getBlock(Wood.BlockType.BARREL).get().asItem()).add((Object)w.getBlock(Wood.BlockType.CHEST).get().asItem()).add((Object)w.getBlock(Wood.BlockType.TRAPPED_CHEST).get().asItem()));
        AFCBlocks.WOODS.forEach((w, i) -> {
            this.tag(TFCTags.Items.MINECART_HOLDABLE).add((Object)w.getBlock(Wood.BlockType.BARREL).get().asItem());
            this.tag(TFCTags.Items.BARRELS).add((Object)w.getBlock(Wood.BlockType.BARREL).get().asItem());
        });
        this.tag(TFCTags.Items.TANNIN_LOGS).add((Object)AFCWood.CYPRESS.getBlock(Wood.BlockType.LOG).get().asItem()).add((Object)AFCWood.CYPRESS.getBlock(Wood.BlockType.WOOD).get().asItem()).add((Object)AFCWood.TEAK.getBlock(Wood.BlockType.LOG).get().asItem()).add((Object)AFCWood.TEAK.getBlock(Wood.BlockType.WOOD).get().asItem()).add((Object)AFCWood.EUCALYPTUS.getBlock(Wood.BlockType.LOG).get().asItem()).add((Object)AFCWood.EUCALYPTUS.getBlock(Wood.BlockType.WOOD).get().asItem()).add((Object)UniqueLogs.GUM_ARABIC.getBlock(UniqueLogs.BlockType.LOG).get().asItem()).add((Object)UniqueLogs.GUM_ARABIC.getBlock(UniqueLogs.BlockType.WOOD).get().asItem()).add((Object)UniqueLogs.REDCEDAR.getBlock(UniqueLogs.BlockType.LOG).get().asItem()).add((Object)UniqueLogs.REDCEDAR.getBlock(UniqueLogs.BlockType.WOOD).get().asItem()).add((Object)UniqueLogs.RAINBOW_EUCALYPTUS.getBlock(UniqueLogs.BlockType.LOG).get().asItem()).add((Object)UniqueLogs.RAINBOW_EUCALYPTUS.getBlock(UniqueLogs.BlockType.WOOD).get().asItem()).add((Object)UniqueLogs.BLACK_OAK.getBlock(UniqueLogs.BlockType.LOG).get().asItem()).add((Object)UniqueLogs.BLACK_OAK.getBlock(UniqueLogs.BlockType.WOOD).get().asItem());
        this.addAllAFCWoods(Wood.BlockType.TWIG, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.addAllUniqueAFCWoods(UniqueLogs.BlockType.TWIG, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.addAllAFCWoods(Wood.BlockType.TWIG, (TagKey<Item>)TFCTags.Items.TWIGS);
        this.addAllUniqueAFCWoods(UniqueLogs.BlockType.TWIG, (TagKey<Item>)TFCTags.Items.TWIGS);
        this.addAllAFCSpecies(TreeSpecies.BlockType.LEAVES, Wood.BlockType.LEAVES, (TagKey<Item>)ItemTags.LEAVES);
        this.addAllAFCSpecies(TreeSpecies.BlockType.FALLEN_LEAVES, Wood.BlockType.FALLEN_LEAVES, (TagKey<Item>)TFCTags.Items.FALLEN_LEAVES);
        this.addAllAFCSpecies(TreeSpecies.BlockType.SAPLING, Wood.BlockType.SAPLING, (TagKey<Item>)ItemTags.SAPLINGS);
        this.tag(TFCTags.Items.SWEETENERS).add((Object)AFCItems.BIRCH_SUGAR.asItem()).add((Object)AFCItems.MAPLE_SUGAR.asItem());
        for (Metal metal : Metal.values()) {
            if (!metal.allParts()) continue;
            for (AFCWood wood : AFCWood.values()) {
                this.tag(ItemTags.HANGING_SIGNS).add((Object)((Item)AFCItems.HANGING_SIGNS.get((Object)wood).get(metal).get()));
            }
        }
    }

    private void makeStandardLogTag(AFCWood logType, AncientLogs ancient, TagKey<Item> itemTag) {
        this.tag(itemTag).add((Object)logType.getBlock(Wood.BlockType.LOG).get().asItem()).add((Object)logType.getBlock(Wood.BlockType.WOOD).get().asItem()).add((Object)logType.getBlock(Wood.BlockType.STRIPPED_LOG).get().asItem()).add((Object)logType.getBlock(Wood.BlockType.STRIPPED_WOOD).get().asItem()).add((Object)ancient.getBlock(AncientLogs.BlockType.LOG).get().asItem()).add((Object)ancient.getBlock(AncientLogs.BlockType.WOOD).get().asItem());
    }

    private void makeUniqueLogTag(UniqueLogs logType, AncientLogs ancient, TagKey<Item> itemTag) {
        this.tag(itemTag).add((Object)logType.getBlock(UniqueLogs.BlockType.LOG).get().asItem()).add((Object)logType.getBlock(UniqueLogs.BlockType.WOOD).get().asItem()).add((Object)ancient.getBlock(AncientLogs.BlockType.LOG).get().asItem()).add((Object)ancient.getBlock(AncientLogs.BlockType.WOOD).get().asItem());
    }

    private void addAllAFCWoods(Wood.BlockType type, TagKey<Item> tagKey) {
        AFCBlocks.WOODS.forEach((s, m) -> this.tag(tagKey).add((Object)s.getBlock(type).get().asItem()));
    }

    private void addAllUniqueAFCWoods(UniqueLogs.BlockType type, TagKey<Item> tagKey) {
        AFCBlocks.UNIQUE_LOGS.forEach((s, m) -> this.tag(tagKey).add((Object)s.getBlock(type).get().asItem()));
    }

    private void addAllAFCSpecies(TreeSpecies.BlockType type, Wood.BlockType woodType, TagKey<Item> tagKey) {
        AFCBlocks.TREE_SPECIES.forEach((s, m) -> this.tag(tagKey).add((Object)s.getBlock(type).get().asItem()));
        this.addAllAFCWoods(woodType, tagKey);
    }
}

