/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.datagen;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class DataManagerProvider<T>
implements DataProvider {
    private final DataManager<T> manager;
    private final CompletableFuture<HolderLookup.Provider> lookup;
    private final ImmutableMap.Builder<ResourceLocation, T> elements;
    private final PackOutput.PathProvider path;
    protected final CompletableFuture<?> contentDone;

    protected DataManagerProvider(DataManager<T> manager, PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        this.manager = manager;
        this.lookup = lookup;
        this.elements = ImmutableMap.builder();
        this.path = output.createPathProvider(PackOutput.Target.DATA_PACK, "tfc/" + manager.getName());
        this.contentDone = new CompletableFuture();
    }

    public void run(HolderLookup.Provider lookup) {
        this.addData(lookup);
        this.manager.bindValues((Map)this.elements.buildOrThrow());
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.beforeRun().thenCompose(provider -> {
            this.addData((HolderLookup.Provider)provider);
            ImmutableMap map = this.elements.buildOrThrow();
            this.manager.bindValues((Map)map);
            this.contentDone.complete(null);
            return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(e -> DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)provider, (Codec)this.manager.codec(), e.getValue(), (Path)this.path.json((ResourceLocation)e.getKey()))).toArray(CompletableFuture[]::new));
        });
    }

    public CompletableFuture<?> output() {
        return this.contentDone;
    }

    public final String getName() {
        return "Data Manager (" + this.manager.getName() + ")";
    }

    protected final void add(String name, T value) {
        this.add(Helpers.identifier((String)name.toLowerCase(Locale.ROOT)), value);
    }

    protected final void add(ResourceLocation name, T value) {
        this.elements.put((Object)name, value);
    }

    protected final void add(DataManager.Reference<T> reference, T value) {
        this.elements.put((Object)reference.id(), value);
    }

    protected CompletableFuture<HolderLookup.Provider> beforeRun() {
        return this.lookup;
    }

    protected abstract void addData(HolderLookup.Provider var1);
}

