/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.event;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.TreeSpecies;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;

public class ModEvents {
    public static void initFLCompat() {
    }

    @SubscribeEvent
    public static void onPackFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            ResourceLocation location = Helpers.resourceLocation((String)"afc", (String)"data");
            event.addPackFinders(location, PackType.SERVER_DATA, (Component)Component.literal((String)"AFC: Data Overload"), PackSource.DEFAULT, true, Pack.Position.TOP);
        }
    }

    @SubscribeEvent
    public static void addToBlockEntities(BlockEntityTypeAddBlocksEvent event) {
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.CHEST.get(), Wood.BlockType.CHEST, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), Wood.BlockType.TRAPPED_CHEST, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.LOOM.get(), Wood.BlockType.LOOM, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BARREL.get(), Wood.BlockType.BARREL, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.SLUICE.get(), Wood.BlockType.SLUICE, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BOOKSHELF.get(), Wood.BlockType.BOOKSHELF, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), Wood.BlockType.TOOL_RACK, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.LECTERN.get(), Wood.BlockType.LECTERN, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.AXLE.get(), Wood.BlockType.AXLE, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BLADED_AXLE.get(), Wood.BlockType.BLADED_AXLE, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), Wood.BlockType.WATER_WHEEL, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.WINDMILL.get(), Wood.BlockType.WINDMILL, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.SIGN.get(), Wood.BlockType.SIGN, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.SIGN.get(), Wood.BlockType.WALL_SIGN, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.CLUTCH.get(), Wood.BlockType.CLUTCH, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.GEAR_BOX.get(), Wood.BlockType.GEAR_BOX, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.SHELF.get(), Wood.BlockType.SHELF, event);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.ENCASED_AXLE.get(), Wood.BlockType.ENCASED_AXLE, event);
        ModEvents.modifySapling((BlockEntityType)TFCBlockEntities.TICK_COUNTER.get(), event);
        for (Metal metal : Metal.values()) {
            if (!metal.allParts()) continue;
            for (AFCWood wood : AFCWood.values()) {
                ModEvents.modifyBlockEntityType((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), Stream.of((Block)AFCBlocks.CEILING_HANGING_SIGNS.get((Object)wood).get(metal).get()), event);
                ModEvents.modifyBlockEntityType((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), Stream.of((Block)AFCBlocks.WALL_HANGING_SIGNS.get((Object)wood).get(metal).get()), event);
            }
        }
    }

    private static void modifyWood(BlockEntityType<?> type, Wood.BlockType blockType, BlockEntityTypeAddBlocksEvent event) {
        ModEvents.modifyBlockEntityType(type, AFCBlocks.WOODS.values().stream().map(map -> (Block)((AFCBlocks.Id)map.get(blockType)).get()), event);
    }

    private static void modifySapling(BlockEntityType<?> type, BlockEntityTypeAddBlocksEvent event) {
        ModEvents.modifyBlockEntityType(type, AFCBlocks.WOODS.values().stream().map(map -> (Block)((AFCBlocks.Id)map.get(Wood.BlockType.SAPLING)).get()), event);
        ModEvents.modifyBlockEntityType(type, AFCBlocks.TREE_SPECIES.values().stream().map(map -> (Block)((AFCBlocks.Id)map.get((Object)TreeSpecies.BlockType.SAPLING)).get()), event);
    }

    private static void modifyBlockEntityType(BlockEntityType<?> type, Stream<Block> extraBlocks, BlockEntityTypeAddBlocksEvent event) {
        extraBlocks.forEach(block -> event.modify(type, new Block[]{block}));
    }
}

