/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.event;

import com.therighthon.afc.client.render.AFCHangingSignBlockEntityRenderer;
import com.therighthon.afc.client.render.colors.AFCColors;
import com.therighthon.afc.common.blockentities.AFCBlockEntities;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.FLCompatBlocks;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.entities.AFCEntities;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.client.ColorMapReloadListener;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.model.entity.HorseChestLayer;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.client.render.entity.TFCChestBoatRenderer;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="afc", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventClientBusEvents {
    public static void registerColorHandlerBlocks(RegisterColorHandlersEvent.Block event) {
        BlockColor foliageColor = (state, level, pos, tintIndex) -> TFCColors.getFoliageColor((BlockPos)pos, (int)tintIndex);
        BlockColor kapokFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getKapokFoliageColor(pos, tintIndex, TreeSpecies.RED_SILK_COTTON.autumnIndex());
        BlockColor jacarandaFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getJacarandaFoliageColor(pos, tintIndex, TreeSpecies.GIANT_ROSEWOOD.autumnIndex());
        BlockColor yellowIpeFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getYellowIpeFoliageColor(pos, tintIndex, AFCWood.IPE.autumnIndex());
        BlockColor flameOfTheForestFoliageColor = (state, level, pos, tintIndex) -> AFCColors.getFlameOfTheForestFoliageColor(pos, tintIndex, TreeSpecies.FLAME_OF_THE_FOREST.autumnIndex());
        AFCBlocks.WOODS.forEach((wood, reg) -> event.register(wood.isConifer() ? foliageColor : (wood == AFCWood.IPE ? yellowIpeFoliageColor : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)wood.autumnIndex())), new Block[]{(Block)((RegistryObject)reg.get(Wood.BlockType.LEAVES)).get(), (Block)((RegistryObject)reg.get(Wood.BlockType.FALLEN_LEAVES)).get()}));
        AFCBlocks.TREE_SPECIES.forEach((wood, reg) -> event.register(wood.isConifer() ? foliageColor : (wood == TreeSpecies.RED_SILK_COTTON ? kapokFoliageColor : (wood == TreeSpecies.FLAME_OF_THE_FOREST ? flameOfTheForestFoliageColor : (wood == TreeSpecies.GIANT_ROSEWOOD ? jacarandaFoliageColor : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)wood.autumnIndex())))), new Block[]{(Block)((RegistryObject)reg.get((Object)TreeSpecies.BlockType.LEAVES)).get(), (Block)((RegistryObject)reg.get((Object)TreeSpecies.BlockType.FALLEN_LEAVES)).get()}));
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        ItemColors registry = event.getItemColors();
        ItemColor seasonalFoliageColor = (stack, tintIndex) -> TFCColors.getFoliageColor(null, (int)tintIndex);
        AFCBlocks.WOODS.forEach((wood, reg) -> registry.m_92689_(seasonalFoliageColor, new ItemLike[]{(ItemLike)((RegistryObject)reg.get(Wood.BlockType.LEAVES)).get(), (ItemLike)((RegistryObject)reg.get(Wood.BlockType.FALLEN_LEAVES)).get()}));
        AFCBlocks.TREE_SPECIES.forEach((key, value) -> registry.m_92689_(seasonalFoliageColor, new ItemLike[]{(ItemLike)((RegistryObject)value.get((Object)TreeSpecies.BlockType.LEAVES)).get(), (ItemLike)((RegistryObject)value.get((Object)TreeSpecies.BlockType.FALLEN_LEAVES)).get()}));
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType solid = RenderType.m_110451_();
        RenderType cutout = RenderType.m_110463_();
        RenderType cutoutMipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        Predicate<RenderType> ghostBlock = rt -> rt == cutoutMipped || rt == Sheets.m_110792_();
        Predicate<RenderType> leafPredicate = layer -> Minecraft.m_91405_() ? layer == cutoutMipped : layer == solid;
        AFCBlocks.WOODS.values().forEach(map -> {
            Stream.of(Wood.BlockType.SAPLING, Wood.BlockType.DOOR, Wood.BlockType.TRAPDOOR, Wood.BlockType.FENCE, Wood.BlockType.FENCE_GATE, Wood.BlockType.BUTTON, Wood.BlockType.PRESSURE_PLATE, Wood.BlockType.SLAB, Wood.BlockType.STAIRS, Wood.BlockType.TWIG, Wood.BlockType.BARREL, Wood.BlockType.SCRIBING_TABLE, Wood.BlockType.JAR_SHELF, Wood.BlockType.POTTED_SAPLING, Wood.BlockType.ENCASED_AXLE, Wood.BlockType.CLUTCH, Wood.BlockType.GEAR_BOX, Wood.BlockType.SEWING_TABLE).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), (RenderType)cutout));
            Stream.of(Wood.BlockType.LEAVES, Wood.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), (Predicate)leafPredicate));
        });
        AFCBlocks.TREE_SPECIES.values().forEach(map -> {
            Stream.of(TreeSpecies.BlockType.SAPLING, TreeSpecies.BlockType.POTTED_SAPLING).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), (RenderType)cutout));
            Stream.of(TreeSpecies.BlockType.LEAVES, TreeSpecies.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), (Predicate)leafPredicate));
        });
        event.enqueueWork(() -> {
            AFCBlocks.WOODS.values().forEach(map -> ItemProperties.register((Item)((Block)((RegistryObject)map.get(Wood.BlockType.BARREL)).get()).m_5456_(), (ResourceLocation)Helpers.identifier((String)"sealed"), (stack, level, entity, unused) -> stack.m_41782_() ? 1.0f : 0.0f));
            AFCBlocks.WOODS.forEach((wood, map) -> {
                HorseChestLayer.registerChest((Item)((Block)((RegistryObject)map.get(Wood.BlockType.CHEST)).get()).m_5456_(), (ResourceLocation)Helpers.identifier((String)("textures/entity/chest/horse/" + wood.m_7912_() + ".png")));
                HorseChestLayer.registerChest((Item)((Block)((RegistryObject)map.get(Wood.BlockType.TRAPPED_CHEST)).get()).m_5456_(), (ResourceLocation)Helpers.identifier((String)("textures/entity/chest/horse/" + wood.m_7912_() + ".png")));
                HorseChestLayer.registerChest((Item)((Block)((RegistryObject)map.get(Wood.BlockType.BARREL)).get()).m_5456_(), (ResourceLocation)Helpers.identifier((String)("textures/entity/chest/horse/" + wood.m_7912_() + "_barrel.png")));
            });
        });
        for (AFCWood wood : AFCWood.VALUES) {
            Sheets.addWoodType((WoodType)wood.getVanillaWoodType());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)AFCBlocks.TREE_TAP.get()), (RenderType)RenderType.m_110463_());
    }

    public static void clientFLCompatSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.m_110463_();
        FLCompatBlocks.JARBNETS.values().forEach(map -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)map.get()), (RenderType)cutout));
        FLCompatBlocks.FOOD_SHELVES.values().forEach(map -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)map.get()), (RenderType)cutout));
        FLCompatBlocks.HANGERS.values().forEach(map -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)map.get()), (RenderType)cutout));
        FLCompatBlocks.BARREL_PRESSES.values().forEach(map -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)map.get()), (RenderType)cutout));
        FLCompatBlocks.STOMPING_BARRELS.values().forEach(map -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)map.get()), (RenderType)cutout));
    }

    public static void onLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition boatLayer = BoatModel.m_246613_();
        LayerDefinition chestLayer = ChestBoatModel.m_247175_();
        for (AFCWood wood : AFCWood.VALUES) {
            event.registerLayerDefinition(TFCBoatRenderer.boatName((String)wood.m_7912_()), () -> boatLayer);
            event.registerLayerDefinition(TFCChestBoatRenderer.chestBoatName((String)wood.m_7912_()), () -> chestLayer);
        }
    }

    public static void onEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        for (AFCWood wood : AFCWood.VALUES) {
            event.registerEntityRenderer((EntityType)AFCEntities.BOATS.get((Object)wood).get(), ctx -> new TFCBoatRenderer(ctx, wood.m_7912_()));
            event.registerEntityRenderer((EntityType)AFCEntities.CHEST_BOATS.get((Object)wood).get(), ctx -> new TFCChestBoatRenderer(ctx, wood.m_7912_()));
        }
        event.registerBlockEntityRenderer((BlockEntityType)AFCBlockEntities.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)AFCBlockEntities.HANGING_SIGN.get(), AFCHangingSignBlockEntityRenderer::new);
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageJacarandaColors, AFCColors.FOLIAGE_JACARANDA_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageYellowColors, AFCColors.FOLIAGE_YELLOW_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageOrangeColors, AFCColors.FOLIAGE_ORANGE_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(AFCColors::setFoliageRedColors, AFCColors.FOLIAGE_RED_COLORS_LOCATION));
    }
}

