/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.event;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.therighthon.afc.AFC;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.FLCompatBlocks;
import com.therighthon.afc.event.ModEventClientBusEvents;
import com.therighthon.afc.mixin.BlockEntityTypeAccessor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

public class ModEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModEvents::setup);
        bus.addListener(ModEvents::onPackFinder);
    }

    public static void initFLCompat() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModEvents::setupFLCompat);
        bus.addListener(ModEvents::onFLCompatPackFinder);
        bus.addListener(ModEvents::onFLCompatDataPackFinder);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(ModEventClientBusEvents::clientFLCompatSetup);
        }
    }

    private static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AFCBlocks.registerFlowerPotFlowers();
            ModEvents.modifyBlockEntityTypes();
        });
    }

    private static void setupFLCompat(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModEvents.modifyFLBlockEntityTypes());
    }

    public static void onPackFinder(AddPackFindersEvent event) {
        block8: {
            try {
                if (event.getPackType() != PackType.CLIENT_RESOURCES) break block8;
                IModFile modFile = ModList.get().getModFileById("afc").getFile();
                Path resourcePath = modFile.getFilePath();
                try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":overload", true, resourcePath){
                    private final IModFile file = ModList.get().getModFileById("afc").getFile();

                    @NotNull
                    protected Path resolve(String ... paths) {
                        return this.file.findResource(paths);
                    }
                };){
                    PackMetadataSection metadata = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
                    if (metadata != null) {
                        AFC.LOGGER.info("Injecting ArborFirmaCraft override pack");
                        event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"afc_data", (Component)Component.m_237113_((String)"ArborFirmaCraft Resources"), (boolean)true, id -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onFLCompatPackFinder(AddPackFindersEvent event) {
        block8: {
            try {
                if (event.getPackType() != PackType.CLIENT_RESOURCES) break block8;
                Path resourcePath = ModList.get().getModFileById("afc").getFile().findResource(new String[]{"firmalife_compat_assets"});
                try (PathPackResources pack = new PathPackResources("firmalife_compat_assets", true, resourcePath);){
                    PackMetadataSection metadata = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
                    if (metadata != null) {
                        AFC.LOGGER.info("Adding FirmaLife compatibility resource pack");
                        event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"firmalife_compat_assets", (Component)Component.m_237113_((String)"FirmaLife Compat Resources"), (boolean)true, id -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onFLCompatDataPackFinder(AddPackFindersEvent event) {
        block8: {
            try {
                if (event.getPackType() != PackType.SERVER_DATA) break block8;
                Path resourcePath = ModList.get().getModFileById("afc").getFile().findResource(new String[]{"firmalife_compat_data"});
                try (PathPackResources pack = new PathPackResources("firmalife_compat_data", true, resourcePath);){
                    PackMetadataSection metadata = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
                    if (metadata != null) {
                        AFC.LOGGER.info("Adding FirmaLife compatibility data pack");
                        event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"firmalife_compat_data", (Component)Component.m_237113_((String)"FirmaLife Compat Data"), (boolean)true, id -> pack, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void modifyBlockEntityTypes() {
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.CHEST.get(), Wood.BlockType.CHEST);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), Wood.BlockType.TRAPPED_CHEST);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.LOOM.get(), Wood.BlockType.LOOM);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BARREL.get(), Wood.BlockType.BARREL);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.SLUICE.get(), Wood.BlockType.SLUICE);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BOOKSHELF.get(), Wood.BlockType.BOOKSHELF);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), Wood.BlockType.TOOL_RACK);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.LECTERN.get(), Wood.BlockType.LECTERN);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.AXLE.get(), Wood.BlockType.AXLE);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.BLADED_AXLE.get(), Wood.BlockType.BLADED_AXLE);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), Wood.BlockType.WATER_WHEEL);
        ModEvents.modifyWood((BlockEntityType)TFCBlockEntities.WINDMILL.get(), Wood.BlockType.WINDMILL);
    }

    private static void modifyWood(BlockEntityType<?> type, Wood.BlockType blockType) {
        ModEvents.modifyBlockEntityType(type, AFCBlocks.WOODS.values().stream().map(map -> (Block)((RegistryObject)map.get(blockType)).get()));
    }

    private static void modifyFLBlockEntityTypes() {
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.BAOBAB).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.EUCALYPTUS).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.MAHOGANY).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.HEVEA).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.TUALANG).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.TEAK).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.CYPRESS).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.FIG).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.IRONWOOD).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), Stream.of((Block)FLCompatBlocks.STOMPING_BARRELS.get((Object)AFCWood.IPE).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.BAOBAB).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.EUCALYPTUS).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.MAHOGANY).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.HEVEA).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.TUALANG).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.TEAK).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.CYPRESS).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.FIG).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.IRONWOOD).get()));
        ModEvents.modifyBlockEntityType((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), Stream.of((Block)FLCompatBlocks.BARREL_PRESSES.get((Object)AFCWood.IPE).get()));
    }

    private static void modifyBlockEntityType(BlockEntityType<?> type, Stream<Block> extraBlocks) {
        Set<Block> blocks = ((BlockEntityTypeAccessor)type).accessor$getValidBlocks();
        blocks = new HashSet<Block>(blocks);
        blocks.addAll(extraBlocks.collect(Collectors.toList()));
        ((BlockEntityTypeAccessor)type).accessor$setValidBlocks(blocks);
    }
}

