-- Used for ThDilos Fox Origin || ThDilos Fox Origin Expanded
-- Some of the functions can be reused for other Origin Avatar script :3

--[[
Here is how to use it:
1. Drag this script into your Avatar Folder
2. In your Avatar's Script, create a variable of this script, e.g. local fox_origin = require("fox_origin")
3. Then, you can access the run time variable of the Fox Origin and its Evolutions, by using fox_origin.[variable]
    E.g. pouncing = fox_origin.pouncing
    You can use the variable like this: 
        animations.model.pounce:setPlaying(pouncing == 1)
4. Currently there is not many variables registered in this script, you can ask me on Discord if you want more :3


--]]

local setEnabled = true -- Whether to enable this script

-- Registering game state
local isFabric, isHigherVersion, originEnabled

-- Get Current Origin
local evolutionEnabled

local powerList -- The Table of Powers

-- Data to be ported to your script
local data = {
    -- You set "enabled" to true AND your current origin is my Fox / Fox Evolution
    enabled = true, -- [true, false]

    -- Passive Skill [Fluffy]: When shaking triggered = 1; Else = 0
    is_shaking = 0, -- [0, 1]

    -- Active Skill [Foxify]: The exact afk_timer from the power. 
    -- If you moved, 1200; Ticking down to 0;
    -- If reach 0, enter [Sleepin Mode] where you turn into a fox
    afk_timer = 1200, -- [0, 1200]

    -- Active Skill [Pounce]: When Pounced, BEFORE LANDING = 1; Else = 0
    pouncing = 0, -- [0, 1]

    -- ############################################################################ --
    -- ## Below only applies if you have Evolution Foxes installed in the server ## --
    -- ############################################################################ --
    -- Karma MAGNITUDE
    -- Is the max value between karma_n and karma_p. and equal to 2000
    -- If you unlocked either Kitsune or Ninetails, Karma is always 2000
    karma = 0, -- [0, 2000]

    -- Whether you unlocked either Kitsune or Ninetails
    lock_karmic = 1, -- [true, false]

    -- Negative and Positive Karma VALUE
    -- If either is NOT -1, it means the player is progressing towards that path (negative or positive)
    karma_n = -1, -- [-1, 2000]
    karma_p = -1, -- [-1, 2000]

    fear = 0, -- [true, false]

    -- Current Evolution (If you have Evolution)
    currentEvolution = "" -- ["thorigins:default_fox" / "thorigins:fire_fox" / "thorigins:lightning_fox" / "thorigins:kitsune" / "thorigins:ninetails" / "thorigins:ice_fox"]
}

-- Run After initialised
function events.entity_init()
    -- Better surround everything inside an isLoaded than never :3
    if player:isLoaded() then
        -- Check if server is using fabric Origin
        isFabric = player:getNbt()["cardinal_components"] ~= nil
        -- Check if Origins are enabled on this server at all
        originEnabled = isFabric or player:getNbt()["ForgeCaps"] ~= nil

        if originEnabled then
            if isFabric then
                -- Check if the server is using 1.21+ Origin
                isHigherVersion = player:getNbt()["cardinal_components"]["apoli:powers"]["Powers"] == nil
            end
            evolutionEnabled = getOriginInLayer("thorigins:origin") ~= nil
            updatePowerList()
        else
            data.enabled = false
        end
    end
end

-- A function used to get value across versions
-- Return value if founded, else return the caller's value
function getValue(index, path, itself)
    -- UpdatePower List
    if isFabric then
        if isHigherVersion then
            if powerList[index]["id"] == path then
                return powerList[index]["data"] -- Fabric 1.21+
            end
        else
            if powerList[index]["Type"] == path then
                return powerList[index]["Data"] -- Fabric <1.21
            end
        end
    else
        if powerList[index]["Type"] == path then
            return powerList[index]["Data"].Value -- Forge
        end
    end
    return itself
end

-- Get current origin of layer, across versions [return String]
function getOriginInLayer(lay)
    local originPath
    if isFabric then
        originPath = player:getNbt()["cardinal_components"]["origins:origin"]["OriginLayers"]

        -- What is it with LUA obsession with indexing from 1 ?! huhhhh????!?!?
        for index = 1, 65535, 1 do
            if originPath[index] == nil then break end

            if originPath[index]["Layer"] == lay then
                return originPath[index]["Origin"]
            end
        end
    else
        originPath = player:getNbt()["ForgeCaps"]["origins:origins"]["Origins"]
        for layer, origin in pairs(originPath) do
            if layer == lay then
                return origin
            end
        end
    end
    return nil
end 

-- Update powerTable
function updatePowerList()
    if isFabric then
        -- Register the Power NBT Path
        if isHigherVersion then
            powerList = player:getNbt()["cardinal_components"]["apoli:powers"]["powers"]
        else
            powerList = player:getNbt()["cardinal_components"]["apoli:powers"]["Powers"]
        end
    else
        if player:getNbt()["ForgeCaps"] ~= nil then
            powerList = player:getNbt()["ForgeCaps"]["apoli:powers"]["Powers"]
        end
    end
end

-- A mysterious function inspired by Splat from Discord
function getPower(t)
    temp = 0
    for _,_,_ in pairs(t) do
        temp = temp + 1
    end
    return temp
end
-- After Luaing for some time, this might actually be a function used to get the number of powers
-- The function might actually create a variable called temp which you can use afterwards?
-- Can't we just do a for loop from 1 to a big number, and break if nil? [Like the getOriginInLayer function]
-- Reducing the number of for loop from 2 to 1?
-- idk but Splat is more familiar with Lua than me so... :3
-- "Do not touch something if it's working."

-- Key to enable the tick locally
local fwd = keybinds:fromVanilla("key.forward")
local tempSwitch = false
local permLock = false
local fearTemp = 0
local fearRecord = 0
local fearCD = 0

local fearStore2 = -1

-- Dynamically Get Power Data
function events.tick()
    if player:isLoaded() then
        if fwd:isPressed() and not tempSwitch and not permLock and setEnabled then
            if not (avatar:getPermissionLevel() == "MAX") then
                print("This avatar requires \"Max\" Avatar Permission!\nOrigins Related Features are disabled")
                permLock = true
                setEnabled = false
                data.enabled = false
            else
                tempSwitch = true
            end
        end

        if setEnabled and originEnabled and tempSwitch then
            local currentOrigin = getOriginInLayer("origins:origin")
            local isFox = currentOrigin == "thorigins:fox" or currentOrigin == "thorigins:element_fox"

            -- Disable the script if you are not a fox, or disabled it yourself from above
            data.enabled = isFox and setEnabled
            -- Update Current Evolution
            if evolutionEnabled then
                data.currentEvolution = getOriginInLayer("thorigins:origin")
            end

            updatePowerList() -- Update PowerList dynamically
            getPower(powerList) -- Retrieve the number of powers the player has
            for index = 1, temp do
                -- This resource is for shaking, specifically created for this script to detect
                data.is_shaking = getValue(index, "thorigins:fox/thfluffy_is_shaking", data.is_shaking)
                -- This resource is for tracking [Sleepin Mode] [0, 1200]
                data.afk_timer = getValue(index, "thorigins:fox/thfoxify_afk_timer", data.afk_timer)
                -- This resource is for pouncing [0 / 1]
                data.pouncing = getValue(index, "thorigins:fox/thdash_left_ground", getValue(index, "thorigins:kitsune/thdash2_left_ground", getValue(index, "thorigins:ninetails/thdash3_left_ground", data.pouncing)))
                if evolutionEnabled then
                    -- Check Karma Value
                    data.karma_n = getValue(index, "thorigins:thkarma_karma_n", data.karma_n)
                    data.karma_p = getValue(index, "thorigins:thkarma_karma_p", data.karma_p)

                    -- Check if both Kitsune / Ninetails are locked 
                    data.lock_karmic = math.floor(getValue(index, "thorigins:thtransform_lock_kitsune", data.lock_karmic) + getValue(index, "thorigins:thtransform_lock_ninetails", data.lock_karmic) / 2)
                    -- If yes, take the highest between positive and negative karma
                    if data.lock_karmic == 1 then
                        data.karma = math.max(data.karma_p, data.karma_n)
                    -- Else, karma = 2000 (Maximum allowed)
                    else
                        data.karma = 2000
                    end
                end
                -- For Fearing [0/1]             
                -- data.fear = getValue(index, "thorigins:fox/thtrackers_is_scared", data.fear)
                
                fearTemp = getValue(index, "thorigins:fox/thshy_fear_timer", getValue(index, "thorigins:thshy2_fear_timer", fearTemp))
                fearStore2 = getValue(index, "thorigins:fox/thshy_is_fearing", getValue(index, "thorigins:thshy2_is_fearing", fearStore2))
                if fearTemp ~= fearRecord and fearCD == 0 then
                    fearCD = 80
                    if fearRecord ~= 0 then
                        data.fear = 1
                    end
                    fearRecord = fearTemp
                end
            end
            if fearStore2 == -1 then
                if fearCD > 0 then
                    fearCD = fearCD - 1
                else
                    data.fear = 0
                end
            else            -- For Higher Fox Version (V4.3.1+)
                data.fear = fearStore2
            end
        end
    end
end

-- Return Data :3
return data