-- Auto generated script file --
-- Fox Origin Script, used to access its variables declared in "data"
-- Accessed by fox_origin.[variable]
local fox_origin = require("fox_origin")
local colorSelector = require("model_overlay")

-- Some variables
local rootModel = models.model.root
local userTailCount = 9
local displayedTailCount = 1
local availableTailCount = 1
local afkTimer = 0
local afkModeOn = false
local spinSpeed = 1

-- Tail models address
local tail = models.model.root.Body.Tail

vanilla_model.PLAYER:setVisible(false) -- Hide vanilla models cuz they are wierd for 4-footed fob
vanilla_model.CAPE:setVisible(false) -- You can draw cape using blockbench and set this to true
vanilla_model.ELYTRA:setVisible(false) -- Please use the elytra drawn in blockbench

renderer:setRenderRightArm(false) -- Hide First Person Hand cuz it's weird
models.model.Portrait:setVisible(true) -- Set Portrait to be Visible (In case I forgot to visible it in Blockbench), bascially your icon in Tab / Figura Menu

-- Set Armor Scales
rootModel.Head.HelmetPivot:setScale(0.82, 0.8, 0.7)

rootModel.Body.ChestplatePivot:setScale(0.62, 1.15, 1.05)
rootModel.LeftArm.LeftShoulderPivot:setScale(0.5)
rootModel.RightArm.RightShoulderPivot:setScale(0.5)

tail.Tail1.LeggingsPivot:setScale(0.5, 1, 0.8)
tail.Tail2.LeggingsPivot2:setScale(0.5, 1, 0.8)
tail.Tail3.LeggingsPivot3:setScale(0.5, 1, 0.8)
tail.Tail4.LeggingsPivot4:setScale(0.5, 1, 0.8)
tail.Tail5.LeggingsPivot5:setScale(0.5, 1, 0.8)
tail.Tail6.LeggingsPivot6:setScale(0.5, 1, 0.8)
tail.Tail7.LeggingsPivot7:setScale(0.5, 1, 0.8)
tail.Tail8.LeggingsPivot8:setScale(0.5, 1, 0.8)
tail.Tail9.LeggingsPivot9:setScale(0.5, 1, 0.8)
rootModel.LeftLeg.LeftLeggingPivot:setScale(0.45, 0.3, 0.45)
rootModel.RightLeg.RightLeggingPivot:setScale(0.45, 0.3, 0.45)
rootModel.LeftArm.LeftLeggingPivot2:setScale(0.45, 0.3, 0.45)
rootModel.RightArm.RightLeggingPivot2:setScale(0.45, 0.3, 0.45)

rootModel.LeftLeg.LeftBootPivot:setScale(0.4, 0.4, 0.4)
rootModel.RightLeg.RightBootPivot:setScale(0.4, 0.4, 0.4)
rootModel.LeftArm.LeftBootPivot2:setScale(0.4, 0.4, 0.4)
rootModel.RightArm.RightBootPivot2:setScale(0.4, 0.4, 0.4)

-- Animation Variables
local tail_wag = animations.model.tail_wag -- Ambient Tail Wagging :3
local crouch = animations.model.crouch -- Crouch
local shake = animations.model.shake -- Shake water / snow
local sit = animations.model.sit -- Sit
local close_wing = animations.model.close_wing -- Close wing when not fall flying
local sleep = animations.model.sleep -- Eepy
local stuck = animations.model.stuck -- stuck
local idle = animations.model.idle -- Idle Breathiign
local jump = animations.model.jump -- Jump
local flight = animations.model.flight -- Flight

local pounce = animations.model.pounce -- Triggered when Pounce, before landing
local sleep = animations.model.sleep -- Triggered when entered [Sleepin Mode]
local shake = animations.model.shake -- Triggered when shaking water / snow from Passive Skill [Fluffy]
local stuck = animations.model.stuck 
local scared = animations.model.fear
local foldTail = animations.model.tail_fold

-- The below animations manually turn the avatar 90 degrees so it wont look wierd
local swim = animations.model.swim -- Swim
local unswim = animations.model.unswim -- Unswim Animation
local sleepBed = animations.model.sleep_bed -- Bed Eepy
local fall_flying = animations.model.fall_flying -- Fall Flying
local riptide = animations.model.riptide -- Riptide Spin

-- Manual Animations
local agree = animations.model.agree -- Agree
local disagree = animations.model.disagree -- Disagree
local open_wing = animations.model.open_wing -- Open wing
local spin = animations.model.spin -- Spin
local attack = animations.model.attack -- Attack
local dilly_daily = animations.model.dilly_daily -- smh

-- Random Animations
local ear_twitch_l = animations.model.ear_twitch_l
local ear_twitch_r = animations.model.ear_twitch_r

-- Sounds Variables. Set up individually so you can set Subtitles for them
-- Used in Shake Animation
local wolf_shake = sounds["entity.wolf.shake"]
local cat_purr = sounds["entity.cat.purr"]

local back = keybinds:fromVanilla("key.back") -- Used in Crouching -> Reverse Crouch Animation
local headRotStore = models.model.root.Head:getRot().y
local bodyYVelStore = 0
local pingLimiter = 0 -- Used by jump anime

-- Pings to play Animations in Multiplayer
function pings.toggle(string)
    if string == "sit" then
        if sit:isPlaying() or sit:getPlayState() == "HOLDING" then
            sit:stop()
        else
            unsleepAnimation()
            sit:play()
        end
    elseif string == "afkMode" then
        spin:stop()
        sit:stop()
        dilly_daily:stop()
        sleep:stop()
        openEyes()
        afkModeOn = not afkModeOn
    elseif string == "sleep" then
        if (sleep:isPlaying() or sleep:getPlayState() == "HOLDING") then
            unsleepAnimation()
        else
            sleepAnimation()
        end
    elseif string == "agree" then
        agree:play()
    elseif string == "disagree" then
        disagree:play()
    elseif string == "toggleWings" then
        if overrideWing then
            overrideWing = false
            close_wing:play()
        else
            overrideWing = true
            close_wing:stop()
            open_wing:play()
        end
    elseif string == "spin" then
        spin:setSpeed(1)
        spin:setPlaying(not (spin:isPlaying() or spin:getPlayState() == "HOLDING"))
    elseif string == "attack" then
        sleep:stop()
        openEyes()
        dilly_daily:stop()
        sit:stop()
        if attack:isPlaying() or attack:getPlayState() == "HOLDING" then
            attack:stop()
        else
            attack:play()
        end
    elseif string == "dillyDaily1" then
        dilly_daily:setSpeed(1)
        sit:play()
        closeEyes()
        if dilly_daily:isPlaying() then
            dilly_daily:pause()
        else
            dilly_daily:play()
        end
    elseif string == "dillyDaily2" then
        dilly_daily:setSpeed(1)
        sit:stop()
        openEyes()
        dilly_daily:stop()
    elseif string == "foxAmbient" then
        local fox_ambient = sounds["entity.fox.ambient"]
        fox_ambient:setPos(player:getPos())
        fox_ambient:setSubtitle(player:getName() .. " Fox Noise")
        fox_ambient:setPitch(-player:getRot()[1] * 3 / 360 + 1.25) -- Range 0.5 -> 2.0, rotation based
        fox_ambient:play()
    elseif string == "wolfWhine" then
        local wolf_whine = sounds["entity.wolf.whine"]
        wolf_whine:setPos(player:getPos())
        wolf_whine:setSubtitle(player:getName() .. " Fox Whine")
        wolf_whine:setPitch(-player:getRot()[1] * 3 / 360 + 1.25) -- Range 0.5 -> 2.0, rotation based
        wolf_whine:play()
    elseif string == "jump" then
        jump:play()
    end
end

function pings.toggle1(string, extraVar)
    if string == "changeSpeed" then
        spin:setSpeed(extraVar)
        dilly_daily:setSpeed(extraVar)
    elseif string == "toggleEye" then
        if extraVar then
            openEyes()
        else
            closeEyes()
        end
    elseif string == "setTails" then
        userTailCount = math.clamp(extraVar, 1, 9)
    elseif string == "toggleArmorT" then
        toggleArmor(extraVar, true)
    elseif string == "toggleArmorF" then
        toggleArmor(extraVar, false)
    elseif string == "XSsize" then
        if extraVar then
            models:setScale(2, 2, 2)
        else
            models:setScale(1, 1, 1)
        end
    elseif string == "earTwitch" then
        if extraVar then
            ear_twitch_l:play()
        else
            ear_twitch_r:play()
        end
    end
end

local isPouncing = 0
local isShaking = 0
local fearTimer = 0

function pings.origin(i)
    if i == 1 then
        sleepAnimation()
    elseif i == 2 then
        unsleepAnimation()
    elseif i == 4 then
        isPouncing = 1
    elseif i == 5 then
        isPouncing = 0
    elseif i == 6 then
        isShaking = 1
    elseif i == 7 then
        isShaking = 0
    elseif i == 8 then
        stuck:play()
    elseif i == 9 then
        fearTimer = 40
    end
end

-- Tail start wagging from the beginning :3
tail_wag:play()

-- Some functions --
function sleepAnimation()
    closeEyes()
    sit:stop()
    tail_wag:stop()
    sleep:play()
    dilly_daily:stop()
end

function unsleepAnimation()
    sleepBed:stop()
    sleep:stop()
    openEyes()
    tail_wag:restart()
end

overrideWing = false -- If you manually opened wings in Emote
wasFallFlying = false -- If you entered fall Flying
-- These 2 achieves: If you manually opened wings, wings won't close at the next frame.
-- But if you just flew with wings, the overriding is gone and the wings close
function resetWing()
    if (player:getPose() == "FALL_FLYING") then
        wasFallFlying = true
    elseif (wasFallFlying) then
        wasFallFlying = false
    end
    if wasFallFlying and overrideWing then
        overrideWing = false
    end
    if not overrideWing then
        if not (player:getPose() == "FALL_FLYING" or shake:isPlaying()) then
            close_wing:play()
        else
            close_wing:stop()
        end
    end
end

-- Hide Vanilla Armor?
function toggleArmor(num, bol)
    if num == 0 then
        vanilla_model.HELMET:setVisible(bol)
    elseif num == 1 then
        vanilla_model.CHESTPLATE:setVisible(bol)
    elseif num == 2 then
        vanilla_model.LEGGINGS:setVisible(bol)
    elseif num == 3 then
        vanilla_model.BOOTS:setVisible(bol)
    else
        vanilla_model.HELMET:setVisible(bol)
        vanilla_model.CHESTPLATE:setVisible(bol)
        vanilla_model.LEGGINGS:setVisible(bol)
        vanilla_model.BOOTS:setVisible(bol)
    end
end

-- Close eyes when eepy
-- Close eyes by shifting UV of the Textures up by 1 pixel :3
local faceModel = models.model.root.Head.Eyes
function closeEyes()
    faceModel:setUV(0,1/32)
end
function openEyes()
    faceModel:setUV(0,0)
end

-- The name replacing your ign
function setName()
    -- Tick to HMS conversion
    local sec = math.floor(afkTimer / 20) % 60
    local min = math.floor(afkTimer / 1200) % 60
    local hour = math.floor(afkTimer / 72000) % 24
    local combined = ""

    -- Display AFK Message after 1200 ticks (1 irl Minute)
    if afkModeOn then
        if hour == 0 then
            combined = "\n[AFK] " .. string.format("%02d", min) .. ":" .. string.format("%02d",sec)
        else
            combined = "\n[AFK] " ..  hour .. ":" .. string.format("%02d", min) .. ":" .. string.format("%02d", sec)
        end
    end

    -- The string that will be set as name
    local str = 
    toJson(
        {
            player:getName()
            ,{ text = combined} -- AFK message
        }
    )
    -- Set name
    nameplate.ALL:setText(
        str
        --toJson({{ text = ''}})
    )
    nameplate.Entity:setPivot(0, 1.2, 0) -- NamePlate slightly above fox body
end

-- Convert Figura Json Color Code e.g. "#1234ff" to vec3, in range of 0-1
function hexToDec(str)
    local temp = {"", "", ""}
    local index = 2
    for i in string.gmatch(str, "[0-9a-z]") do
        if i ~= nil then
            temp[math.floor(index / 2)] = temp[math.floor(index / 2)] .. i
            index = index + 1
        end
    end
    local vec3 = vec(0, 0, 0)
    for j = 1,3,1
    do
        vec3[j] = tonumber(temp[j], 16) / 255
    end

    return vec3
end

-- Floppy ears :3
local lEarPath = models.model.root.Head.LeftEar -- Ear Path
local rEarPath = models.model.root.Head.RightEar
local storedY = 0
function setEarRot(y)
    if (y / (storedY + 0.001) > 10) then -- When the Force is too big, directly set storedY
        storedY = y
    else
        storedY = math.lerp(storedY + y, 0, 0.5) -- storedY goes back to 0
    end
    storedY = math.clamp(storedY, -70, 70)
    
    lEarPath:setRot(storedY, 0, 0)
    rEarPath:setRot(storedY, 0, 0)
end

local storedY2 = 0
function setTailRot(y)
    y = y * 80
    local currentTailRot = rootModel.Body.Tail:getRot()
    storedY2 = math.lerp(storedY2 + y, 0, 0.45) -- storedY2 goes back to 0
    storedY2 = math.clamp(storedY2, -20, 40)
    rootModel.Body.Tail:setRot(storedY2, currentTailRot.y, currentTailRot.z)
end

local twitchVar = 0
local delayTimer = 0
function handleEarTwitch()
    if delayTimer < 20 then
        delayTimer = delayTimer + 1
    else
        delayTimer = 0
        foo = math.random() + twitchVar
        if foo > 0.95 then
            twitchVar = 0
            pings.toggle1("earTwitch", true)
        elseif foo > 0.9 then
            twitchVar = 0
            pings.toggle1("earTwitch", false)
        else
            twitchVar = twitchVar + 0.01
        end
    end
end

-- To get your name if you are using this avatar, which is used in the following detection
local myName -- ? is this working at all?
-- GroanTube SoundEffect
-- Codes supported by Cosmic, GNUI <3
local playerVariables = {}
-- events.world_tick() will run even if you are offline
function events.world_tick()

        -- for loop sample from figuarea wiki
    for uuid, player in pairs(world.getPlayers()) do
       
        -- If the player is not in the table, shove them into it
        -- playerVariables[uuid] is a table with sound / tubePos instance unique for all table entries
        if not playerVariables[uuid] then
        playerVariables[uuid] = {
                groanTube0 = sounds["groantube_0"],
                groanTube1 = sounds["groantube_1"],
                tubePos = 0
            }
        end

        -- Tried to set the GoranTube color w.r.t different players' avatar color. I don't think it's working ;w;
        --models.model.Skull.GroanTube:setColor(hexToDec(avatar:getColor())) -- I wanted to do player:getAvatar():getColor() but it's not a thing ;w;
        
        -- Store into "variables" for easier referencing
        local variables = playerVariables[uuid]

        -- tubePos: 0 = default. 1 = going / went Up. 2 = going / went Down
        local tubePos = variables.tubePos
        local groanTube0 = variables.groanTube0
        local groanTube1 = variables.groanTube1
        local targetHasTube = player:getItem(6).id == "minecraft:player_head" and 
        player:getItem(6).tag.SkullOwner and 
        player:getItem(6).tag.SkullOwner.Name == myName
        if targetHasTube then
            if player:getRot()[1] < -30 and not groanTube0:isPlaying() and (variables.tubePos == 0 or variables.tubePos == 4) and variables.tubePos ~= 3 then
                groanTube1:stop()
                groanTube0:setSubtitle(player:getName() .. " uuuaaaaa")
                groanTube0:setPitch(1 + (math.random() - 0.5) * 0.2)
                groanTube0:setVolume(0.5)
                groanTube0:play()
                variables.tubePos = 1
            end
            if player:getRot()[1] > 30 and not groanTube1:isPlaying() and (variables.tubePos == 0 or variables.tubePos == 3)  and variables.tubePos ~= 4 then
                groanTube0:stop()
                groanTube1:setSubtitle(player:getName() .. " aaaaauuu")
                groanTube1:setPitch(1 + (math.random() - 0.5) * 0.2)
                groanTube1:setVolume(0.5)
                groanTube1:play()
                variables.tubePos = 2
            end

            if variables.tubePos == 1 and player:getRot()[1] >= -30 then
                groanTube0:stop()
                variables.tubePos = 0
            end
            if variables.tubePos == 2 and player:getRot()[1] <= 30 then
                groanTube1:stop()
                variables.tubePos = 0
            end

            if groanTube0:isPlaying() then
                groanTube0:setPos(player:getPos())
            elseif groanTube1:isPlaying() then
                groanTube1:setPos(player:getPos())
            end
        end
    end
end

-- Run After initialised
function events.entity_init()
    if player:isLoaded() then
        myName = player:getName()
    end
end

-- Ticking functions
function events.tick()
    if player:isLoaded() then
        -- Shared Functions       
        -- CloseWing play or stop under various conditions
        resetWing()
        setName()
        -- This portion of code are hidden if you are using the Fox Origin
        -- Because they have some the same functions (E.g. shake sound / particles)
        -- Stop sit and sleep if shaking
        if isShaking == 1 then
            sit:stop()
            sleep:stop()
        end
        if fearTimer > 0 then
            fearTimer = fearTimer - 1
        end

        if not fox_origin.enabled then
            -- Play Sleep Sound when you sleep
            if (sleep:isPlaying() or sleep:getPlayState() == "HOLDING" or player:getPos() == "SLEEPING") and afkTimer % 180 == 90 then
                local fox_sleep = sounds["entity.fox.sleep"]
                fox_sleep:setPos(player:getPos())
                fox_sleep:setSubtitle(player:getName() .. " Snores")
                fox_sleep:setVolume(0.7)
                fox_sleep:setPitch(0.8 + math.random() * 0.5)
                fox_sleep:play()
            end
            
            -- Shake Water
            if wasInWater == nil then
                local wasInWater
            end
            if player:isInWater() then
                wasInWater = true
            end
            if not player:isInWater() and wasInWater and player:getVelocity():length() == 0 then
                wolf_shake:setPos(player:getPos())
                wolf_shake:play() -- Sound
                shake:play() -- Animation
                sit:stop()
                sleep:stop()
                wasInWater = false
            end
            availableTailCount = 9
        else
            if fox_origin.afk_timer == 0 and player:getPose() == "STANDING" and not (sit:isPlaying() or sit:getPlayState() == "HOLDING") and not (sleep:isPlaying() or sleep:getPlayState() == "HOLDING") then
                pings.origin(1)
            elseif fox_origin.afk_timer > 1195 and tail_wag:isStopped() and not afkModeOn and (sleep:isPlaying() or sleepBed:isPlaying() or sleep:getPlayState() == "HOLDING" or sleepBed:getPlayState() == "HOLDING") then
                pings.origin(2)
            end

            -- Update Available Tail Count w.r.t karma value
            availableTailCount = math.floor(fox_origin.karma/250 + 1)

            -- Pounce Animation (Hold)
            if fox_origin.pouncing == 1 and not flight:isPlaying() and isPouncing == 0 then
                pings.origin(4)
            elseif (fox_origin.pouncing == 0 or flight:isPlaying())and isPouncing == 1 then
                pings.origin(5)
            end
            -- Shake Animation (Once)
            if fox_origin.is_shaking == 1 and isShaking == 0 then
                pings.origin(6)
            elseif fox_origin.is_shaking == 0 and isShaking == 1 then
                pings.origin(7)
            end

            -- Fear Animation (Hold)
            if fox_origin.fear == 1 and fearTimer == 0 then
                pings.origin(9)
            end
        end
        -- The Attack Emote's SoundEffect
        if attack:isPlaying() then
            if (attack:getTime() > 0.3 and attack:getTime() < 0.35) or (attack:getTime() > 0.8 and attack:getTime() < 0.85) then
                local sweep = sounds["entity.player.attack.sweep"]
                sweep:setPos(player:getPos())
                sweep:setVolume(0.6)
                sweep:setSubtitle(player:getName() .. " Sweep Attacc")
                sweep:play()
            elseif attack:getTime() > 2.8 and attack:getTime() < 2.85 then
                local fox_ambient = sounds["entity.fox.ambient"]
                fox_ambient:setPos(player:getPos())
                fox_ambient:setSubtitle(player:getName() .. " Noise")
                fox_ambient:setPitch(-player:getRot()[1] * 3 / 360 + 1.25)
                fox_ambient:play()
            elseif attack:getTime() > 3.5 and attack:getTime() < 3.55 then
                local trident_hit_ground = sounds["item.trident.hit_ground"]
                trident_hit_ground:setPos(player:getPos())
                trident_hit_ground:setSubtitle(player:getName() .. " Land")
                trident_hit_ground:setPitch(1.5)
                trident_hit_ground:play()
            end
        end
        -- Manually Triggered Afk Mode
        if afkModeOn then
            afkTimer = afkTimer + 1
        else
            afkTimer = 0
        end 

        -- Velocity Based Animation Stopping 
        if player:getVelocity():length() > 0 and not afkModeOn then
            if attack:getPlayState() == "HOLDING" then 
                attack:stop() 
            end
            sit:stop()
            attack:stop()
            dilly_daily:stop()
            if not sleep:isStopped() or sleep:isPlaying() then
                unsleepAnimation()
            end
        end

        if not dilly_daily:isPlaying() and not spin:isPlaying() then
            spinSpeed = 1
        end 
        -- Floppy ears
        difference = (headRotStore - player:getRot().x) * 1.5 -- Nodding, scaled by 1.5
        tempY = math.clamp((bodyYVelStore - player:getVelocity().y) * (player:getLookDir().x + 5) * 105, -40, 40) -- Velocity Based
        difference = difference + tempY
        bodyYVelStore = player:getVelocity().y
        headRotStore = player:getRot().x
        setEarRot(difference)

        -- Limit the ping sent, only used by jump
        if pingLimiter > 0 then
            pingLimiter = pingLimiter - 1
        end

        handleEarTwitch()
    end
end

function handle_jump()
    local isPlaying = jump:isPlaying() or jump:getPlayState() == "HOLDING" or jump:isPaused()
    
    if isPlaying then
        -- Stop Animation
        if (player:getNbt()["OnGround"] == 1 or player:getNbt()["abilities"]["flying"] == 1 or player:isInWater() or pounce:isPlaying() or player:getPose() == "FALL_FLYING" or flight:isPlaying() or sleep:isPlaying() or sleepBed:isPlaying()) then
            jump:stop()
        end

        -- Free Leggies when running
        jump:setOverride(not (player:isSprinting() and jump:getTime() < 0.15))

    -- Trigger Jump
    elseif host:isJumping() and not (pounce:isPlaying() or pounce:getPlayState() == "HOLDING") then
        jump:play()

        -- Sync jump animation to server, avoid overload by spamming jump
        if pingLimiter == 0 then
            pingLimiter = 5
            pings.toggle("jump")
        end
    end
end

local sneakButton = keybinds:fromVanilla("key.sneak")
local mouthItem = rootModel.Head.LeftItemPivot
local rootModeified
function events.render()
    -- Animations setPlay in the following senarios 
    if player:isLoaded() then
        playerNbt = player:getNbt()
        -- Rotate Left Item Pivot for Swords :3
        offhandItem = player:getItem(2).id
        if (offhandItem == "minecraft:shield" and not (player:isBlocking())) then
            mouthItem:moveTo(rootModel.Body)
            mouthItem:setScale(0.95, 0.78, 0.6)
        else
            mouthItem:moveTo(rootModel.Head)
            mouthItem:setScale(1, 1, 1)
        end
        if (offhandItem == "minecraft:wooden_sword" or
            offhandItem == "minecraft:stone_sword" or
            offhandItem == "minecraft:iron_sword" or
            offhandItem == "minecraft:golden_sword" or
            offhandItem == "minecraft:diamond_sword" or
            offhandItem == "minecraft:netherite_sword" or
            offhandItem == "minecraft:trident" or
            offhandItem == "minecraft:bow" or
            offhandItem == "minecraft:spyglass" or
            offhandItem == "minecraft:stick" or
            offhandItem == "minecraft:torch" or
            offhandItem == "minecraft:redstone_torch" or
            offhandItem == "minecraft:soul_torch" 
        ) then
            mouthItem:setRot(110, 0, -90)
            mouthItem:setPos(0, 0, 0)
        elseif (offhandItem == "minecraft:shield") then
            if (player:isBlocking()) then
                mouthItem:setRot(45, -10, -90)
                mouthItem:setPos(1.3, 4, -3)
            else
                mouthItem:setRot(0, 180, 90)
                mouthItem:setPos(2, 4.5, 15)
            end
        else
            mouthItem:setRot(0, 0, 0)
            mouthItem:setPos(0, -1, 0)
        end

        models.model.root.Head.Warning:setVisible(false)
        -- Idle Breathig Animation (When Not in Water)
        idle:setPlaying(playerNbt["Air"] == 300)
        -- Crouching (When Crouching)
        crouch:setPlaying(player:getPose() == "CROUCHING")
        -- Elytra (When Fall Flying)
        fall_flying:setPlaying(player:getPose() == "FALL_FLYING")
        -- Riptide (When Riptiding)
        riptide:setPlaying(player:getPose() == "SPIN_ATTACK")
        -- Creative Flying
        flight:setPlaying(playerNbt["abilities"]["flying"] == 1)

        -- Stop Tail Wag and Lean fwd / bwd
        if flight:isPlaying() then
            tail_wag:stop()
            local lookDir = player:getLookDir():mul(1, 0, 1)
            local targetRot = player:getVelocity():dot(lookDir) * -50
            rootModel:setRot(targetRot)
            rootModel.Head:setRot(-targetRot)
            rootModeified = true
        elseif rootModeified then
            tail_wag:play()
            rootModel:setRot(0,0,0)
            rootModeified = false
        end
        -- hhhSSDDf
        handle_jump()
        if player:getPose() == "FALL_FLYING" or flight:isPlaying() and displayedTailCount > 1 then
            setTailRot(0)
        else
            setTailRot(player:getVelocity().y)
        end

        -- Sleep on Bed (When Sleep on Bed Specifically)
        if player:getPose() == "SLEEPING" then
            if not (sleepBed:isPlaying() or sleepBed:getPlayState() == "HOLDING") then
                sleep:stop()
                sleepBed:play()
                closeEyes()
                sit:stop()
                tail_wag:stop()
            end
        elseif sleepBed:isPlaying() or sleepBed:getPlayState() ==  "HOLDING" then
            unsleepAnimation()
        end
        -- Swim (When Swimming duh :3)
        if player:getPose() == "SWIMMING" then
            unswim:stop()
            swim:play()
        elseif swim:isPlaying() or swim:getPlayState() == "HOLDING" then
            unswim:play()
            swim:stop()
        end
    end

    -- Speed up Tail wag :3
    local tailSpeed
    if player:isSprinting() then
        tailSpeed = 7
    elseif player:getVelocity():length() > 0 then
        if player:getPose() == "FALL_FLYING" or player:getPose() == "CROUCHING" or crouch:isPlaying() then
            tailSpeed = 1
        else
            tailSpeed = 5
        end
    else
        tailSpeed = 1
    end
    tail_wag:setSpeed(tailSpeed)

    -- Crouch animation sequence
    if crouch:isPlaying() then
        -- If you moved, while crouching, the animation goes on
        if player:getVelocity():length() > 0 then
            crouch:play()
        -- If the Offset is already modified, annd you are not moving while crouching, PAUSE the crouching animation
        elseif crouch:getOffset() == 0.5 then
            crouch:pause()
        end
        if back:isPressed() then
            crouch:setSpeed(-1)
        else
            crouch:setSpeed(1)
        end
        -- This is foor the first time you enter crouching
        -- The first 0.25s animation is the fox crouching downn, and the remaining animations are walk cycles
        if crouch:getTime() >= 0.25 then
            -- So set the loop offset to 0.5, to skip the crouching down part annd loop the walk cycle 
            crouch:setOffset(0.5)
        end
    end
    -- If you no longer crouching, reset the offset, so that the Crouching down animation can be triggered the next time
    if crouch:isStopped() then
        crouch:setOffset(0)
    end

    -- Play Pounce Particles during Attack animation
    if attack:isPlaying() and (attack:getTime() >= 2.8 and attack:getTime() <= 2.95) then
        particles:newParticle("snowflake", 
        player:getPos().x + math.random() - 0.5,
        player:getPos().y + math.random() * 0.25,
        player:getPos().z + math.random() - 0.5,
        (math.random() - 0.5)*0.35,
        (math.random() - 0.5)*0.35,
        (math.random() - 0.5)*0.35)
    end

    -- Origin Specific Effect (Not played if you have origin)
    pounce:setPlaying(isPouncing == 1)
    if fox_origin.enabled then
        shake:setPlaying(isShaking == 1)
    end
    if (fearTimer > 0 and not (sleep:isPlaying() or sleep:getPlayState() == "HOLDING" or sleepBed:isPlaying() or sleepBed:getPlayState() == "HOLDING" or sit:isPlaying() or sit:getPlayState() == "HOLDING") or playerNbt["foodLevel"] == 0) then
        scared:play()
        tail_wag:stop()
    elseif scared:isPlaying() or scared:getPlayState() == "HOLDING" then
        scared:stop()
        tail_wag:play()
    end
    if (fearTimer > 19 and not (foldTail:isPlaying() or foldTail:getPlayState() == "HOLDING") and player:getVelocity():length() == 0) then
        foldTail:play()
    end

    if (player:getVelocity():length() > 0 or sleep:isPlaying() or sleep:getPlayState() == "HOLDING" or sleepBed:isPlaying() or sleepBed:getPlayState() == "HOLDING" or sit:isPlaying() or sit:getPlayState() == "HOLDING") then
        foldTail:stop()
    end

    if not fox_origin.enabled then
        if shake:isPlaying() and shake:getTime() <= 1.1 then
            particles:newParticle("splash", 
            player:getPos().x + math.random() - 0.5,
            player:getPos().y + 0.5 + math.random()*0.25,
            player:getPos().z + math.random() - 0.5,
            math.random()*0.35,
            math.random()*0.35,
            math.random()*0.35)
        end
    end

    -- fox_origin.pouncing Section
    -- Used to check the block under you, for Stuck animation after fox_origin.pouncing on a Snowblock
    local pawOnBlock = world.getBlockState(player:getPos():sub(0, 0.1, 0)):getID()
    if wasPouncing == nil then local wasPouncing = 0 end
    -- fox_origin.pouncing rotate body
    if isPouncing == 1 then
        wasPouncing = 1
        tail_wag:stop()
        if playerNbt["OnGround"] == 0 and not (player:getPose() == "FALL_FLYING") then
            -- TRIGONOMETRY HELL YEAHAHAHAA
            rotDeg = math.deg(math.atan2(player:getVelocity().y, math.sqrt(player:getVelocity().x ^ 2  + player:getVelocity().z ^ 2)))
            rotDeg = math.clamp(rotDeg, -110, 70)

            -- You going upwards is instant
            if models:getRot().x < rotDeg then
                currentRot = rotDeg
            else
                -- But falling down isn't
                currentRot = models:getRot().x
            end
            -- random lerp function I found in Figura wiki. Why not
            currentRot = math.lerp(currentRot, rotDeg, 0.25)
        end
    -- Landed after fox_origin.pouncing
    elseif wasPouncing == 1 then
        tail_wag:play()
        wasPouncing = 0
        -- Stuck Animation Triggering: 
        -- 1. Velocity Magnitude <= 0.08 (So you won't see this animation played while you are actually going forward)
        -- 2. Player is looking roughly straightdown (For realistic reason: Head sunk into snow :3)
        -- 3. The block directly below is Snow / SnowBlock / PowderSnow
        if player:getVelocity():length() <= 0.08 and player:getRot().x >= 70 and 
            (pawOnBlock == "minecraft:snow" or pawOnBlock == "minecraft:snow_block" or pawOnBlock == "minecraft:powder_snow") then
                pings.origin(8)
        end
    else
        -- Reset CurrentRotation in Normal occasions
        currentRot = 0
    end
    -- Also Fall Flying reset CurrentRotatoin
    if player:getPose() == "FALL_FLYING" then
        currentRot = 0
        pounce:stop()
    end
    -- Set Model Rotation based on Current Rotation
    -- Give Head free rotation by counter it to -ve
    models:setRot(currentRot, 0, 0)


    models.model.root.Head:setRot(-currentRot, 0, 0)
    -- If you moved, stop stuck animation
    if player:getVelocity():length() > 0.08 and (stuck:isPlaying() or stuck:getPlayState() == "HOLDING") then
        stuck:stop()
    end

    -- Set Tail Visible Count
    tail.Tail1:setVisible(displayedTailCount >= 0)
    tail.Tail2:setVisible(displayedTailCount >= 2)
    tail.Tail3:setVisible(displayedTailCount >= 3)
    tail.Tail4:setVisible(displayedTailCount >= 4)
    tail.Tail5:setVisible(displayedTailCount >= 5)
    tail.Tail6:setVisible(displayedTailCount >= 6)
    tail.Tail7:setVisible(displayedTailCount >= 7)
    tail.Tail8:setVisible(displayedTailCount >= 8)
    tail.Tail9:setVisible(displayedTailCount == 9)

    -- Tail Animations, but actually they are 1 frame long Rotation + Position of different Tail Combinations -- I think my n key is brokenn hold on -- n n n n n n n nn n n nn n n n n n n  n n n n n n  n n  -- yep that checks out
    -- Also frees the rotation whenn stuck animation is playing
    local overrideTailAnim = not (stuck:isPlaying() or stuck:getPlayState() == "HOLDING" or sleep:isPlaying() or sleep:getPlayState() == "HOLDING" or sleepBed:isPlaying() or sleepBed:getPlayState() == "HOLDING" or flight:isPlaying())
    animations.model.OneTail:setPlaying(displayedTailCount <= 1 and overrideTailAnim)
    animations.model.TwoTails:setPlaying(displayedTailCount == 2 and overrideTailAnim)
    animations.model.ThreeTails:setPlaying(displayedTailCount == 3 and overrideTailAnim)
    animations.model.FourTails:setPlaying(displayedTailCount == 4 and overrideTailAnim)
    animations.model.FiveTails:setPlaying(displayedTailCount == 5 and overrideTailAnim)
    animations.model.SixTails:setPlaying(displayedTailCount == 6 and overrideTailAnim)
    animations.model.SevenTails:setPlaying(displayedTailCount == 7 and overrideTailAnim)
    animations.model.EightTails:setPlaying(displayedTailCount == 8 and overrideTailAnim)
    animations.model.NineTails:setPlaying(displayedTailCount == 9 and overrideTailAnim)

    -- Set tail scale to grow
    -- idk why I did this but okay
    local tailLength = 1.0 + displayedTailCount * 0.05
    tail.Tail1:setScale(1, 1, tailLength)
    tail.Tail2:setScale(1, 1, tailLength)
    tail.Tail3:setScale(1, 1, tailLength)
    tail.Tail4:setScale(1, 1, tailLength)
    tail.Tail5:setScale(1, 1, tailLength)
    tail.Tail6:setScale(1, 1, tailLength)
    tail.Tail7:setScale(1, 1, tailLength)
    tail.Tail8:setScale(1, 1, tailLength)
    tail.Tail9:setScale(1, 1, tailLength)
end


-- Action Wheels
-- Action Wheel Page Varible
local emotes = action_wheel:newPage()
local sounds = action_wheel:newPage()
local armors = action_wheel:newPage()
local colors = action_wheel:newPage()

-- Set Default page to Emotes
action_wheel:setPage(emotes)

-- Sleep Emote
local action = emotes:newAction()
    :title("Sleep")
    :item("minecraft:red_bed")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("sleep")
        end
    )

-- Manually Close Wing
local action = emotes:newAction()
    :title("Toggle Open / Close Wings")
    :item("minecraft:elytra")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("toggleWings")
        end
    )

-- Sit Emote
local action = emotes:newAction()
    :title("Sit")
    :item("minecraft:scaffolding")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("sit")
        end
    )

-- Spin Animation
local action = emotes:newAction()
    :title("Speeen\nArrow Up: Speed Up\nArrow Down: Speed Down")
    :item("minecraft:milk_bucket")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("spin")
        end
    )

-- Dilly Daily Animation
local action = emotes:newAction()
    :title("Dilly Dailly\n[Left Click] Start/Pause\n[Right Click] Stop\n\nArrow Up: Speed Up\nArrow Down: Speed Down")
    :item("minecraft:player_head")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("dillyDaily1")
        end
    )
    :onRightClick(
        function()
            pings.toggle("dillyDaily2")
        end
    )

-- Manually Speed up DillyDaily / Spin Animation
local speedup = keybinds:newKeybind("SpeedUp","key.keyboard.up", false)
    speedup:setOnPress(
        function()
            spinSpeed = spinSpeed + 0.05
            pings.toggle1("changeSpeed", spinSpeed)
        end
    )

-- Manually Speed down DillyDaily / Spin Animation
local speeddown = keybinds:newKeybind("SpeedDown", "key.keyboard.down", false)
    speeddown:setOnPress(
        function()
            spinSpeed = spinSpeed - 0.05
            pings.toggle1("changeSpeed", spinSpeed)
        end
    )

-- Attack Animation
local action = emotes:newAction()
    :title("Attack")
    :item("minecraft:iron_sword")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("attack")
        end
    )

-- Tail Manipulation
local action = emotes:newAction()
    :title("[L] Hide / [R] Unhide\nExcessive Tails")
    :item("minecraft:feather")
    :hoverColor(1,0,1)
    :onRightClick(
        function()
            userTailCount = math.clamp(userTailCount - 1, 1, availableTailCount)
            displayedTailCount = math.min(availableTailCount, userTailCount)
            pings.toggle1("setTails", displayedTailCount)
            host:setActionbar("Tails Displayed/Available: " .. displayedTailCount .. "/" .. availableTailCount)
        end
    )
    :onLeftClick(
        function()
            userTailCount = math.clamp(userTailCount + 1, 1, availableTailCount)
            displayedTailCount = math.min(availableTailCount, userTailCount)
            pings.toggle1("setTails", displayedTailCount)
            host:setActionbar("Tails Displayed/Available: " .. displayedTailCount .. "/" .. availableTailCount)
        end
    )

-- Close/Open Eyes
local action = emotes:newAction()
    :title("Toggle Close / Open Eyes")
    :item("minecraft:ender_eye")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleEye", faceModel:getUV().y == 1/32)
        end
    )

-- Agree/Disagree
local action = emotes:newAction()
    :title("[L] Yes / [R] No")
    :item("minecraft:redstone_torch")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("agree")
        end
    )
    :onRightClick(
        function()    
            pings.toggle("disagree")
        end
    )

-- Toggle AFK Mode
local action = emotes:newAction()
    :title("AFK Mode\nMost Animations stay ON when you moved\nAlso Reset all animation status")
    :item("minecraft:barrier")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("afkMode")
        end
    )

-- Use with no Figura Mode
local action = emotes:newAction()
    :title("[L] Make the Fox Model 1.8x Bigger\n[R] Revert to 1x Size")
    :item("minecraft:egg")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("XSsize", true)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("XSsize", false)
        end
    )

local action = emotes:newAction()
    :title("Page - Alter Model Texture\n\nWarning: Might cause No effect on others' end or \"Overran resource limit\" if they do not have you on Max Permission!")
    :item("minecraft:white_dye")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            if not (avatar:getPermissionLevel() == "MAX") then
                print("You need Max Permission on this Avatar for this feature!")
            else
                action_wheel:setPage(colors)
            end
        end
    )

-- Change Back
local action = colors:newAction()
    :title("Page - Emotes")
    :item("minecraft:fox_spawn_egg")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            action_wheel:setPage(emotes)
        end
    )

local action = colors:newAction()
    :title("[L] Set Model Color Overlay\n[R] Reset Model Color to Original\n\nNote: White fur sections (belly, inner ears, tail tip etc.) are ignored for aesthetic purpose\n\nOnly Head color changes until [Enter] is pressed for performance purpose :3")
    :item("minecraft:white_dye")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            colorSelector.start()
        end
    )
    :onRightClick(
        function()
            colorSelector.reset()
        end
    )

local action = colors:newAction()
    :title("[L] jeb_\n[R] jeb_n't")
    :item("minecraft:white_wool")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            colorSelector.jebbing(1)
        end
    )
    :onRightClick(
        function()
            colorSelector.jebbing(3)
        end
    )

-- Toggle Armor Visibilities
-- Change Page
local action = emotes:newAction()
    :title("Page - Toggle Armor Visibility")
    :item("minecraft:armor_stand")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            action_wheel:setPage(armors)
        end
    )

-- Change Back
local action = armors:newAction()
    :title("Page - Emotes")
    :item("minecraft:fox_spawn_egg")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            action_wheel:setPage(emotes)
        end
    )

-- Helmet
local action = armors:newAction()
    :title("Helmet Visibility\n\n[Left Click] - Show\n[Right Click] - Hide")
    :item("minecraft:iron_helmet")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleArmorT", 0)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("toggleArmorF", 0)
        end
    )


-- Chestplate
local action = armors:newAction()
    :title("Chestplate Visibility\n\n[Left Click] - Show\n[Right Click] - Hide")
    :item("minecraft:iron_chestplate")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleArmorT", 1)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("toggleArmorF", 1)
        end
    )

-- Leggings
local action = armors:newAction()
    :title("Leggings Visibility\n\n[Left Click] - Show\n[Right Click] - Hide")
    :item("minecraft:iron_leggings")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleArmorT", 2)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("toggleArmorF", 2)
        end
    )

-- Boots
local action = armors:newAction()
    :title("Boots Visibility\n\n[Left Click] - Show\n[Right Click] - Hide")
    :item("minecraft:iron_boots")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleArmorT", 3)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("toggleArmorF", 3)
        end
    )

-- All 4 Pieces
local action = armors:newAction()
    :title("ALL 4 Visibility\n\n[Left Click] - Show\n[Right Click] - Hide")
    :item("minecraft:iron_ingot")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle1("toggleArmorT", 4)
        end
    )
    :onRightClick(
        function()
            pings.toggle1("toggleArmorF", 4)
        end
    )

-- Change Page
local action = emotes:newAction()
    :title("Page - Sounds")
    :item("minecraft:goat_horn")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            action_wheel:setPage(sounds)
        end
    )

-- Change Page
local action = sounds:newAction()
    :title("Page - Emotes")
    :item("minecraft:fox_spawn_egg")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            action_wheel:setPage(emotes)
        end
    )

-- Play Sound
local action = sounds:newAction()
    :title("[L] Fox Noise / [R] Whine")
    :item("minecraft:sweet_berries")
    :hoverColor(1,0,1)
    :onLeftClick(
        function()
            pings.toggle("foxAmbient")
        end
    )
    :onRightClick(
        function()
            pings.toggle("wolfWhine")
        end
    )