local up = keybinds:newKeybind("increase","key.keyboard.up", false)
local down = keybinds:newKeybind("decrease","key.keyboard.down", false)
local left = keybinds:newKeybind("left","key.keyboard.left", false)
local right = keybinds:newKeybind("right","key.keyboard.right", false)
local enter = keybinds:newKeybind("enter","key.keyboard.enter",false)

local rgba = vec(255, 255, 255, 255)
finalRgba = vec(255, 255, 255, 255)
local currentSelection = 0
local inProgress = false

local jeb = false
local jebDelay = 0
local jebInd = 0
local phase = 0

local data = {}

function data.jebbing(code)
    if code == 0 then -- jebbin
        -- Go white :3
        setTextures(1)
        phase = 0
        whiteSpace()
        jeb = true
    elseif code == 1 then
        pings.jebbed(code)
    elseif code == 2 then -- jebboff
        setTextures(0)
        models:setColor(1,1,1)
        jeb = false
    elseif code == 3 then
        pings.jebbed(code)
    end
end

function pings.jebbed(co)
    if (avatar:getPermissionLevel() == "MAX") then
        if co == 1 then
            data.jebbing(0)
        elseif co == 3 then
            data.jebbing(2)
        end
    end
end

-- create a function that accepts the color of the pixel, and its x, y position
function tintFunc(color, x, y)
    -- multiply the color of the pixel by our tint
    if color == vec(1, 1, 1, 1) then 
        return color
    else
        return color:mul(finalRgba)
    end
end

function fillUp(color, x, y)
    if color.a == 0 then
        return vec(1, 1, 1, 1)
    else
        return color
    end
end

myTex = textures:getTextures()

local spriteIndex = {
    headAW = 0,
    head = 0,
    elytra = 0,
    elytraAW = 0
}
for i = 1, #myTex, 1 do
    if (myTex[i]:getName() == "Head AW") then
        spriteIndex.headAW = i
    elseif (myTex[i]:getName() == "Head") then
        spriteIndex.head = i
    elseif (myTex[i]:getName() == "elytra") then
        spriteIndex.elytra = i
    elseif (myTex[i]:getName() == "elytra AW") then
        spriteIndex.elytraAW = i
    end
end

function apply()
    myTex[spriteIndex.headAW]:restore()
    local dimensions = myTex[spriteIndex.headAW]:getDimensions()
    myTex[spriteIndex.headAW]:applyFunc(0, 0, dimensions.x, dimensions.y, tintFunc)
    myTex[spriteIndex.headAW]:update()
    myTex[spriteIndex.headAW]:applyFunc(0, 0, dimensions.x, dimensions.y, fillUp)
    for k = 0, 7 do
        myTex[spriteIndex.headAW]:setPixel(k, 29, vec(0, 0, 0, 0))
    end
end

function finalApply()
    full_reset()
    for i in pairs(myTex) do
        local dimensions = myTex[i]:getDimensions()
        myTex[i]:applyFunc(0, 0, dimensions.x, dimensions.y, tintFunc)
        myTex[i]:update()
    end
end

left:setOnPress(function()
    currentSelection = math.clamp(currentSelection - 1, 1, 3)
end)

right:setOnPress(function()
    currentSelection = math.clamp(currentSelection + 1, 1, 3)
end)

function data.start()
    data.jebbing(2)
    currentSelection = 1
    inProgress = true
    print("Color Overlay Started\nUse Arrow Keys to adjust, [Enter] to confirm choice") 
    setTextures(1)
    whiteSpace()
end

function setTextures(int)
    if int == 0 then
        models.model.Portrait.PortraitHead:setPrimaryTexture("Custom", textures["Head"])
        models.model.Portrait.PortraitHead.Jaw:setPrimaryTexture("Custom", textures["Head"])
        models.model.Portrait.PortraitHead.Eyes:setPrimaryTexture("Custom", textures["Head"])
        models.model.Portrait.PortraitHead.LeftEars2:setPrimaryTexture("Custom", textures["Head"])
        models.model.Portrait.PortraitHead.RightEar2:setPrimaryTexture("Custom", textures["Head"])

        models.model.root.Head.Head:setPrimaryTexture("Custom", textures["Head"])
        models.model.root.Head.Jaw:setPrimaryTexture("Custom", textures["Head"])
        models.model.root.Head.Eyes:setPrimaryTexture("Custom", textures["Head"])
        models.model.root.Head.LeftEar:setPrimaryTexture("Custom", textures["Head"])
        models.model.root.Head.RightEar:setPrimaryTexture("Custom", textures["Head"])

        models.model.root.Body.Body:setPrimaryTexture("Custom", textures["Body"])
        models.model.root.Body.Elytra:setPrimaryTexture("Custom", textures["elytra"])
        
        models.model.root.LeftArm:setPrimaryTexture("Custom", textures["Legs"])
        models.model.root.RightArm:setPrimaryTexture("Custom", textures["Legs"])
        models.model.root.LeftLeg:setPrimaryTexture("Custom", textures["Legs"])
        models.model.root.RightLeg:setPrimaryTexture("Custom", textures["Legs"])

        models.model.root.Body.Tail:setPrimaryTexture("Custom", textures["Tail"])

    else
        models.model.Portrait.PortraitHead:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.Portrait.PortraitHead.Jaw:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.Portrait.PortraitHead.Eyes:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.Portrait.PortraitHead.LeftEars2:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.Portrait.PortraitHead.RightEar2:setPrimaryTexture("Custom", textures["Head AW"])

        models.model.root.Head.Head:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.root.Head.Jaw:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.root.Head.Eyes:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.root.Head.LeftEar:setPrimaryTexture("Custom", textures["Head AW"])
        models.model.root.Head.RightEar:setPrimaryTexture("Custom", textures["Head AW"])

        models.model.root.Body.Body:setPrimaryTexture("Custom", textures["Body AW"])
        models.model.root.Body.Elytra:setPrimaryTexture("Custom", textures["elytra AW"])
        
        models.model.root.LeftArm:setPrimaryTexture("Custom", textures["Legs AW"])
        models.model.root.RightArm:setPrimaryTexture("Custom", textures["Legs AW"])
        models.model.root.LeftLeg:setPrimaryTexture("Custom", textures["Legs AW"])
        models.model.root.RightLeg:setPrimaryTexture("Custom", textures["Legs AW"])

        models.model.root.Body.Tail:setPrimaryTexture("Custom", textures["Tail AW"])
    end
end

function data.reset()
    pings.revert()
end

function pings.revert()
    for i in pairs(myTex) do
        local dimensions = myTex[i]:getDimensions()
        myTex[i]:restore()
        myTex[i]:update()
    end
    setTextures(0)
end

function full_reset()
    setTextures(1)
    for i in pairs(myTex) do
        local dimensions = myTex[i]:getDimensions()
        myTex[i]:restore()
        myTex[i]:update()
    end
    whiteSpace()
end

function pings.finalise(rgba)
    if (avatar:getPermissionLevel() == "MAX") then
        finalApply(rgba)
    end
end

function whiteSpace()
    for i in pairs(myTex) do
        -- Do not fill up elytra
        if not (i == spriteIndex.elytra or i == spriteIndex.elytraAW) then 
            local dimensions = myTex[i]:getDimensions()
            myTex[i]:applyFunc(0, 0, dimensions.x, dimensions.y, fillUp)
            myTex[i]:update()
        end
        -- Fill up the missing muzzle :3
        if (i == spriteIndex.headAW or i == spriteIndex.head) then
            for k = 0, 7 do
                myTex[i]:setPixel(k, 29, vec(0, 0, 0, 0))
            end
        end
    end
end

function events.tick()
    left:setEnabled(inProgress)
    right:setEnabled(inProgress)
    if player:isLoaded() and inProgress then
        
        if currentSelection == 1 then
            msg = "§6R: " .. rgba[1] .. "§r G: " .. rgba[2] .. "§r B: " .. rgba[3]
        elseif currentSelection == 2 then
            msg = "§rR: " .. rgba[1] .. "§6 G: " .. rgba[2] .. "§r B: " .. rgba[3]
        else
            msg = "§rR: " .. rgba[1] .. "§r G: " .. rgba[2] .. "§6 B: " .. rgba[3]
        end

        host:setActionbar(msg)
        if up:isPressed() then
            rgba[currentSelection] = math.clamp(rgba[currentSelection] + 1, 0, 255)
        elseif down:isPressed() then
            rgba[currentSelection] = math.clamp(rgba[currentSelection] - 1, 0, 255)
        end
        finalRgba = rgba:copy():mul(1/255, 1/255, 1/255, 1/255)
        apply()

        if enter:isPressed() then
            pings.finalise()
            print("Model Color Set to", rgba)
            inProgress = false
            currentSelection = 0
        end
    end
    if player:isLoaded() and jeb then
        if phase == 0 then
            models:setColor(1, jebInd / 255, 0)
            if jebInd < 255 then
                jebInd = math.clamp(jebInd + 8, 0, 255)
            else
                phase = 1
            end
        elseif phase == 1 then
            models:setColor(jebInd / 255, 1, 0)
            if jebInd > 0 then
                jebInd = math.clamp(jebInd - 8, 0, 255)
            else
                phase = 2
            end
        elseif phase == 2 then
            models:setColor(0, 1, jebInd / 255)
            if jebInd < 255 then
                jebInd = math.clamp(jebInd + 8, 0, 255)
            else
                phase = 3
            end
        elseif phase == 3 then
            models:setColor(0, jebInd / 255, 1)
            if jebInd > 0 then
                jebInd = math.clamp(jebInd - 8, 0, 255)
            else
                phase = 4
            end
        elseif phase == 4 then
            models:setColor(jebInd / 255, 0, 1)
            if jebInd < 255 then
                jebInd = math.clamp(jebInd + 8, 0, 255)
            else
                phase = 5
            end
        elseif phase == 5 then
            models:setColor(1, 0, jebInd / 255)
            if jebInd > 0 then
                jebInd = math.clamp(jebInd - 8, 0, 255)
            else
                phase = 0
            end
        end
    end
end

return data