/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.hookshot.entity.client.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mezimaru.hookshot.entity.client.ModModelLayers;
import net.mezimaru.hookshot.entity.client.entities.HookEntityModel;
import net.mezimaru.hookshot.entity.custom.HookshotHookProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class HookEntityRenderer
extends EntityRenderer<HookshotHookProjectileEntity> {
    private static final ResourceLocation HOOK_TEXTURE = new ResourceLocation("hookshot", "textures/entity/hookentity.png");
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("hookshot", "textures/entity/chain.png");
    private final HookEntityModel<HookshotHookProjectileEntity> model;
    private final RenderType CHAIN_LAYER = RenderType.m_110458_((ResourceLocation)CHAIN_TEXTURE);
    private final RenderType renderType;
    private float storedYaw = 0.0f;
    private float storedPitch = 0.0f;

    public HookEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new HookEntityModel(pContext.m_174023_(ModModelLayers.HOOKSHOT_LAYER));
        this.renderType = RenderType.m_110458_((ResourceLocation)HOOK_TEXTURE);
    }

    protected int getBlockLightLevel(HookshotHookProjectileEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(HookshotHookProjectileEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.getShootingPlayer() instanceof Player) {
            Player player = pEntity.getShootingPlayer();
            HumanoidArm mainArm = player.m_5737_();
            InteractionHand activeHand = pEntity.getActiveItemHand();
            boolean mainHandIsActive = mainArm == HumanoidArm.RIGHT && activeHand == InteractionHand.MAIN_HAND || mainArm == HumanoidArm.LEFT && activeHand == InteractionHand.OFF_HAND;
            boolean isRetracting = pEntity.getShouldRetract();
            pMatrixStack.m_85836_();
            double bodyYawToRads = Math.toRadians(player.f_20883_);
            double radius = mainHandIsActive ? -0.35 : 0.35;
            double startX = player.m_20185_() + radius * Math.cos(bodyYawToRads);
            double startY = player.m_20188_() - 0.9;
            double startZ = player.m_20189_() + radius * Math.sin(bodyYawToRads);
            float distanceX = (float)(startX - pEntity.m_20185_());
            float distanceY = (float)(startY - pEntity.m_20188_());
            float distanceZ = (float)(startZ - pEntity.m_20189_());
            pMatrixStack.m_85837_(0.0, 0.3, 0.0);
            this.renderChain(distanceX, distanceY, distanceZ, pPartialTicks, pEntity.f_19797_, pMatrixStack, pBuffer, pPackedLight, mainHandIsActive);
            pMatrixStack.m_85849_();
            pMatrixStack.m_85836_();
            if (!isRetracting) {
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(pEntityYaw - 180.0f));
                pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(pEntity.getShooterPitch()));
                this.storedYaw = pEntityYaw - 180.0f;
                this.storedPitch = pEntity.getShooterPitch();
            } else {
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(this.storedYaw));
                pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(this.storedPitch));
            }
            pMatrixStack.m_85837_(mainHandIsActive ? 0.14 : 0.15, -1.5, 0.0);
            pMatrixStack.m_85841_(2.0f, 1.2f, 2.0f);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(this.renderType);
            this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.3f);
            pMatrixStack.m_85849_();
        }
    }

    public void renderChain(float x, float y, float z, float tickDelta, int age, PoseStack stack, MultiBufferSource provider, int light, Boolean mainHandIsActive) {
        float lengthXY = Mth.m_14116_((float)(x * x + z * z));
        float squaredLength = x * x + y * y + z * z;
        float length = Mth.m_14116_((float)squaredLength);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(z, x)) - 1.5707964f));
        stack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(lengthXY, y)) - 1.5707964f));
        stack.m_252781_(Axis.f_252403_.m_252977_(mainHandIsActive != false ? 25.0f : -25.0f));
        stack.m_85836_();
        stack.m_85837_(0.015, -0.2, 0.0);
        VertexConsumer vertexConsumer = provider.m_6299_(this.CHAIN_LAYER);
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f - ((float)age + tickDelta) * 0.01f;
        float maxV = Mth.m_14116_((float)squaredLength) / 8.0f - ((float)age + tickDelta) * 0.01f;
        this.renderQuad(vertexConsumer, stack.m_85850_(), 0.0f, 0.25f, Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f, Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f, 0.0f, length, minU, maxU, minV, maxV, light);
        stack.m_85849_();
        stack.m_252781_(Axis.f_252403_.m_252977_(mainHandIsActive != false ? 90.0f : -90.0f));
        stack.m_85837_(-0.015, -0.2, 0.0);
        this.renderQuad(vertexConsumer, stack.m_85850_(), 0.0f, 0.25f, Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f, Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f, 0.0f, length, minU, maxU, minV, maxV, light);
        stack.m_85849_();
    }

    private void renderQuad(VertexConsumer vertexConsumer, PoseStack.Pose pose, float vertX1, float vertY1, float vertX2, float vertY2, float startZ, float endZ, float minU, float maxU, float minV, float maxV, int light) {
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, startZ).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, endZ).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, endZ).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, startZ).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(HookshotHookProjectileEntity pEntity) {
        return HOOK_TEXTURE;
    }
}

