/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.hookshot.entity.custom;

import net.mezimaru.hookshot.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.hookshot.util.ParticleHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EndershotHookProjectileEntity
extends HookshotHookProjectileEntity {
    private boolean hasTeleported = false;

    public EndershotHookProjectileEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public EndershotHookProjectileEntity(LivingEntity shooter, Level level) {
        super(shooter, level);
        this.m_5602_((Entity)shooter);
    }

    public EndershotHookProjectileEntity(EntityType<EndershotHookProjectileEntity> endershotHookProjectileEntityEntityType, Player player, Level pLevel) {
        super(endershotHookProjectileEntityEntityType, pLevel);
        this.m_5602_((Entity)player);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerOwner(player);
            this.handleTeleportation(player);
            if (this.f_19796_.m_188501_() < 0.5f) {
                this.spawnEnderhookParticles(this.m_20182_());
            }
        }
    }

    private void handleTeleportation(Player player) {
        if (!this.m_9236_().f_46443_ && this.f_36703_ && !this.hasTeleported) {
            this.hasTeleported = true;
            Vec3 oldPos = player.m_20182_();
            this.spawnTeleportPoof(oldPos);
            this.m_9236_().m_6263_(null, oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 newPos = player.m_20182_();
            this.spawnTeleportPoof(newPos);
            this.m_9236_().m_6263_(null, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_6074_();
        }
    }

    private void spawnTeleportPoof(Vec3 position) {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double dy = this.f_19796_.m_188500_() * 1.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double speedY = this.f_19796_.m_188500_() * 0.2;
            double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123760_, position.f_82479_ + dx, position.f_82480_ + dy, position.f_82481_ + dz, speedX, speedY, speedZ);
        }
    }

    private void spawnEnderhookParticles(Vec3 position) {
        ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123760_, position.f_82479_, position.f_82480_ - 0.4, position.f_82481_, 0.0, 0.0, 0.0);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.f_36703_ = true;
    }

    @Override
    public void pullOwnerTowardsHookshot(Player player) {
    }
}

