/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.hookshot.events;

import net.mezimaru.hookshot.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.hookshot.util.ParticleHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hookshot")
public class HookImpactEvent {
    @SubscribeEvent
    public static void onHookImpactEvent(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof HookshotHookProjectileEntity) {
            HitResult result;
            HookshotHookProjectileEntity hookProjectile = (HookshotHookProjectileEntity)projectile;
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            if (!hookProjectile.f_19853_.f_46443_ && (result = event.getRayTraceResult()) != null && result.m_6662_() == HitResult.Type.ENTITY) {
                LivingEntity hitLivingEntity;
                Player shooter;
                Entity hitEntity = ((EntityHitResult)result).m_82443_();
                if (hitEntity != (shooter = hookProjectile.getShootingPlayer()) && hitEntity instanceof LivingEntity && !((hitLivingEntity = (LivingEntity)hitEntity) instanceof ArmorStand)) {
                    if (hitLivingEntity instanceof Player && shooter instanceof Player && !shooter.m_7099_((Player)hitLivingEntity)) {
                        return;
                    }
                    if (shooter instanceof Player) {
                        Player player = shooter;
                        float damage = (float)hookProjectile.m_36789_();
                        hitLivingEntity.m_6469_(hitEntity.f_19853_.m_269111_().m_269425_(), damage);
                        double knockback = 0.2;
                        double knockbackResistance = Math.max(0.0, 1.0 - hitLivingEntity.m_21133_(Attributes.f_22278_));
                        Vec3 vec3 = hookProjectile.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
                        if (vec3.m_82556_() > 0.0) {
                            // empty if block
                        }
                        double x = hitEntity.m_20185_();
                        double y = hitEntity.m_20188_();
                        double z = hitEntity.m_20189_();
                        RandomSource random = hitEntity.f_19853_.m_213780_();
                        int particleCount = random.m_216332_(2, 4);
                        double spread = 0.2;
                        for (int i = 0; i < particleCount; ++i) {
                            double offsetX = random.m_188583_() * spread;
                            double offsetY = random.m_188583_() * spread;
                            double offsetZ = random.m_188583_() * spread;
                            ParticleHelper.spawnParticle(hitEntity.f_19853_, (ParticleOptions)ParticleTypes.f_123797_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                        }
                    }
                }
                hookProjectile.setShouldRetract(true);
            }
        }
    }
}

