/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.hookshot.item.custom;

import java.util.UUID;
import net.mezimaru.hookshot.entity.ModEntities;
import net.mezimaru.hookshot.entity.custom.EndershotHookProjectileEntity;
import net.mezimaru.hookshot.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.hookshot.item.custom.BaseHookshotItem;
import net.mezimaru.hookshot.network.ModMessages;
import net.mezimaru.hookshot.network.packet.HookshotOwnerS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EndershotItem
extends BaseHookshotItem {
    public EndershotItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        if (!pLevel.f_46443_) {
            ItemStack itemstack = player.m_21120_(pHand);
            if (this.isHookShotActive(player)) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            UUID playerUUID = player.m_20148_();
            EndershotHookProjectileEntity projectile = new EndershotHookProjectileEntity((EntityType<EndershotHookProjectileEntity>)((EntityType)ModEntities.ENDERSHOT_HOOK.get()), player, pLevel);
            Vec3 handPos = projectile.getHookshotHoldPosition(1.0f, player, pHand);
            projectile.m_5602_((Entity)player);
            projectile.m_6034_(handPos.f_82479_, player.m_20188_() - 0.5, handPos.f_82481_);
            this.setProjectileProperties(projectile, itemstack, player);
            player.m_6672_(pHand);
            pLevel.m_7967_((Entity)projectile);
            player.m_36335_().m_41524_((Item)this, 50);
            this.setShotFlag(itemstack, true);
            ModMessages.sendToNearbyClients(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
        }
        this.playShootSound(pLevel, player);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(pHand));
    }

    @Override
    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            boolean bl = player.m_21205_() == pStack || player.m_21206_() == pStack;
        }
    }

    private Vec3 getHandPosition(Player player, ItemStack stack) {
        boolean isMainHand = player.m_21205_() == stack;
        HumanoidArm hand = isMainHand ? player.m_5737_() : player.m_5737_().m_20828_();
        float sideOffset = hand == HumanoidArm.RIGHT ? -0.4f : 0.4f;
        return new Vec3(player.m_20185_() + (double)sideOffset, player.m_20188_() - 0.7, player.m_20189_());
    }

    @Override
    protected void setProjectileProperties(HookshotHookProjectileEntity projectile, ItemStack itemstack, Player player) {
        projectile.setProperties(itemstack, 20.0, 10.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
    }

    @Override
    protected ChatFormatting getColorForType(ItemStack stack) {
        return ChatFormatting.DARK_GREEN;
    }
}

