/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.hookshot.network.packet;

import net.mezimaru.hookshot.entity.custom.HookshotHookProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class HookshotRetractingS2CPacket {
    private final int projectileEntityId;
    private final boolean isRetracting;

    public HookshotRetractingS2CPacket(FriendlyByteBuf buffer) {
        this.projectileEntityId = buffer.readInt();
        this.isRetracting = buffer.readBoolean();
    }

    public HookshotRetractingS2CPacket(int projectileEntityId, Boolean isRetracting) {
        this.projectileEntityId = projectileEntityId;
        this.isRetracting = isRetracting;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.projectileEntityId);
        buffer.writeBoolean(this.isRetracting);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.projectileEntityId)) instanceof HookshotHookProjectileEntity) {
                ((HookshotHookProjectileEntity)entity).setShouldRetract(this.isRetracting);
            }
        });
        context.setPacketHandled(true);
    }
}

