/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class WAGConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue revampedPatrol;
        public final ForgeConfigSpec.BooleanValue eatFood;
        public final ForgeConfigSpec.BooleanValue harvestPumpkinAndMelon;
        public final ForgeConfigSpec.BooleanValue healWithPotion;
        public final ForgeConfigSpec.BooleanValue fishing;
        public final ForgeConfigSpec.BooleanValue cookingMeat;
        public final ForgeConfigSpec.IntValue patrolNextTick;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> seedWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> plantableCropWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> cropWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> huntableWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> feedWhitelist;

        public Common(ForgeConfigSpec.Builder builder) {
            Predicate<Object> validator = o -> o instanceof String;
            this.revampedPatrol = builder.comment("Enable Pillager Patrol Revamped Mechanic.").define("Revamped Patrol", true);
            this.eatFood = builder.comment("Enable Villager Eat Food.").define("Villager Eat Food", true);
            this.harvestPumpkinAndMelon = builder.comment("Enable Harvest Pumpkin And Melon.").define("Harvest Pumpkin And Melon", true);
            this.healWithPotion = builder.comment("Enable Villager do Heal With Potion.").define("Heal With Potion", true);
            this.fishing = builder.comment("Enable Villager Fishing.").define("Villager Fishing", true);
            this.cookingMeat = builder.comment("Enable Villager Cooking Meat.").define("Villager Cooking Meat", true);
            this.patrolNextTick = builder.comment("Set the Pillager Patrol Next Tick.").defineInRange("Pillager Patrol Next Tick", 12000, 6000, 48000);
            this.seedWhitelist = builder.comment("Add Item for What Villager can plant seed and compostable [example: farmersdelight:cabbage_seeds]").defineList("Villager's Seed Whitelist", (List)Lists.newArrayList((Object[])new String[]{"farmersdelight:cabbage_seeds"}), validator);
            this.plantableCropWhitelist = builder.comment("Add Item for What Villager can plant crop [example: minecraft:carrot]").defineList("Villager's Plantable Crop Whitelist", (List)Lists.newArrayList((Object[])new String[]{"farmersdelight:onion"}), validator);
            this.cropWhitelist = builder.comment("Add Item for What Villager can eatable about crop(you should set eatable food. when you set non eatable food. villager not eat forever!) [example: minecraft:carrot]").defineList("Villager's Crop Whitelist", (List)Lists.newArrayList((Object[])new String[]{"neapolitan:strawberries", "neapolitan:banana", "farmersdelight:cabbage", "farmersdelight:onion", "farmersdelight:tomato"}), validator);
            this.foodWhitelist = builder.comment("Add Item for What Villager can eatable about food(you should set eatable food. when you set non eatable food. villager not eat forever!) [example: minecraft:apple]").defineList("Villager's Food Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:cod", "minecraft:salmon", "neapolitan:strawberry_scones", "neapolitan:banana_bread", "neapolitan:dried_banana", "neapolitan:chocolate_strawberries", "farmersdelight:cake_slice", "farmersdelight:apple_pie_slice", "farmersdelight:chocolate_pie_slice", "farmersdelight:sweet_berry_cookie", "farmersdelight:honey_cookie"}), validator);
            this.huntableWhitelist = builder.comment("Add What Butcher Villager can Hunt [example: minecraft:cow]").defineList("Butcher Villager 's Hunt Entity Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:cow", "minecraft:sheep", "minecraft:chicken", "minecraft:rabbit", "minecraft:pig", "earthmobsmod:fancy_chicken", "earthmobsmod:jumbo_rabbit", "earthmobsmod:duck"}), validator);
            this.feedWhitelist = builder.comment("Add What Farmer Villager can Feed[example: minecraft:cow]").defineList("Farmer Villager 's Feed Entity Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:cow", "minecraft:sheep", "minecraft:chicken", "minecraft:pig", "earthmobsmod:fancy_chicken", "earthmobsmod:duck"}), validator);
        }
    }
}

