/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity;

import baguchan.wealthy_and_growth.api.IFishing;
import baguchan.wealthy_and_growth.register.ModEntities;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class VillagerFishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource syncronizedRandom = RandomSource.m_216327_();
    private boolean biting;
    private int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.m_135353_(VillagerFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.m_135353_(VillagerFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int life;
    public int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    private Entity hookedIn;
    public FishHookState currentState = FishHookState.FLYING;
    private final int luck;
    private final int lureSpeed;

    private VillagerFishingHook(EntityType<? extends VillagerFishingHook> p_150141_, Level p_150142_, int p_150143_, int p_150144_) {
        super(p_150141_, p_150142_);
        this.f_19811_ = true;
        this.luck = Math.max(0, p_150143_);
        this.lureSpeed = Math.max(0, p_150144_);
    }

    public VillagerFishingHook(EntityType<? extends VillagerFishingHook> p_150138_, Level p_150139_) {
        this(p_150138_, p_150139_, 0, 0);
    }

    public VillagerFishingHook(LivingEntity p_37106_, Level p_37107_, int p_37108_, int p_37109_) {
        this((EntityType<? extends VillagerFishingHook>)((EntityType)ModEntities.FISHING_HOOK.get()), p_37107_, p_37108_, p_37109_);
        this.m_5602_((Entity)p_37106_);
        float f = p_37106_.m_146909_();
        float f1 = p_37106_.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = p_37106_.m_20185_() - (double)f3 * 0.3;
        double d1 = p_37106_.m_20188_();
        double d2 = p_37106_.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        vec3 = vec3.m_82542_(0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365));
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_HOOKED_ENTITY, (Object)0);
        this.m_20088_().m_135372_(DATA_BITING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> p_37153_) {
        if (DATA_HOOKED_ENTITY.equals(p_37153_)) {
            int i = (Integer)this.m_20088_().m_135370_(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i > 0 ? this.m_9236_().m_6815_(i - 1) : null;
        }
        if (DATA_BITING.equals(p_37153_)) {
            this.biting = (Boolean)this.m_20088_().m_135370_(DATA_BITING);
            if (this.biting) {
                this.m_20334_(this.m_20184_().f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.syncronizedRandom, (float)0.6f, (float)1.0f), this.m_20184_().f_82481_);
            }
        }
        super.m_7350_(p_37153_);
    }

    public boolean m_6783_(double p_37125_) {
        double d0 = 64.0;
        return p_37125_ < 4096.0;
    }

    public void m_6453_(double p_37127_, double p_37128_, double p_37129_, float p_37130_, float p_37131_, int p_37132_, boolean p_37133_) {
    }

    public void m_8119_() {
        this.syncronizedRandom.m_188584_(this.m_20148_().getLeastSignificantBits() ^ this.m_9236_().m_46467_());
        super.m_8119_();
        Entity player = this.m_19749_();
        if (player == null && !(player instanceof LivingEntity)) {
            this.m_146870_();
        } else if (this.m_9236_().f_46443_ || !this.shouldStopFishing(player)) {
            boolean flag;
            if (this.m_20096_()) {
                ++this.life;
                if (this.life >= 200) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            FluidState fluidstate = this.m_9236_().m_6425_(blockpos);
            if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                f = fluidstate.m_76155_((BlockGetter)this.m_9236_(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.m_213877_() && this.hookedIn.m_9236_().m_46472_() == this.m_9236_().m_46472_()) {
                            this.m_6034_(this.hookedIn.m_20185_(), this.hookedIn.m_20227_(0.8), this.hookedIn.m_20189_());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    Vec3 vec3 = this.m_20184_();
                    double d0 = this.m_20186_() + vec3.f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m_20334_(vec3.f_82479_ * 0.9, vec3.f_82480_ - d0 * (double)this.f_19796_.m_188501_() * 0.2, vec3.f_82481_ * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockpos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.syncronizedRandom.m_188501_() * (double)this.syncronizedRandom.m_188501_(), 0.0));
                        }
                        if (!this.m_9236_().f_46443_) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            if (this.currentState == FishHookState.FLYING && (this.m_20096_() || this.f_19862_)) {
                this.m_20256_(Vec3.f_82478_);
            }
            double d1 = 0.92;
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_20090_();
        }
    }

    private boolean shouldStopFishing(Entity p_37137_) {
        if (!p_37137_.m_213877_() && p_37137_.m_6084_() && !(this.m_20280_(p_37137_) > 1024.0)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitresult.m_6662_() == HitResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    protected boolean m_5603_(Entity p_37135_) {
        return super.m_5603_(p_37135_) || p_37135_.m_6084_() && p_37135_ instanceof ItemEntity;
    }

    protected void m_5790_(EntityHitResult p_37144_) {
        super.m_5790_(p_37144_);
        if (!this.m_9236_().f_46443_) {
            this.setHookedEntity(p_37144_.m_82443_());
        }
    }

    protected void m_8060_(BlockHitResult p_37142_) {
        super.m_8060_(p_37142_);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(p_37142_.m_82448_((Entity)this)));
    }

    private void setHookedEntity(@Nullable Entity p_150158_) {
        this.hookedIn = p_150158_;
        this.m_20088_().m_135381_(DATA_HOOKED_ENTITY, (Object)(p_150158_ == null ? 0 : p_150158_.m_19879_() + 1));
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerLevel serverlevel = (ServerLevel)this.m_9236_();
        int i = 1;
        BlockPos blockpos = p_37146_.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.m_9236_().m_46758_(blockpos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.m_9236_().m_45527_(blockpos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.m_20088_().m_135381_(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.f_19796_.m_216328_(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f);
                float f2 = Mth.m_14089_((float)f);
                double d0 = this.m_20185_() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                double d1 = (float)Mth.m_14107_((double)this.m_20186_()) + 1.0f;
                double d2 = this.m_20189_() + (double)(f2 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = serverlevel.m_8055_(BlockPos.m_274561_((double)d0, (double)(d1 - 1.0), (double)d2));
                if (serverlevel.m_6425_(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).m_192917_((Fluid)Fluids.f_76193_)) {
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                double d3 = this.m_20186_() + 0.5;
                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                this.nibble = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.f_19796_.m_188501_() < f5) {
                double d6;
                double d5;
                float f6 = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d4 = this.m_20185_() + (double)(Mth.m_14031_((float)f6) * f7) * 0.1;
                BlockState blockstate1 = serverlevel.m_8055_(BlockPos.m_274561_((double)d4, (double)((d5 = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(d6 = this.m_20189_() + (double)(Mth.m_14089_((float)f6) * f7) * 0.1)));
                if (blockstate1.m_60713_(Blocks.f_49990_)) {
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    private boolean calculateOpenWater(BlockPos p_37159_) {
        OpenWaterType fishinghook$openwatertype = OpenWaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenWaterType fishinghook$openwatertype1 = this.getOpenWaterTypeForArea(p_37159_.m_7918_(-2, i, -2), p_37159_.m_7918_(2, i, 2));
            switch (fishinghook$openwatertype1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (fishinghook$openwatertype != OpenWaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (fishinghook$openwatertype != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            fishinghook$openwatertype = fishinghook$openwatertype1;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.m_121990_((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.m_9236_().m_8055_(p_37164_);
        if (!blockstate.m_60795_() && !blockstate.m_60713_(Blocks.f_50196_)) {
            FluidState fluidstate = blockstate.m_60819_();
            return fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76170_() && blockstate.m_60812_((BlockGetter)this.m_9236_(), p_37164_).m_83281_() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    public void m_7380_(CompoundTag p_37161_) {
    }

    public void m_7378_(CompoundTag p_37151_) {
    }

    public int retrieve(ItemStack p_37157_) {
        Entity player = this.m_19749_();
        if (!this.m_9236_().f_46443_ && player != null && !this.shouldStopFishing((Entity)((LivingEntity)player))) {
            int i = 0;
            if (this.hookedIn != null) {
                this.pullEntity(this.hookedIn);
                this.m_9236_().m_7605_((Entity)this, (byte)31);
                i = this.hookedIn instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)p_37157_).m_287286_(LootContextParams.f_81455_, (Object)this).m_287239_((float)this.luck);
                lootcontext$builder.m_287286_(LootContextParams.f_81458_, (Object)this.m_19749_()).m_287286_(LootContextParams.f_81455_, (Object)this);
                LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
                ObjectArrayList list = loottable.m_287195_(lootcontext$builder.m_287235_(LootContextParamSets.f_81414_));
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemstack);
                    double d0 = player.m_20185_() - this.m_20185_();
                    double d1 = player.m_20186_() - this.m_20186_();
                    double d2 = player.m_20189_() - this.m_20189_();
                    double d3 = 0.1;
                    itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.m_9236_().m_7967_((Entity)itementity);
                }
                i = 1;
            }
            if (this.m_20096_()) {
                i = 2;
            }
            this.m_146870_();
            return i;
        }
        return 0;
    }

    public void m_7822_(byte p_37123_) {
        if (p_37123_ == 31 && this.m_9236_().f_46443_ && this.hookedIn instanceof Player && ((Player)this.hookedIn).m_7578_()) {
            this.pullEntity(this.hookedIn);
        }
        super.m_7822_(p_37123_);
    }

    protected void pullEntity(Entity p_150156_) {
        Entity entity = this.m_19749_();
        if (entity != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20186_() - this.m_20186_(), entity.m_20189_() - this.m_20189_()).m_82490_(0.1);
            p_150156_.m_20256_(p_150156_.m_20184_().m_82549_(vec3));
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason p_150146_) {
        this.updateOwnerInfo(null);
        super.m_142687_(p_150146_);
    }

    public void m_142036_() {
        this.updateOwnerInfo(null);
    }

    public void m_5602_(@Nullable Entity p_150154_) {
        super.m_5602_(p_150154_);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable VillagerFishingHook p_150148_) {
        Entity entity = this.m_19749_();
        if (entity != null && entity instanceof IFishing) {
            IFishing villager = (IFishing)entity;
            villager.setFishingHook(p_150148_);
        }
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? this.m_19879_() : entity.m_19879_());
    }

    public void m_141965_(ClientboundAddEntityPacket p_150150_) {
        super.m_141965_(p_150150_);
        if (this.m_19749_() == null) {
            int i = p_150150_.m_131509_();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.m_9236_().m_6815_(i), (Object)i);
            this.m_6074_();
        }
    }

    public static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

