/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class HarvestPumpkinAndMelon
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos aboveFruitPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validFruitAroundVillager = Lists.newArrayList();

    public HarvestPumpkinAndMelon() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)p_23174_, (Entity)p_23175_)) {
            return false;
        }
        if (p_23175_.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_23175_.m_20183_().m_122032_();
        this.validFruitAroundVillager.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    blockpos$mutableblockpos.m_122169_(p_23175_.m_20185_() + (double)i, p_23175_.m_20186_() + (double)j, p_23175_.m_20189_() + (double)k);
                    if (!this.validPos((BlockPos)blockpos$mutableblockpos, p_23174_)) continue;
                    this.validFruitAroundVillager.add(new BlockPos((Vec3i)blockpos$mutableblockpos));
                }
            }
        }
        this.aboveFruitPos = this.getValidFruit(p_23174_);
        return this.aboveFruitPos != null;
    }

    @Nullable
    private BlockPos getValidFruit(ServerLevel p_23165_) {
        return this.validFruitAroundVillager.isEmpty() ? null : this.validFruitAroundVillager.get(p_23165_.m_213780_().m_188503_(this.validFruitAroundVillager.size()));
    }

    private boolean validPos(BlockPos p_23181_, ServerLevel p_23182_) {
        BlockState blockstate = p_23182_.m_8055_(p_23181_);
        BlockState blockstate2 = p_23182_.m_8055_(p_23181_.m_7495_());
        BlockState blockstate3 = p_23182_.m_8055_(p_23181_.m_7494_());
        Block block = blockstate.m_60734_();
        return (block == Blocks.f_50133_ || block == Blocks.f_50186_) && blockstate2.m_204336_(BlockTags.f_144274_) && blockstate3.m_60795_();
    }

    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (p_23179_ > this.nextOkStartTime && this.aboveFruitPos != null) {
            p_23178_.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.aboveFruitPos));
            p_23178_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFruitPos), 0.5f, 1));
        }
    }

    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        p_23189_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = p_23190_ + 40L;
    }

    protected void tick(ServerLevel p_23196_, Villager p_23197_, long p_23198_) {
        if (this.aboveFruitPos != null && this.aboveFruitPos.m_123314_((Vec3i)p_23197_.m_20183_(), 2.5)) {
            BlockState blockstate;
            Block block;
            if (this.aboveFruitPos != null && p_23198_ > this.nextOkStartTime && ((block = (blockstate = p_23196_.m_8055_(this.aboveFruitPos)).m_60734_()) == Blocks.f_50133_ || block == Blocks.f_50186_)) {
                p_23196_.m_46953_(this.aboveFruitPos, true, (Entity)p_23197_);
                this.validFruitAroundVillager.remove(this.aboveFruitPos);
                this.aboveFruitPos = this.getValidFruit(p_23196_);
                if (this.aboveFruitPos != null) {
                    this.nextOkStartTime = p_23198_ + 20L;
                    p_23197_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFruitPos), 0.5f, 1));
                    p_23197_.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.aboveFruitPos));
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        return this.timeWorkedSoFar < 200;
    }
}

