/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity.behavior;

import baguchan.wealthy_and_growth.WAGConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class Hunting
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    private int timeWorkedSoFar;
    private Animal targetEntity;

    public Hunting() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)p_23174_, (Entity)p_23175_)) {
            return false;
        }
        if (p_23175_.m_7141_().m_35571_() != VillagerProfession.f_35587_) {
            return false;
        }
        if (p_23175_.m_35514_()) {
            return false;
        }
        List animals = p_23175_.m_9236_().m_45971_(Animal.class, TargetingConditions.m_148352_().m_26883_(16.0), (LivingEntity)p_23175_, p_23175_.m_20191_().m_82377_(10.0, 8.0, 10.0));
        ArrayList copy = Lists.newArrayList((Iterable)animals);
        if (!copy.isEmpty() && copy.size() > 5) {
            Collections.shuffle(copy);
            if (((List)WAGConfig.COMMON.huntableWhitelist.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)((Animal)copy.get(0)).m_6095_()).toString()) && !((Animal)copy.get(0)).m_6162_() && p_23175_.m_142582_((Entity)copy.get(0))) {
                this.targetEntity = (Animal)copy.get(0);
            }
        }
        return this.targetEntity != null;
    }

    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (this.targetEntity != null) {
            p_23178_.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23178_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.615f, 1));
        }
    }

    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        p_23189_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.timeWorkedSoFar = 0;
    }

    protected void tick(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        ++this.timeWorkedSoFar;
        if (this.targetEntity != null && this.targetEntity.m_6084_()) {
            if (p_23189_.m_217066_((LivingEntity)this.targetEntity)) {
                this.targetEntity.m_6469_(p_23189_.m_269291_().m_269333_((LivingEntity)p_23189_), 2.0f);
            }
            p_23189_.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23189_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.615f, 1));
        }
    }

    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        return this.timeWorkedSoFar < 400 && this.targetEntity != null && this.targetEntity.m_6084_();
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

