/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.mixin;

import baguchan.wealthy_and_growth.api.IFishing;
import baguchan.wealthy_and_growth.entity.VillagerFishingHook;
import baguchan.wealthy_and_growth.register.VillagerFoods;
import baguchan.wealthy_and_growth.utils.ContainerUtils;
import javax.annotation.Nullable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements IFishing {
    @Shadow
    private int f_35376_;
    @Nullable
    public VillagerFishingHook fishing;

    public VillagerMixin(EntityType<? extends AbstractVillager> p_35267_, Level p_35268_) {
        super(p_35267_, p_35268_);
    }

    @Inject(at={@At(value="HEAD")}, method={"eatUntilFull"}, cancellable=true)
    private void eatUntilFull(CallbackInfo callbackInfo) {
        if (this.m_35525_() && this.countFoodPointsInInventory() != 0) {
            block0: for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.m_35311_().m_8020_(i);
                if (itemstack.m_41619_() || (integer = VillagerFoods.FOOD_POINTS.get(itemstack.m_41720_())) == null) continue;
                for (int k = j = itemstack.m_41613_(); k > 0; --k) {
                    this.f_35376_ = (byte)(this.f_35376_ + integer);
                    this.m_35311_().m_7407_(i, 1);
                    if (this.m_35525_()) continue;
                    callbackInfo.cancel();
                    continue block0;
                }
            }
        }
    }

    @Shadow
    private boolean m_35525_() {
        return false;
    }

    @Override
    @Nullable
    public VillagerFishingHook getFishingHook() {
        return this.fishing;
    }

    @Override
    public void setFishingHook(@Nullable VillagerFishingHook fishing) {
        this.fishing = fishing;
    }

    private int countFoodPointsInInventory() {
        SimpleContainer simplecontainer = this.m_35311_();
        return VillagerFoods.FOOD_POINTS.entrySet().stream().mapToInt(p_186300_ -> simplecontainer.m_18947_((Item)p_186300_.getKey()) * (Integer)p_186300_.getValue()).sum();
    }

    @Inject(at={@At(value="RETURN")}, method={"wantsToPickUp"}, cancellable=true)
    public void wantsToPickUp(ItemStack p_35543_, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Item item = p_35543_.m_41720_();
        callbackInfoReturnable.setReturnValue((Object)((VillagerFoods.WANTED_ITEMS.contains(item) || (Boolean)callbackInfoReturnable.getReturnValue() != false || this.m_7141_().m_35571_().f_35602_().contains((Object)item)) && this.m_35311_().m_19183_(p_35543_) ? 1 : 0));
    }

    @Shadow
    public VillagerData m_7141_() {
        return null;
    }

    @Inject(at={@At(value="RETURN")}, method={"hasFarmSeeds"}, cancellable=true)
    public void hasFarmSeeds(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)(ContainerUtils.hasAnyOf(this.m_35311_(), VillagerFoods.PLANTS_ITEMS) || (Boolean)callbackInfoReturnable.getReturnValue() != false ? 1 : 0));
    }

    public ItemStack m_5584_(Level p_21067_, ItemStack p_21068_) {
        if (p_21068_.m_41614_()) {
            this.m_5634_(p_21068_.getFoodProperties((LivingEntity)this).m_38744_());
        }
        return super.m_5584_(p_21067_, p_21068_);
    }
}

