/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.capability;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PlayerTargetCapability
implements INBTSerializable<CompoundTag> {
    private float effectiveTargetScale;

    public void tick(LivingEntity entity) {
        if (entity.level().dayTime() % 1200L == 0L && entity.level() instanceof ServerLevel) {
            if (((ServerLevel)entity.level()).isCloseToVillage(entity.blockPosition(), 2)) {
                this.setEffectiveTargetScale(this.getEffectiveTargetScale() + 0.01f);
            } else {
                this.setEffectiveTargetScale(this.getEffectiveTargetScale() - 0.04f);
            }
        }
    }

    public void setEffectiveTargetScale(float effectiveTargetScale) {
        float f;
        this.effectiveTargetScale = f = Mth.clamp((float)effectiveTargetScale, (float)0.0f, (float)1.0f);
    }

    public float getEffectiveTargetScale() {
        return this.effectiveTargetScale;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("EffectiveTargetScale", this.effectiveTargetScale);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.effectiveTargetScale = nbt.getFloat("EffectiveTargetScale");
    }
}

