/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity.behavior;

import baguchan.wealthy_and_growth.WAGConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class FeedToAnimal
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    private int timeWorkedSoFar;
    private Animal targetEntity;
    private Animal targetSecondEntity;
    private int usingSlot;

    public FeedToAnimal() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!EventHooks.canEntityGrief((Level)p_23174_, (Entity)p_23175_)) {
            return false;
        }
        if (p_23175_.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        List animals = p_23175_.level().getNearbyEntities(Animal.class, TargetingConditions.forCombat().range(16.0), (LivingEntity)p_23175_, p_23175_.getBoundingBox().inflate(8.0, 6.0, 8.0));
        ArrayList copy = Lists.newArrayList((Iterable)animals);
        if (!copy.isEmpty() && copy.size() >= 2 && copy.size() < 6) {
            Collections.shuffle(copy);
            for (int i = 0; i < p_23175_.getInventory().getContainerSize(); ++i) {
                ItemStack stack = p_23175_.getInventory().getItem(i);
                if (!((List)WAGConfig.COMMON.feedWhitelist.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((Animal)copy.get(0)).getType()).toString()) || ((Animal)copy.get(0)).isBaby() || !((Animal)copy.get(0)).isFood(stack) || !((Animal)copy.get(0)).canFallInLove() || !p_23175_.hasLineOfSight((Entity)copy.get(0))) continue;
                this.targetEntity = (Animal)copy.get(0);
                Optional<Animal> optional = copy.stream().filter(animal -> !animal.isBaby() && animal.canFallInLove() && animal.getType() == this.targetEntity.getType() && animal != this.targetEntity).findFirst();
                if (!optional.isPresent()) continue;
                this.usingSlot = i;
                this.targetSecondEntity = optional.get();
            }
        }
        return this.targetEntity != null && this.targetSecondEntity != null;
    }

    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (this.targetEntity != null) {
            p_23178_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23178_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.6f, 1));
        }
    }

    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        p_23189_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
    }

    protected void tick(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        ++this.timeWorkedSoFar;
        if (this.targetEntity != null && this.targetEntity.isAlive() && this.targetEntity.canFallInLove()) {
            p_23189_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23189_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.6f, 1));
            if (p_23189_.distanceToSqr((Entity)this.targetEntity) < 24.0) {
                this.targetEntity.setInLoveTime(600);
                ItemStack stack = p_23189_.getInventory().getItem(this.usingSlot);
                stack.shrink(1);
            }
        } else if (this.targetSecondEntity != null && this.targetSecondEntity.isAlive() && this.targetSecondEntity.canFallInLove()) {
            p_23189_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetSecondEntity, true));
            p_23189_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetSecondEntity, true), 0.6f, 1));
            if (p_23189_.distanceToSqr((Entity)this.targetSecondEntity) < 24.0) {
                this.targetSecondEntity.setInLoveTime(600);
                ItemStack stack = p_23189_.getInventory().getItem(this.usingSlot);
                stack.shrink(1);
            }
        }
    }

    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        ItemStack stack = p_23205_.getInventory().getItem(this.usingSlot);
        return !stack.isEmpty() && this.timeWorkedSoFar < 400 && this.targetEntity != null && this.targetEntity.isAlive() && this.targetSecondEntity != null && this.targetSecondEntity.isAlive() && (this.targetEntity.canFallInLove() || this.targetSecondEntity.canFallInLove());
    }

    protected boolean timedOut(long p_22537_) {
        return false;
    }
}

