/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;

public class HarvestPumpkinAndMelon
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos aboveFruitPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validFruitAroundVillager = Lists.newArrayList();

    public HarvestPumpkinAndMelon() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!EventHooks.canEntityGrief((Level)p_23174_, (Entity)p_23175_)) {
            return false;
        }
        if (p_23175_.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_23175_.blockPosition().mutable();
        this.validFruitAroundVillager.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    blockpos$mutableblockpos.set(p_23175_.getX() + (double)i, p_23175_.getY() + (double)j, p_23175_.getZ() + (double)k);
                    if (!this.validPos((BlockPos)blockpos$mutableblockpos, p_23174_)) continue;
                    this.validFruitAroundVillager.add(new BlockPos((Vec3i)blockpos$mutableblockpos));
                }
            }
        }
        this.aboveFruitPos = this.getValidFruit(p_23174_);
        return this.aboveFruitPos != null;
    }

    @Nullable
    private BlockPos getValidFruit(ServerLevel p_23165_) {
        return this.validFruitAroundVillager.isEmpty() ? null : this.validFruitAroundVillager.get(p_23165_.getRandom().nextInt(this.validFruitAroundVillager.size()));
    }

    private boolean validPos(BlockPos p_23181_, ServerLevel p_23182_) {
        BlockState blockstate = p_23182_.getBlockState(p_23181_);
        BlockState blockstate2 = p_23182_.getBlockState(p_23181_.below());
        BlockState blockstate3 = p_23182_.getBlockState(p_23181_.above());
        Block block = blockstate.getBlock();
        return (block == Blocks.PUMPKIN || block == Blocks.MELON) && blockstate2.is(BlockTags.DIRT) && blockstate3.isAir();
    }

    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (p_23179_ > this.nextOkStartTime && this.aboveFruitPos != null) {
            p_23178_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.aboveFruitPos));
            p_23178_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFruitPos), 0.5f, 1));
        }
    }

    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        p_23189_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = p_23190_ + 40L;
    }

    protected void tick(ServerLevel p_23196_, Villager p_23197_, long p_23198_) {
        if (this.aboveFruitPos != null && this.aboveFruitPos.closerThan((Vec3i)p_23197_.blockPosition(), 2.5)) {
            BlockState blockstate;
            Block block;
            if (this.aboveFruitPos != null && p_23198_ > this.nextOkStartTime && ((block = (blockstate = p_23196_.getBlockState(this.aboveFruitPos)).getBlock()) == Blocks.PUMPKIN || block == Blocks.MELON)) {
                p_23196_.destroyBlock(this.aboveFruitPos, true, (Entity)p_23197_);
                this.validFruitAroundVillager.remove(this.aboveFruitPos);
                this.aboveFruitPos = this.getValidFruit(p_23196_);
                if (this.aboveFruitPos != null) {
                    this.nextOkStartTime = p_23198_ + 20L;
                    p_23197_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFruitPos), 0.5f, 1));
                    p_23197_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.aboveFruitPos));
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        return this.timeWorkedSoFar < 200;
    }
}

