/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.entity.behavior;

import baguchan.wealthy_and_growth.WAGConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class Hunting
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    private int timeWorkedSoFar;
    private Animal targetEntity;

    public Hunting() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!EventHooks.canEntityGrief((Level)p_23174_, (Entity)p_23175_)) {
            return false;
        }
        if (p_23175_.getVillagerData().getProfession() != VillagerProfession.BUTCHER) {
            return false;
        }
        if (p_23175_.hasExcessFood()) {
            return false;
        }
        List animals = p_23175_.level().getNearbyEntities(Animal.class, TargetingConditions.forCombat().range(16.0), (LivingEntity)p_23175_, p_23175_.getBoundingBox().inflate(10.0, 8.0, 10.0));
        ArrayList copy = Lists.newArrayList((Iterable)animals);
        if (!copy.isEmpty() && copy.size() > 5) {
            Collections.shuffle(copy);
            if (((List)WAGConfig.COMMON.huntableWhitelist.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((Animal)copy.get(0)).getType()).toString()) && !((Animal)copy.get(0)).isBaby() && p_23175_.hasLineOfSight((Entity)copy.get(0))) {
                this.targetEntity = (Animal)copy.get(0);
            }
        }
        return this.targetEntity != null;
    }

    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (this.targetEntity != null) {
            p_23178_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23178_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.615f, 1));
        }
    }

    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        p_23189_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
    }

    protected void tick(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        ++this.timeWorkedSoFar;
        if (this.targetEntity != null && this.targetEntity.isAlive()) {
            if (p_23189_.isWithinMeleeAttackRange((LivingEntity)this.targetEntity)) {
                this.targetEntity.hurt(p_23189_.damageSources().mobAttack((LivingEntity)p_23189_), 2.0f);
            }
            p_23189_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetEntity, true));
            p_23189_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.targetEntity, true), 0.615f, 1));
        }
    }

    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        return this.timeWorkedSoFar < 400 && this.targetEntity != null && this.targetEntity.isAlive();
    }

    protected boolean timedOut(long p_22537_) {
        return false;
    }
}

