/*
 * Decompiled with CFR 0.152.
 */
package baguchan.wealthy_and_growth.mixin;

import baguchan.wealthy_and_growth.api.IFishing;
import baguchan.wealthy_and_growth.entity.VillagerFishingHook;
import baguchan.wealthy_and_growth.register.VillagerFoods;
import baguchan.wealthy_and_growth.utils.ContainerUtils;
import javax.annotation.Nullable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements IFishing {
    @Shadow
    private int foodLevel;
    @Nullable
    public VillagerFishingHook fishing;

    public VillagerMixin(EntityType<? extends AbstractVillager> p_35267_, Level p_35268_) {
        super(p_35267_, p_35268_);
    }

    @Inject(at={@At(value="HEAD")}, method={"eatUntilFull"}, cancellable=true)
    private void eatUntilFull(CallbackInfo callbackInfo) {
        if (this.hungry() && this.countFoodPointsInInventory() != 0) {
            block0: for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.getInventory().getItem(i);
                if (itemstack.isEmpty() || (integer = VillagerFoods.FOOD_POINTS.get(itemstack.getItem())) == null) continue;
                for (int k = j = itemstack.getCount(); k > 0; --k) {
                    this.foodLevel = (byte)(this.foodLevel + integer);
                    this.getInventory().removeItem(i, 1);
                    if (this.hungry()) continue;
                    callbackInfo.cancel();
                    continue block0;
                }
            }
        }
    }

    @Shadow
    private boolean hungry() {
        return false;
    }

    @Override
    @Nullable
    public VillagerFishingHook getFishingHook() {
        return this.fishing;
    }

    @Override
    public void setFishingHook(@Nullable VillagerFishingHook fishing) {
        this.fishing = fishing;
    }

    private int countFoodPointsInInventory() {
        SimpleContainer simplecontainer = this.getInventory();
        return VillagerFoods.FOOD_POINTS.entrySet().stream().mapToInt(p_186300_ -> simplecontainer.countItem((Item)p_186300_.getKey()) * (Integer)p_186300_.getValue()).sum();
    }

    @Inject(at={@At(value="RETURN")}, method={"wantsToPickUp"}, cancellable=true)
    public void wantsToPickUp(ItemStack p_35543_, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Item item = p_35543_.getItem();
        callbackInfoReturnable.setReturnValue((Object)((VillagerFoods.WANTED_ITEMS.contains(item) || (Boolean)callbackInfoReturnable.getReturnValue() != false || this.getVillagerData().getProfession().requestedItems().contains((Object)item)) && this.getInventory().canAddItem(p_35543_) ? 1 : 0));
    }

    @Shadow
    public VillagerData getVillagerData() {
        return null;
    }

    @Inject(at={@At(value="RETURN")}, method={"hasFarmSeeds"}, cancellable=true)
    public void hasFarmSeeds(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)(ContainerUtils.hasAnyOf(this.getInventory(), VillagerFoods.PLANTS_ITEMS) || (Boolean)callbackInfoReturnable.getReturnValue() != false ? 1 : 0));
    }

    public ItemStack eat(Level p_347678_, ItemStack p_347507_, FoodProperties foodProperties) {
        if (foodProperties != null) {
            this.heal(foodProperties.nutrition());
        }
        return super.eat(p_347678_, p_347507_, foodProperties);
    }
}

