/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Optional;
import net.lunade.copper.SimpleCopperPipes;
import net.lunade.copper.block.CopperPipeBlock;
import net.lunade.copper.block.entity.data.TransferablePipeDataHandler;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.SimpleCopperPipesBlockStateProperties;
import net.lunade.copper.registry.TransferablePipeData;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSimpleCopperBlockEntity
extends class_2621
implements class_1263 {
    public final MoveType moveType;
    public class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    public int waterCooldown = -1;
    public int electricityCooldown = -1;
    public boolean canWater;
    public boolean canLava;
    public boolean canSmoke;
    public int lastFixVersion;
    public TransferablePipeDataHandler transferableDataHandler = new TransferablePipeDataHandler();

    public AbstractSimpleCopperBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, MoveType moveType) {
        super(blockEntityType, blockPos, blockState);
        this.moveType = moveType;
    }

    public static void sendElectricity(class_1937 level, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2586 class_25862;
            class_2680 state;
            class_2338 offsetPos = pos.method_10093(direction);
            if (!level.method_22340(offsetPos) || !(state = level.method_8320(offsetPos)).method_28498((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY) || !((class_25862 = level.method_8321(offsetPos)) instanceof AbstractSimpleCopperBlockEntity)) continue;
            AbstractSimpleCopperBlockEntity copperBlockEntity = (AbstractSimpleCopperBlockEntity)class_25862;
            if (copperBlockEntity.electricityCooldown != -1) continue;
            int axis = state.method_28498(CopperPipeBlock.FACING) ? ((class_2350)state.method_11654(CopperPipeBlock.FACING)).method_10166().ordinal() : direction.method_10166().ordinal();
            level.method_20290(3002, offsetPos, axis);
            level.method_8501(offsetPos, (class_2680)state.method_11657((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void serverTick(@NotNull class_1937 level, class_2338 pos, class_2680 originalState, SimpleCopperPipesConfig config) {
        boolean validSmoke;
        if (level.method_8608()) {
            return;
        }
        class_2680 state = originalState;
        if (this.lastFixVersion < 6 || SimpleCopperPipes.REFRESH_VALUES) {
            this.updateBlockEntityValues((class_4538)level, pos, originalState, config);
            this.lastFixVersion = 6;
        }
        if (this.canWater && !this.canLava && config.carryWater) {
            this.transferableDataHandler.setTransferablePipeData(TransferablePipeData.WATER, new TransferablePipeDataHandler.SaveableTransferablePipeData().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withID(TransferablePipeData.WATER));
        }
        if (this.canLava && !this.canWater && config.carryLava) {
            this.transferableDataHandler.setTransferablePipeData(TransferablePipeData.LAVA, new TransferablePipeDataHandler.SaveableTransferablePipeData().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withID(TransferablePipeData.LAVA));
        }
        if (this.canSmoke && !this.canWater && !this.canLava || this.canWater && this.canLava && config.carrySmoke) {
            this.transferableDataHandler.setTransferablePipeData(TransferablePipeData.SMOKE, new TransferablePipeDataHandler.SaveableTransferablePipeData().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withID(TransferablePipeData.SMOKE));
        }
        TransferablePipeDataHandler.SaveableTransferablePipeData waterData = this.transferableDataHandler.getTransferablePipeData(TransferablePipeData.WATER);
        TransferablePipeDataHandler.SaveableTransferablePipeData lavaData = this.transferableDataHandler.getTransferablePipeData(TransferablePipeData.LAVA);
        TransferablePipeDataHandler.SaveableTransferablePipeData smokeData = this.transferableDataHandler.getTransferablePipeData(TransferablePipeData.SMOKE);
        boolean validWater = this.isValidFluidNBT(waterData) && config.carryWater;
        boolean validLava = this.isValidFluidNBT(lavaData) && config.carryLava;
        boolean bl = validSmoke = this.isValidFluidNBT(smokeData) && config.carrySmoke;
        if (this.canSmoke && (this.canLava && !this.canWater || this.canWater && !this.canLava)) {
            validSmoke = false;
        }
        if (this.canWater && this.canLava) {
            validSmoke = config.carrySmoke;
            validWater = false;
            validLava = false;
        }
        if (state.method_28498(SimpleCopperPipesBlockStateProperties.FLUID)) {
            state = (class_2680)state.method_11657(SimpleCopperPipesBlockStateProperties.FLUID, (Comparable)((Object)(validWater ? PipeFluid.WATER : (validLava ? PipeFluid.LAVA : (validSmoke ? PipeFluid.SMOKE : PipeFluid.NONE)))));
        }
        this.tickTransferableData((class_3218)level, pos, originalState);
        this.dispenseTransferableData((class_3218)level, pos, originalState);
        this.moveTransferableData((class_3218)level, pos, originalState);
        if (this.electricityCooldown >= 0) {
            --this.electricityCooldown;
        }
        if (this.electricityCooldown == -1 && ((Boolean)state.method_11654((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY)).booleanValue()) {
            this.electricityCooldown = 80;
            Optional previous = class_5955.method_34732((class_2248)state.method_26204());
            if (previous.isPresent()) {
                state = ((class_2248)previous.get()).method_34725(state);
            }
        }
        if (this.electricityCooldown == 79) {
            AbstractSimpleCopperBlockEntity.sendElectricity(level, pos);
        }
        if (this.electricityCooldown == 0 && state.method_28498((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY)) {
            state = (class_2680)state.method_11657((class_2769)SimpleCopperPipesBlockStateProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(false));
        }
        if (state != originalState) {
            level.method_8501(pos, state);
        }
    }

    public boolean isValidFluidNBT(@Nullable TransferablePipeDataHandler.SaveableTransferablePipeData fluidData) {
        if (fluidData != null) {
            return fluidData.vec3d.method_10216() > 0.0;
        }
        return false;
    }

    public void updateBlockEntityValues(class_4538 level, class_2338 pos, class_2680 state, SimpleCopperPipesConfig config) {
    }

    public boolean canAcceptTransferableData(MoveType moveType, class_2350 moveDirection, class_2680 fromState) {
        return true;
    }

    public boolean canTransferDataInDirection(class_2350 direction, class_2680 state) {
        return true;
    }

    public void tickTransferableData(class_3218 level, class_2338 pos, class_2680 state) {
        ImmutableList.copyOf(this.transferableDataHandler.getSavedDataList()).forEach(data -> data.tick(level, pos, state, this));
    }

    public void dispenseTransferableData(class_3218 level, class_2338 pos, class_2680 state) {
    }

    public void moveTransferableData(class_3218 level, class_2338 pos, class_2680 state) {
        ArrayList<TransferablePipeDataHandler.SaveableTransferablePipeData> dataList = this.transferableDataHandler.getSavedDataList();
        ArrayList<TransferablePipeDataHandler.SaveableTransferablePipeData> usedData = new ArrayList<TransferablePipeDataHandler.SaveableTransferablePipeData>();
        if (dataList.isEmpty()) {
            return;
        }
        for (class_2350 direction : class_156.method_43253((Object[])class_2350.values(), (class_5819)level.method_8409())) {
            AbstractSimpleCopperBlockEntity copperBlockEntity;
            class_2586 blockEntity;
            class_2338 offsetPos;
            if (!this.canTransferDataInDirection(direction, state) || !level.method_22340(offsetPos = pos.method_10093(direction)) || !((blockEntity = level.method_8321(offsetPos)) instanceof AbstractSimpleCopperBlockEntity) || !(copperBlockEntity = (AbstractSimpleCopperBlockEntity)blockEntity).canAcceptTransferableData(this.moveType, direction, state)) continue;
            class_2680 offsetState = level.method_8320(offsetPos);
            for (TransferablePipeDataHandler.SaveableTransferablePipeData data : dataList) {
                if (!data.shouldMove() || data.canOnlyGoThroughOnePipe() && usedData.contains(data) || !data.canMove(level, offsetPos, offsetState, copperBlockEntity)) continue;
                TransferablePipeDataHandler.SaveableTransferablePipeData onMove = data.shouldCopy() ? data.copyOf() : data;
                copperBlockEntity.transferableDataHandler.setTransferablePipeData(data.getID(), onMove);
                onMove.onMove(level, offsetPos, offsetState, copperBlockEntity);
                if (usedData.contains(data)) continue;
                usedData.add(data);
            }
        }
        this.transferableDataHandler.clearAllButNonMoveable();
        usedData.clear();
        this.method_5431();
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(input)) {
            class_1262.method_5429((class_11368)input, this.inventory);
        }
        this.waterCooldown = input.method_71424("WaterCooldown", 0);
        this.electricityCooldown = input.method_71424("electricityCooldown", 0);
        this.canWater = input.method_71433("canWater", false);
        this.canLava = input.method_71433("canLava", false);
        this.canSmoke = input.method_71433("canSmoke", false);
        this.lastFixVersion = input.method_71424("lastFixVersion", 0);
        this.transferableDataHandler.load(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        if (!this.method_54872(output)) {
            class_1262.method_5426((class_11372)output, this.inventory);
        }
        output.method_71465("WaterCooldown", this.waterCooldown);
        output.method_71465("electricityCooldown", this.electricityCooldown);
        output.method_71472("canWater", this.canWater);
        output.method_71472("canLava", this.canLava);
        output.method_71472("canSmoke", this.canSmoke);
        output.method_71465("lastFixVersion", this.lastFixVersion);
        this.transferableDataHandler.save(output);
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> defaultedList) {
        this.inventory = defaultedList;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    @NotNull
    protected class_1703 method_5465(int i, class_1661 playerInventory) {
        return new class_1722(i, playerInventory, (class_1263)this);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public static enum MoveType {
        FROM_PIPE,
        FROM_FITTING;

    }
}

