/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.lunade.copper.block.entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block.entity.CopperPipeBlockEntity;
import net.lunade.copper.registry.TransferablePipeData;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferablePipeDataHandler {
    public ArrayList<SaveableTransferablePipeData> savedData = new ArrayList();
    public ArrayList<class_2960> savedIds = new ArrayList();

    public void load(@NotNull class_11368 input) {
        input.method_71426("transferablePipeData", SaveableTransferablePipeData.CODEC.listOf()).ifPresent(list -> {
            for (SaveableTransferablePipeData saveableTransferablePipeData : list) {
                if (!saveableTransferablePipeData.shouldSave) continue;
                this.addSaveableMoveablePipeNbt(saveableTransferablePipeData);
            }
        });
    }

    public void save(@NotNull class_11372 output) {
        output.method_71468("transferablePipeData", SaveableTransferablePipeData.CODEC.listOf(), this.savedData);
    }

    public void addSaveableMoveablePipeNbt(@NotNull SaveableTransferablePipeData nbt) {
        if (this.savedIds.contains(nbt.getID())) {
            return;
        }
        this.savedData.add(nbt);
        this.savedIds.add(nbt.getID());
    }

    @Nullable
    public SaveableTransferablePipeData getTransferablePipeData(class_2960 id) {
        if (this.savedIds.contains(id) && !this.savedData.isEmpty()) {
            return this.savedData.get(this.savedIds.indexOf(id));
        }
        return null;
    }

    public void removeTransferablePipeData(class_2960 id) {
        if (!this.savedIds.contains(id)) {
            return;
        }
        this.savedData.remove(this.savedIds.indexOf(id));
        this.savedIds.remove(id);
    }

    public void setTransferablePipeData(class_2960 id, SaveableTransferablePipeData nbt) {
        if (this.savedIds.contains(id)) {
            this.savedData.set(this.savedIds.indexOf(id), nbt);
        } else {
            this.savedIds.add(id);
            this.savedData.add(nbt);
        }
    }

    public void clear() {
        this.savedData.clear();
        this.savedIds.clear();
    }

    public void clearAllButNonMoveable() {
        ArrayList<SaveableTransferablePipeData> nbtToRemove = new ArrayList<SaveableTransferablePipeData>();
        this.savedData.clear();
        this.savedIds.clear();
        for (SaveableTransferablePipeData nbt : this.savedData) {
            if (!nbt.shouldMove()) continue;
            nbtToRemove.add(nbt);
        }
        for (SaveableTransferablePipeData nbt : nbtToRemove) {
            if (!this.savedData.contains(nbt)) continue;
            int index = this.savedData.indexOf(nbt);
            this.savedData.remove(index);
            this.savedIds.remove(index);
        }
    }

    public void clearAllButMoveable() {
        ArrayList<SaveableTransferablePipeData> nbtToRemove = new ArrayList<SaveableTransferablePipeData>();
        this.savedData.clear();
        this.savedIds.clear();
        for (SaveableTransferablePipeData nbt : this.savedData) {
            if (nbt.shouldMove()) continue;
            nbtToRemove.add(nbt);
        }
        for (SaveableTransferablePipeData nbt : nbtToRemove) {
            if (!this.savedData.contains(nbt)) continue;
            int index = this.savedData.indexOf(nbt);
            this.savedData.remove(index);
            this.savedIds.remove(index);
        }
    }

    public ArrayList<SaveableTransferablePipeData> getSavedDataList() {
        return this.savedData;
    }

    public static class SaveableTransferablePipeData {
        public static final Codec<SaveableTransferablePipeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("savedID").forGetter(SaveableTransferablePipeData::getSavedID), (App)class_243.field_38277.fieldOf("vec3d").forGetter(SaveableTransferablePipeData::getVec3d), (App)class_243.field_38277.fieldOf("vec3d2").forGetter(SaveableTransferablePipeData::getVec3d2), (App)Codec.STRING.fieldOf("string").forGetter(SaveableTransferablePipeData::getString), (App)Codec.INT.fieldOf("useCount").forGetter(SaveableTransferablePipeData::getUseCount), (App)class_2338.field_25064.fieldOf("blockPos").forGetter(SaveableTransferablePipeData::blockPos), (App)Codec.BOOL.fieldOf("shouldSave").forGetter(SaveableTransferablePipeData::shouldSave), (App)Codec.BOOL.fieldOf("shouldMove").forGetter(SaveableTransferablePipeData::shouldMove), (App)Codec.BOOL.fieldOf("canOnlyBeUsedOnce").forGetter(SaveableTransferablePipeData::canOnlyBeUsedOnce), (App)Codec.BOOL.fieldOf("canOnlyGoThroughOnePipe").forGetter(SaveableTransferablePipeData::canOnlyGoThroughOnePipe), (App)Codec.BOOL.fieldOf("shouldCopy").forGetter(SaveableTransferablePipeData::shouldCopy), (App)class_2960.field_25139.fieldOf("nbtId").forGetter(SaveableTransferablePipeData::getID)).apply((Applicative)instance, SaveableTransferablePipeData::new));
        public class_2960 savedID;
        public class_243 vec3d;
        public class_243 vec3d2;
        public String string;
        public int useCount;
        public class_2338 blockPos;
        public boolean shouldSave;
        public boolean shouldMove;
        public class_1297 foundEntity;
        private boolean canOnlyBeUsedOnce;
        private boolean canOnlyGoThroughOnePipe;
        private boolean shouldCopy;
        private class_2960 ID;

        public SaveableTransferablePipeData(class_2960 id, class_243 vec3d, class_243 vec3d2, String string, int useCount, class_2338 blockPos, boolean shouldSave, boolean shouldMove, boolean canOnlyBeUsedOnce, boolean canOnlyGoThroughOnePipe, boolean shouldCopy, class_2960 nbtId) {
            this.savedID = id;
            this.vec3d = vec3d;
            this.vec3d2 = vec3d2;
            this.string = string;
            this.useCount = useCount;
            this.blockPos = blockPos;
            this.shouldSave = shouldSave;
            this.shouldMove = shouldMove;
            this.canOnlyBeUsedOnce = canOnlyBeUsedOnce;
            this.canOnlyGoThroughOnePipe = canOnlyGoThroughOnePipe;
            this.shouldCopy = shouldCopy;
            this.ID = nbtId;
        }

        public SaveableTransferablePipeData(class_5712 event, class_243 originPos, @Nullable class_5712.class_7397 emitter, class_2338 pipePos) {
            this.savedID = class_7923.field_41171.method_10221((Object)event);
            this.vec3d = originPos;
            this.vec3d2 = originPos;
            this.string = emitter != null && emitter.comp_713() != null ? emitter.comp_713().method_5667().toString() : "noEntity";
            this.blockPos = pipePos;
            this.ID = class_2960.method_43902((String)"simple_copper_pipes", (String)"default");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableTransferablePipeData(class_5712 event, class_243 originPos, @Nullable class_1297 entity, class_2338 pipePos) {
            this.savedID = class_7923.field_41171.method_10221((Object)event);
            this.vec3d = originPos;
            this.vec3d2 = originPos;
            this.string = entity != null ? entity.method_5667().toString() : "noEntity";
            this.blockPos = pipePos;
            this.ID = class_2960.method_43902((String)"simple_copper_pipes", (String)"default");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableTransferablePipeData() {
            this.savedID = class_2960.method_43902((String)"simple_copper_pipes", (String)"none");
            this.vec3d = new class_243(0.0, -64.0, 0.0);
            this.vec3d2 = new class_243(0.0, -64.0, 0.0);
            this.string = "none";
            this.blockPos = new class_2338(0, -64, 0);
            this.ID = class_2960.method_43902((String)"simple_copper_pipes", (String)"none");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableTransferablePipeData withSavedId(class_2960 id) {
            this.setID(id);
            return this;
        }

        public SaveableTransferablePipeData withVec3d(class_243 pos) {
            this.vec3d = pos;
            return this;
        }

        public SaveableTransferablePipeData withVec3d2(class_243 pos) {
            this.vec3d2 = pos;
            return this;
        }

        public SaveableTransferablePipeData withString(String string) {
            this.string = string;
            return this;
        }

        public SaveableTransferablePipeData withUseCount(int count) {
            this.useCount = count;
            return this;
        }

        public SaveableTransferablePipeData withBlockPos(class_2338 pos) {
            this.blockPos = pos;
            return this;
        }

        public SaveableTransferablePipeData withShouldSave(boolean shouldSave) {
            this.shouldSave = shouldSave;
            return this;
        }

        public SaveableTransferablePipeData withShouldMove(boolean shouldMove) {
            this.shouldMove = shouldMove;
            return this;
        }

        public SaveableTransferablePipeData withOnlyUseableOnce(boolean onlyUseableOnce) {
            this.canOnlyBeUsedOnce = onlyUseableOnce;
            return this;
        }

        public SaveableTransferablePipeData withOnlyThroughOnePipe(boolean onlyThroughOnePipe) {
            this.canOnlyGoThroughOnePipe = onlyThroughOnePipe;
            return this;
        }

        public SaveableTransferablePipeData withShouldCopy(boolean shouldCopy) {
            this.shouldCopy = shouldCopy;
            return this;
        }

        public SaveableTransferablePipeData withID(class_2960 id) {
            this.setID(id);
            return this;
        }

        public void dispense(class_3218 world, class_2338 pos, class_2680 state, CopperPipeBlockEntity pipeEntity) {
            TransferablePipeData.Dispsense method = TransferablePipeData.getDispenseBehavior(this.getID());
            if (method != null) {
                method.dispense(this, world, pos, state, pipeEntity);
            }
        }

        public void onMove(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            TransferablePipeData.Move method = TransferablePipeData.getMoveBehavior(this.getID());
            if (method != null) {
                method.onMove(this, world, pos, state, blockEntity);
            }
        }

        public void tick(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            TransferablePipeData.Tick method = TransferablePipeData.getTickBehavior(this.getID());
            if (method != null) {
                method.tick(this, world, pos, state, blockEntity);
            }
        }

        public boolean canMove(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            TransferablePipeData.CanMove method = TransferablePipeData.getCanMovePredicate(this.getID());
            if (method != null) {
                return method.canMove(this, world, pos, state, blockEntity);
            }
            return true;
        }

        @Nullable
        public class_1297 getEntity(class_1937 world) {
            if (!this.string.equals("noEntity")) {
                if (this.foundEntity != null) {
                    if (this.foundEntity.method_5667().toString().equals(this.string)) {
                        return this.foundEntity;
                    }
                    this.foundEntity = null;
                }
                class_238 box = new class_238(this.vec3d2.method_1031(-32.0, -32.0, -32.0), this.vec3d2.method_1031(32.0, 32.0, 32.0));
                List entities = world.method_18467(class_1297.class, box);
                for (class_1297 entity : entities) {
                    if (!entity.method_5667().toString().equals(this.string)) continue;
                    this.foundEntity = entity;
                    this.vec3d2 = entity.method_73189();
                    return entity;
                }
            }
            return null;
        }

        public class_2960 getSavedID() {
            return this.savedID;
        }

        public class_243 getVec3d() {
            return this.vec3d;
        }

        public class_243 getVec3d2() {
            return this.vec3d2;
        }

        public String getString() {
            return this.string;
        }

        public int getUseCount() {
            return this.useCount;
        }

        public class_2338 blockPos() {
            return this.blockPos;
        }

        public boolean shouldSave() {
            return this.shouldSave;
        }

        public boolean shouldMove() {
            return this.shouldMove;
        }

        public boolean canOnlyBeUsedOnce() {
            return this.canOnlyBeUsedOnce;
        }

        public boolean canOnlyGoThroughOnePipe() {
            return this.canOnlyGoThroughOnePipe;
        }

        public boolean shouldCopy() {
            return this.shouldCopy;
        }

        public class_2960 getID() {
            return this.ID;
        }

        public void setID(class_2960 id) {
            this.ID = id;
        }

        public SaveableTransferablePipeData copyOf() {
            return new SaveableTransferablePipeData(this.savedID, this.vec3d, this.vec3d2, this.string, this.useCount, this.blockPos, this.shouldSave, this.shouldMove, this.canOnlyBeUsedOnce, this.canOnlyGoThroughOnePipe, this.shouldCopy, this.ID);
        }
    }
}

