/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.lunade.copper.SimpleCopperPipesConstants;
import net.lunade.copper.block.entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block.entity.CopperFittingBlockEntity;
import net.lunade.copper.block.entity.CopperPipeBlockEntity;
import net.lunade.copper.block.entity.data.TransferablePipeDataHandler;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.networking.packet.SimpleCopperPipesNoteParticlePacket;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5716;
import net.minecraft.class_5745;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TransferablePipeData {
    public static final class_2960 WATER = SimpleCopperPipesConstants.id("water");
    public static final class_2960 LAVA = SimpleCopperPipesConstants.id("lava");
    public static final class_2960 SMOKE = SimpleCopperPipesConstants.id("smoke");
    private static final Map<class_2960, Data> PIPE_DATA = new Object2ObjectLinkedOpenHashMap();

    public static void register(class_2960 id, Dispsense dispense, Move move, Tick tick, CanMove canMove) {
        PIPE_DATA.put(id, new Data(dispense, move, tick, canMove));
    }

    @Nullable
    public static Data getPipeData(class_2960 id) {
        return PIPE_DATA.get(id);
    }

    @Nullable
    public static Dispsense getDispenseBehavior(class_2960 id) {
        Data data = TransferablePipeData.getPipeData(id);
        if (data != null) {
            return data.dispsense();
        }
        return null;
    }

    @Nullable
    public static Move getMoveBehavior(class_2960 id) {
        Data data = TransferablePipeData.getPipeData(id);
        if (data != null) {
            return data.move();
        }
        return null;
    }

    @Nullable
    public static Tick getTickBehavior(class_2960 id) {
        Data data = TransferablePipeData.getPipeData(id);
        if (data != null) {
            return data.tick();
        }
        return null;
    }

    @Nullable
    public static CanMove getCanMovePredicate(class_2960 id) {
        Data data = TransferablePipeData.getPipeData(id);
        if (data != null) {
            return data.canMove();
        }
        return null;
    }

    public static void init() {
        TransferablePipeData.register(class_2960.method_43902((String)"simple_copper_pipes", (String)"default"), (data, level, pos, state, pipe) -> {
            pipe.inputGameEventPos = data.blockPos();
            pipe.gameEventNbtVec3 = data.getVec3d();
            boolean noteBlock = false;
            Optional optionalGameEvent = class_7923.field_41171.method_10223(data.getSavedID());
            if (optionalGameEvent.isPresent() && ((class_6880.class_6883)optionalGameEvent.get()).comp_349() == class_5712.field_38425.comp_349()) {
                pipe.noteBlockCooldown = 40;
                class_2338 originPos = class_2338.method_49638((class_2374)data.getVec3d());
                class_2680 originState = level.method_8320(originPos);
                noteBlock = originState.method_27852(class_2246.field_10179);
                if (noteBlock) {
                    int note = (Integer)originState.method_11654((class_2769)class_2428.field_11324);
                    float pitch = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
                    level.method_8396(null, pos, (class_3414)((class_2766)originState.method_11654((class_2769)class_2428.field_11325)).method_11886().comp_349(), class_3419.field_15247, 3.0f, pitch);
                    SimpleCopperPipesNoteParticlePacket.sendToAll(level, pos, note, (class_2350)level.method_8320(pos).method_11654((class_2769)class_2741.field_12525));
                }
            }
            level.method_33596(data.getEntity((class_1937)level), (class_6880)optionalGameEvent.orElse(class_5712.field_28733), pos);
            if ((noteBlock || pipe.noteBlockCooldown > 0) && data.useCount == 0) {
                level.method_65096((class_2394)new class_5745((class_5716)new class_5707(data.blockPos()), 5), data.getVec3d().field_1352, data.getVec3d().field_1351, data.getVec3d().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                data.useCount = 1;
            }
        }, (data, level, pos, state, blockEntity) -> {}, (data, level, pos, state, blockEntity) -> {
            if (data.foundEntity != null) {
                data.vec3d2 = data.foundEntity.method_73189();
            }
        }, (data, level, pos, state, blockEntity) -> true);
        TransferablePipeData.register(WATER, (data, level, pos, state, pipe) -> {}, (data, level, pos, state, blockEntity) -> {
            if (blockEntity instanceof CopperFittingBlockEntity) {
                data.vec3d = new class_243(11.0, 0.0, 0.0);
            } else if (!blockEntity.canWater && blockEntity.moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE) {
                data.vec3d = data.getVec3d().method_1031(-1.0, 0.0, 0.0);
                if (data.getVec3d().method_10216() <= 0.0) {
                    data.shouldSave = false;
                    data.shouldMove = false;
                }
            }
        }, (data, level, pos, state, blockEntity) -> {}, (data, level, pos, state, blockEntity) -> {
            if (!SimpleCopperPipesConfig.get().carryWater) {
                return false;
            }
            TransferablePipeDataHandler.SaveableTransferablePipeData waterData = blockEntity.transferableDataHandler.getTransferablePipeData(WATER);
            if (waterData != null) {
                return waterData.getVec3d() == null || waterData.getVec3d().method_10216() <= data.getVec3d().method_10216() - 1.0;
            }
            return true;
        });
        TransferablePipeData.register(LAVA, (data, level, pos, state, pipe) -> {}, (data, level, pos, state, blockEntity) -> {
            if (blockEntity.transferableDataHandler.getTransferablePipeData(WATER) == null) {
                if (blockEntity instanceof CopperFittingBlockEntity) {
                    data.vec3d = new class_243(11.0, 0.0, 0.0);
                } else if (!blockEntity.canSmoke && blockEntity.moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE) {
                    data.vec3d = data.getVec3d().method_1031(-1.0, 0.0, 0.0);
                    if (data.getVec3d().method_10216() <= 0.0) {
                        data.shouldSave = false;
                        data.shouldMove = false;
                    }
                }
            } else {
                data.vec3d = class_243.field_1353;
                data.shouldSave = false;
                data.shouldMove = false;
            }
        }, (data, level, pos, state, blockEntity) -> {
            TransferablePipeDataHandler.SaveableTransferablePipeData lavaData = blockEntity.transferableDataHandler.getTransferablePipeData(LAVA);
            TransferablePipeDataHandler.SaveableTransferablePipeData waterData = blockEntity.transferableDataHandler.getTransferablePipeData(WATER);
            TransferablePipeDataHandler.SaveableTransferablePipeData smokeData = blockEntity.transferableDataHandler.getTransferablePipeData(SMOKE);
            if (waterData != null && lavaData != null) {
                lavaData.vec3d = class_243.field_1353;
                lavaData.shouldSave = false;
                lavaData.shouldMove = false;
                waterData.vec3d = class_243.field_1353;
                waterData.shouldSave = false;
                waterData.shouldMove = false;
                if (smokeData == null) {
                    blockEntity.transferableDataHandler.setTransferablePipeData(SMOKE, new TransferablePipeDataHandler.SaveableTransferablePipeData().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withID(SMOKE));
                } else {
                    smokeData.vec3d = new class_243(11.0, 0.0, 0.0);
                }
            }
        }, (data, level, pos, state, blockEntity) -> {
            if (!SimpleCopperPipesConfig.get().carryLava) {
                return false;
            }
            TransferablePipeDataHandler.SaveableTransferablePipeData lavaData = blockEntity.transferableDataHandler.getTransferablePipeData(LAVA);
            if (lavaData != null) {
                return lavaData.getVec3d() == null || lavaData.getVec3d().method_10216() <= data.getVec3d().method_10216() - 1.0;
            }
            return true;
        });
        TransferablePipeData.register(SMOKE, (data, level, pos, state, pipe) -> {}, (data, level, pos, state, blockEntity) -> {
            if (blockEntity instanceof CopperFittingBlockEntity) {
                data.vec3d = new class_243(11.0, 0.0, 0.0);
            } else if (!blockEntity.canSmoke && blockEntity.moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE) {
                data.vec3d = data.getVec3d().method_1031(-1.0, 0.0, 0.0);
                if (data.getVec3d().method_10216() <= 0.0) {
                    data.shouldSave = false;
                    data.shouldMove = false;
                }
            }
        }, (data, level, pos, state, blockEntity) -> {}, (data, level, pos, state, blockEntity) -> {
            if (!SimpleCopperPipesConfig.get().carrySmoke) {
                return false;
            }
            TransferablePipeDataHandler.SaveableTransferablePipeData smokeData = blockEntity.transferableDataHandler.getTransferablePipeData(SMOKE);
            if (smokeData != null) {
                return smokeData.getVec3d() == null || smokeData.getVec3d().method_10216() <= data.getVec3d().method_10216() - 1.0;
            }
            return true;
        });
    }

    public record Data(Dispsense dispsense, Move move, Tick tick, CanMove canMove) {
    }

    @FunctionalInterface
    public static interface Dispsense {
        public void dispense(TransferablePipeDataHandler.SaveableTransferablePipeData var1, class_3218 var2, class_2338 var3, class_2680 var4, CopperPipeBlockEntity var5);
    }

    @FunctionalInterface
    public static interface Move {
        public void onMove(TransferablePipeDataHandler.SaveableTransferablePipeData var1, class_3218 var2, class_2338 var3, class_2680 var4, AbstractSimpleCopperBlockEntity var5);
    }

    @FunctionalInterface
    public static interface Tick {
        public void tick(TransferablePipeDataHandler.SaveableTransferablePipeData var1, class_3218 var2, class_2338 var3, class_2680 var4, AbstractSimpleCopperBlockEntity var5);
    }

    @FunctionalInterface
    public static interface CanMove {
        public boolean canMove(TransferablePipeDataHandler.SaveableTransferablePipeData var1, class_3218 var2, class_2338 var3, class_2680 var4, AbstractSimpleCopperBlockEntity var5);
    }
}

