/*
 * Decompiled with CFR 0.152.
 */
package net.scpo.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.scpo.init.ScpoModMobEffects;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AmnesiaRenderCloudsProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static VertexBuffer cloudBuffer = null;
    private static CloudStatus cloudStatus = null;
    private static double x = 0.0;
    private static double y = 0.0;
    private static double z = 0.0;
    private static float width = 12.0f;
    private static float height = 4.0f;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        poseStack = (PoseStack)params[3];
        projectionMatrix = (Matrix4f)params[7];
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (entity != null) {
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = entity.m_20318_(partialTick);
            AmnesiaRenderCloudsProcedure.execute(null, entity);
            return true;
        }
        return false;
    };

    private static void buildClouds(CloudStatus cloudStatus, double x, double y, double z) {
        if (cloudBuffer == null || AmnesiaRenderCloudsProcedure.cloudStatus != cloudStatus || AmnesiaRenderCloudsProcedure.x != x || AmnesiaRenderCloudsProcedure.y != y || AmnesiaRenderCloudsProcedure.z != z) {
            AmnesiaRenderCloudsProcedure.cloudStatus = cloudStatus;
            AmnesiaRenderCloudsProcedure.x = x;
            AmnesiaRenderCloudsProcedure.y = y;
            AmnesiaRenderCloudsProcedure.z = z;
            Minecraft minecraft = Minecraft.m_91087_();
            RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
            float du = 1.0f / (float)GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            float dv = 1.0f / (float)GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            float dx = (float)Mth.m_14107_((double)x) * du;
            float dz = (float)Mth.m_14107_((double)z) * dv;
            float cloudY = (float)Math.floor(y / (double)height) * height;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
            if (cloudStatus == CloudStatus.FANCY) {
                for (int i = -3; i <= 4; ++i) {
                    for (int j = -3; j <= 4; ++j) {
                        int k;
                        float cloudX = (float)i * 8.0f;
                        float cloudZ = (float)j * 8.0f;
                        if (cloudY > -height - 1.0f) {
                            bufferBuilder.m_5483_((double)cloudX, (double)cloudY, (double)(cloudZ + 8.0f)).m_7421_(cloudX * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.7f, 0.7f, 0.7f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)cloudY, (double)(cloudZ + 8.0f)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.7f, 0.7f, 0.7f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)cloudY, (double)cloudZ).m_7421_((cloudX + 8.0f) * du + dx, cloudZ * dv + dz).m_85950_(0.7f, 0.7f, 0.7f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)cloudX, (double)cloudY, (double)cloudZ).m_7421_(cloudX * du + dx, cloudZ * dv + dz).m_85950_(0.7f, 0.7f, 0.7f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        }
                        if (cloudY <= height + 1.0f) {
                            bufferBuilder.m_5483_((double)cloudX, (double)(cloudY + height - 9.765625E-4f), (double)(cloudZ + 8.0f)).m_7421_(cloudX * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)(cloudY + height - 9.765625E-4f), (double)(cloudZ + 8.0f)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)(cloudY + height - 9.765625E-4f), (double)cloudZ).m_7421_((cloudX + 8.0f) * du + dx, cloudZ * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)cloudX, (double)(cloudY + height - 9.765625E-4f), (double)cloudZ).m_7421_(cloudX * du + dx, cloudZ * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        }
                        if (i > -1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.m_5483_((double)(cloudX + (float)k), (double)cloudY, (double)(cloudZ + 8.0f)).m_7421_((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k), (double)(cloudY + height), (double)(cloudZ + 8.0f)).m_7421_((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k), (double)(cloudY + height), (double)cloudZ).m_7421_((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k), (double)cloudY, (double)cloudZ).m_7421_((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            }
                        }
                        if (i <= 1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.m_5483_((double)(cloudX + (float)k + 1.0f - 9.765625E-4f), (double)cloudY, (double)(cloudZ + 8.0f)).m_7421_((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k + 1.0f - 9.765625E-4f), (double)(cloudY + height), (double)(cloudZ + 8.0f)).m_7421_((cloudX + (float)k + 0.5f) * du + dx, (cloudZ + 8.0f) * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k + 1.0f - 9.765625E-4f), (double)(cloudY + height), (double)cloudZ).m_7421_((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + (float)k + 1.0f - 9.765625E-4f), (double)cloudY, (double)cloudZ).m_7421_((cloudX + (float)k + 0.5f) * du + dx, cloudZ * dv + dz).m_85950_(0.9f, 0.9f, 0.9f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            }
                        }
                        if (j > -1) {
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.m_5483_((double)cloudX, (double)(cloudY + height), (double)(cloudZ + (float)k)).m_7421_(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)(cloudY + height), (double)(cloudZ + (float)k)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)cloudY, (double)(cloudZ + (float)k)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                bufferBuilder.m_5483_((double)cloudX, (double)cloudY, (double)(cloudZ + (float)k)).m_7421_(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            }
                        }
                        if (j > 1) continue;
                        for (k = 0; k < 8; ++k) {
                            bufferBuilder.m_5483_((double)cloudX, (double)(cloudY + height), (double)(cloudZ + (float)k + 1.0f - 9.765625E-4f)).m_7421_(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)(cloudY + height), (double)(cloudZ + (float)k + 1.0f - 9.765625E-4f)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(cloudX + 8.0f), (double)cloudY, (double)(cloudZ + (float)k + 1.0f - 9.765625E-4f)).m_7421_((cloudX + 8.0f) * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)cloudX, (double)cloudY, (double)(cloudZ + (float)k + 1.0f - 9.765625E-4f)).m_7421_(cloudX * du + dx, (cloudZ + (float)k + 0.5f) * dv + dz).m_85950_(0.8f, 0.8f, 0.8f, 1.0f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        }
                    }
                }
            } else if (cloudStatus == CloudStatus.FAST) {
                for (int i = -32; i < 32; i += 32) {
                    for (int j = -32; j < 32; j += 32) {
                        bufferBuilder.m_5483_((double)i, (double)cloudY, (double)(j + 32)).m_7421_((float)i * du + dx, (float)(j + 32) * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(i + 32), (double)cloudY, (double)(j + 32)).m_7421_((float)(i + 32) * du + dx, (float)(j + 32) * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(i + 32), (double)cloudY, (double)j).m_7421_((float)(i + 32) * du + dx, (float)j * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)i, (double)cloudY, (double)j).m_7421_((float)i * du + dx, (float)j * dv + dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                }
            }
            if (cloudBuffer != null) {
                cloudBuffer.close();
            }
            cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            cloudBuffer.m_85921_();
            cloudBuffer.m_231221_(bufferBuilder.m_231175_());
        } else {
            cloudBuffer.m_85921_();
        }
    }

    public static void renderClouds(CloudStatus cloudStatus, double altitude, double vx, double vz, int color) {
        if (cloudStatus == CloudStatus.OFF) {
            return;
        }
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
        int tw = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) << 3;
        int th = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) << 3;
        if (tw > 0 && th > 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
            double factor = (double)((float)ticks + partialTick) * 0.03;
            double x = (pos.m_7096_() + factor * -vx) / (double)width;
            double y = altitude + 0.33 - pos.m_7098_();
            double z = (pos.m_7094_() + factor * -vz) / (double)width + 0.33;
            x -= (double)(Mth.m_14107_((double)(x / (double)tw)) * tw);
            z -= (double)(Mth.m_14107_((double)(z / (double)th)) * th);
            float dx = (float)(x - (double)Mth.m_14107_((double)x));
            float dy = (float)(y / (double)height - (double)Mth.m_14107_((double)(y / (double)height))) * height;
            float dz = (float)(z - (double)Mth.m_14107_((double)z));
            AmnesiaRenderCloudsProcedure.buildClouds(cloudStatus, x, y, z);
            poseStack.m_85836_();
            poseStack.m_85841_(width, 1.0f, width);
            poseStack.m_252880_(-dx, dy, -dz);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            ShaderInstance shaderInstance = GameRenderer.m_172838_();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            if (cloudStatus == CloudStatus.FANCY) {
                RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                cloudBuffer.m_253207_(matrix4f, projectionMatrix, shaderInstance);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                cloudBuffer.m_253207_(matrix4f, projectionMatrix, shaderInstance);
            } else if (cloudStatus == CloudStatus.FAST) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                cloudBuffer.m_253207_(matrix4f, projectionMatrix, shaderInstance);
            }
            VertexBuffer.m_85931_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void cloudsSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_CLOUDS").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(Entity entity) {
        AmnesiaRenderCloudsProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        LivingEntity _livEnt0;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && (_livEnt0 = (LivingEntity)entity).m_21023_((MobEffect)ScpoModMobEffects.AMNESIA.get())) {
            AmnesiaRenderCloudsProcedure.renderClouds(Minecraft.m_91087_().f_91066_.m_92174_(), -192.0, -1.0, 0.0, 0xFFFFFF);
        }
    }
}

