/*
 * Decompiled with CFR 0.152.
 */
package com.axperty.cratedelight.event;

import com.axperty.cratedelight.registry.BlockRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="cratedelight")
@ParametersAreNonnullByDefault
public class VillagerEvents {
    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        ResourceKey profession = event.getType();
        if (profession.equals(VillagerProfession.FARMER)) {
            ((List)trades.get(1)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)BlockRegistry.CARROT_CRATE.get(), 3, 1, 2));
            ((List)trades.get(1)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)BlockRegistry.POTATO_CRATE.get(), 3, 1, 2));
            ((List)trades.get(1)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)BlockRegistry.APPLE_CRATE.get(), 3, 1, 2));
        }
    }

    public static BasicItemListing emeraldForItemsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.EMERALD, 9), maxTrades, xp, 0.05f);
    }

    public static BasicItemListing itemForEmeraldTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(9, new ItemStack(item, count), maxTrades, xp, 0.05f);
    }
}

