/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.effecthud.element;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.impl.controller.TickBoxControllerBuilderImpl;
import dev.wooferz.effecthud.StatusEffectHUDClient;
import dev.wooferz.effecthud.config.EffectHudConfig;
import dev.wooferz.hudlib.HudAnchor;
import dev.wooferz.hudlib.hud.HUDConfig;
import dev.wooferz.hudlib.hud.HUDElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class EffectHudElement
extends HUDElement {
    public EffectHudConfig config = new EffectHudConfig();
    boolean editorOpen = false;

    public EffectHudElement() {
        super("Status Effect HUD", 10, 0, 120, 29, 1, "status-effect-hud", "effect-hud", HudAnchor.HorizontalAnchor.LEFT, HudAnchor.VerticalAnchor.MIDDLE);
    }

    public Integer getHeight() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null) {
            Collection effects = player.method_6026();
            if (effects.isEmpty()) {
                return 29;
            }
            return effects.size() * 25 + 4;
        }
        return 40;
    }

    public void render(int x, int y, int width, int height, class_332 drawContext, float v) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        StatusEffectHUDClient.disableVanillaGui = this.config.disableVanillaHud;
        if (player != null) {
            int color = this.config.color.getAlpha() << 24 | this.config.color.getRed() << 16 | this.config.color.getGreen() << 8 | this.config.color.getBlue();
            int bgColor = this.config.bgColor.getAlpha() << 24 | this.config.bgColor.getRed() << 16 | this.config.bgColor.getGreen() << 8 | this.config.bgColor.getBlue();
            int timeColor = this.config.timeColor.getAlpha() << 24 | this.config.timeColor.getRed() << 16 | this.config.timeColor.getGreen() << 8 | this.config.timeColor.getBlue();
            int i = 0;
            ArrayList<class_1293> effects = player.method_6026();
            if (effects.isEmpty()) {
                if (this.editorOpen) {
                    effects = new ArrayList<class_1293>();
                    effects.add(new class_1293(class_1294.field_5910, 120, 1));
                } else {
                    return;
                }
            }
            int rHeight = effects.size() * 25 + 4;
            drawContext.method_25294(x, y, x + width, y + rHeight, bgColor);
            for (class_1293 effect : effects) {
                class_1291 effectType = (class_1291)effect.method_5579().comp_349();
                String registryName = String.valueOf(class_7923.field_41174.method_10221((Object)effectType)).replaceFirst("^minecraft:", "");
                class_2960 texture = class_2960.method_60655((String)"minecraft", (String)("textures/mob_effect/" + registryName + ".png"));
                String amplifier = " " + (effect.method_5578() + 1);
                drawContext.method_51433(mc.field_1772, class_2561.method_43471((String)effectType.method_5567()).getString() + amplifier, 2 + x + 19, 5 + y + i * 25, color, true);
                if (effect.method_5584() != -1) {
                    drawContext.method_51433(mc.field_1772, String.format("%02d:%02d:%02d", effect.method_5584() / 20 / 60 / 60, effect.method_5584() / 20 / 60 % 60, effect.method_5584() / 20 % 60), 2 + x + 19, 17 + y + i * 25, timeColor, true);
                } else {
                    drawContext.method_51433(mc.field_1772, "\u221e", 2 + x + 19, 17 + y + i * 25, timeColor, true);
                }
                drawContext.method_25290(class_1921::method_62277, texture, 2 + x, 7 + y + i * 25, 0.0f, 0.0f, 16, 16, 16, 16);
                ++i;
            }
        }
    }

    public void editorOpened() {
        this.editorOpen = true;
    }

    public void editorClosed() {
        this.editorOpen = false;
    }

    public Class<?> getConfigType() {
        return EffectHudConfig.class;
    }

    public HUDConfig getConfig() {
        return this.config;
    }

    public void setConfig(HUDConfig config) {
        if (config != null && config instanceof EffectHudConfig) {
            this.config = (EffectHudConfig)config;
            StatusEffectHUDClient.disableVanillaGui = this.config.disableVanillaHud;
        }
    }

    public OptionGroup generateConfig() {
        OptionGroup optionGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)this.displayName)).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Disable Vanilla Effect HUD")).binding((Object)false, () -> this.config.disableVanillaHud, value -> {
            this.config.disableVanillaHud = value;
        }).controller(TickBoxControllerBuilderImpl::new).build()).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"This will work even when Status Effect HUD is disabled.")})).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Text Color")).binding((Object)Color.WHITE, () -> this.config.color, newColor -> {
            this.config.color = newColor;
        }).controller(ColorControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Time Color")).binding((Object)Color.GRAY, () -> this.config.timeColor, newColor -> {
            this.config.timeColor = newColor;
        }).controller(ColorControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Background Color")).binding((Object)new Color(-1728053248, true), () -> this.config.bgColor, newColor -> {
            this.config.bgColor = newColor;
        }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true)).build()).build();
        return optionGroup;
    }
}

