/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.api;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.SmartSpawnerAPI;
import github.nighter.smartspawner.api.data.SpawnerDataDTO;
import github.nighter.smartspawner.api.data.SpawnerDataModifier;
import github.nighter.smartspawner.api.impl.SpawnerDataModifierImpl;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SmartSpawnerAPIImpl
implements SmartSpawnerAPI {
    private final SmartSpawner plugin;
    private final SpawnerItemFactory itemFactory;

    public SmartSpawnerAPIImpl(SmartSpawner plugin) {
        this.plugin = plugin;
        this.itemFactory = new SpawnerItemFactory(plugin);
    }

    @Override
    public ItemStack createSpawnerItem(EntityType entityType) {
        return this.itemFactory.createSmartSpawnerItem(entityType);
    }

    @Override
    public ItemStack createSpawnerItem(EntityType entityType, int amount) {
        return this.itemFactory.createSmartSpawnerItem(entityType, amount);
    }

    @Override
    public ItemStack createVanillaSpawnerItem(EntityType entityType) {
        return this.itemFactory.createVanillaSpawnerItem(entityType);
    }

    @Override
    public ItemStack createVanillaSpawnerItem(EntityType entityType, int amount) {
        return this.itemFactory.createVanillaSpawnerItem(entityType, amount);
    }

    @Override
    public ItemStack createItemSpawnerItem(Material itemMaterial) {
        return this.itemFactory.createItemSpawnerItem(itemMaterial);
    }

    @Override
    public ItemStack createItemSpawnerItem(Material itemMaterial, int amount) {
        return this.itemFactory.createItemSpawnerItem(itemMaterial, amount);
    }

    @Override
    public boolean isSmartSpawner(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return !this.isVanillaSpawner(item) && !this.isItemSpawner(item);
    }

    @Override
    public boolean isVanillaSpawner(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "vanilla_spawner"), PersistentDataType.BOOLEAN);
    }

    @Override
    public boolean isItemSpawner(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "item_spawner_material"), PersistentDataType.STRING);
    }

    @Override
    public EntityType getSpawnerEntityType(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof BlockStateMeta)) {
            return null;
        }
        BlockStateMeta blockMeta = (BlockStateMeta)meta;
        BlockState blockState = blockMeta.getBlockState();
        if (!(blockState instanceof CreatureSpawner)) {
            return null;
        }
        CreatureSpawner cs = (CreatureSpawner)blockState;
        return cs.getSpawnedType();
    }

    @Override
    public Material getItemSpawnerMaterial(ItemStack item) {
        if (!this.isItemSpawner(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String materialName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "item_spawner_material"), PersistentDataType.STRING);
        if (materialName == null) {
            return null;
        }
        try {
            return Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public SpawnerDataDTO getSpawnerByLocation(Location location) {
        if (location == null) {
            return null;
        }
        SpawnerData spawnerData = this.plugin.getSpawnerManager().getSpawnerByLocation(location);
        return spawnerData != null ? this.convertToDTO(spawnerData) : null;
    }

    @Override
    public SpawnerDataDTO getSpawnerById(String spawnerId) {
        if (spawnerId == null) {
            return null;
        }
        SpawnerData spawnerData = this.plugin.getSpawnerManager().getSpawnerById(spawnerId);
        return spawnerData != null ? this.convertToDTO(spawnerData) : null;
    }

    @Override
    public List<SpawnerDataDTO> getAllSpawners() {
        return this.plugin.getSpawnerManager().getAllSpawners().stream().map(this::convertToDTO).collect(Collectors.toList());
    }

    @Override
    public SpawnerDataModifier getSpawnerModifier(String spawnerId) {
        if (spawnerId == null) {
            return null;
        }
        SpawnerData spawnerData = this.plugin.getSpawnerManager().getSpawnerById(spawnerId);
        return spawnerData != null ? new SpawnerDataModifierImpl(spawnerData) : null;
    }

    private SpawnerDataDTO convertToDTO(SpawnerData spawnerData) {
        return new SpawnerDataDTO(spawnerData.getSpawnerId(), spawnerData.getSpawnerLocation(), spawnerData.getEntityType(), spawnerData.getSpawnedItemMaterial(), spawnerData.getStackSize(), spawnerData.getMaxStackSize(), spawnerData.getBaseMaxStoragePages(), spawnerData.getBaseMinMobs(), spawnerData.getBaseMaxMobs(), spawnerData.getBaseMaxStoredExp(), spawnerData.getSpawnDelay());
    }
}

