/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.hologram;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.ColorUtil;
import github.nighter.smartspawner.language.LanguageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class SpawnerHologram {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final AtomicReference<TextDisplay> textDisplay = new AtomicReference<Object>(null);
    private final Location spawnerLocation;
    private int stackSize;
    private EntityType entityType;
    private int currentExp;
    private int maxExp;
    private int currentItems;
    private int maxSlots;
    private static final String HOLOGRAM_IDENTIFIER = "SmartSpawner-Holo";
    private final String uniqueIdentifier;
    private static final Vector3f SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final AxisAngle4f ROTATION = new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f);

    public SpawnerHologram(Location location) {
        this.plugin = SmartSpawner.getInstance();
        this.spawnerLocation = location;
        this.languageManager = this.plugin.getLanguageManager();
        this.uniqueIdentifier = this.generateUniqueIdentifier(location);
    }

    private String generateUniqueIdentifier(Location location) {
        return "SmartSpawner-Holo-" + location.getWorld().getName() + "-" + location.getBlockX() + "-" + location.getBlockY() + "-" + location.getBlockZ();
    }

    public void createHologram() {
        if (this.spawnerLocation == null || this.spawnerLocation.getWorld() == null) {
            return;
        }
        this.cleanupExistingHologram();
        double offsetX = this.plugin.getConfig().getDouble("hologram.offset_x", 0.5);
        double offsetY = this.plugin.getConfig().getDouble("hologram.offset_y", 0.5);
        double offsetZ = this.plugin.getConfig().getDouble("hologram.offset_z", 0.5);
        Location holoLoc = this.spawnerLocation.clone().add(offsetX, offsetY, offsetZ);
        Scheduler.runLocationTask(holoLoc, () -> {
            try {
                TextDisplay display = (TextDisplay)this.spawnerLocation.getWorld().spawn(holoLoc, TextDisplay.class, td -> {
                    TextDisplay.TextAlignment alignment;
                    td.setBillboard(Display.Billboard.CENTER);
                    String alignmentStr = this.plugin.getConfig().getString("hologram.alignment", "CENTER");
                    try {
                        alignment = TextDisplay.TextAlignment.valueOf((String)alignmentStr.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        alignment = TextDisplay.TextAlignment.CENTER;
                        this.plugin.getLogger().warning("Invalid hologram alignment in config: " + alignmentStr + ". Using CENTER as default.");
                    }
                    td.setAlignment(alignment);
                    td.setViewRange(16.0f);
                    td.setShadowed(this.plugin.getConfig().getBoolean("hologram.shadowed_text", true));
                    td.setDefaultBackground(false);
                    td.setTransformation(new Transformation(TRANSLATION, ROTATION, SCALE, ROTATION));
                    td.setSeeThrough(this.plugin.getConfig().getBoolean("hologram.see_through", false));
                    td.setCustomName(this.uniqueIdentifier);
                    td.setCustomNameVisible(false);
                    td.setPersistent(false);
                });
                this.textDisplay.set(display);
                this.updateText();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error creating hologram: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void updateText() {
        TextDisplay display = this.textDisplay.get();
        if (display == null || this.entityType == null) {
            return;
        }
        String entityTypeName = this.languageManager.getFormattedMobName(this.entityType);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("entity", entityTypeName);
        replacements.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", this.languageManager.getSmallCaps(entityTypeName));
        replacements.put("stack_size", String.valueOf(this.stackSize));
        replacements.put("current_exp", this.languageManager.formatNumber(this.currentExp));
        replacements.put("max_exp", this.languageManager.formatNumber(this.maxExp));
        replacements.put("used_slots", this.languageManager.formatNumber(this.currentItems));
        replacements.put("max_slots", this.languageManager.formatNumber(this.maxSlots));
        double percentStorageDecimal = this.maxSlots > 0 ? (double)this.currentItems / (double)this.maxSlots * 100.0 : 0.0;
        String formattedPercentStorage = String.format("%.1f", percentStorageDecimal);
        int percentStorageRounded = (int)Math.round(percentStorageDecimal);
        replacements.put("percent_storage_decimal", formattedPercentStorage);
        replacements.put("percent_storage_rounded", String.valueOf(percentStorageRounded));
        double percentExpDecimal = this.maxExp > 0 ? (double)this.currentExp / (double)this.maxExp * 100.0 : 0.0;
        String formattedPercentExp = String.format("%.1f", percentExpDecimal);
        int percentExpRounded = (int)Math.round(percentExpDecimal);
        replacements.put("percent_exp_decimal", formattedPercentExp);
        replacements.put("percent_exp_rounded", String.valueOf(percentExpRounded));
        String hologramText = this.languageManager.getHologramText();
        for (Map.Entry entry : replacements.entrySet()) {
            hologramText = hologramText.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
        }
        String finalText = ColorUtil.translateHexColorCodes(hologramText);
        Scheduler.runEntityTask((Entity)display, () -> {
            if (display.isValid()) {
                display.setText(finalText);
            }
        });
    }

    public void updateData(int stackSize, EntityType entityType, int currentExp, int maxExp, int currentItems, int maxSlots) {
        this.stackSize = stackSize;
        this.entityType = entityType;
        this.currentExp = currentExp;
        this.maxExp = maxExp;
        this.currentItems = currentItems;
        this.maxSlots = maxSlots;
        TextDisplay display = this.textDisplay.get();
        if (display == null) {
            this.createHologram();
        } else {
            Scheduler.runEntityTask((Entity)display, () -> {
                if (!display.isValid()) {
                    this.textDisplay.set(null);
                    this.createHologram();
                } else {
                    this.updateText();
                }
            });
        }
    }

    public void remove() {
        TextDisplay display = this.textDisplay.get();
        if (display != null) {
            Scheduler.runEntityTask((Entity)display, () -> {
                if (display.isValid()) {
                    display.remove();
                }
            });
            this.textDisplay.set(null);
        }
        this.cleanupExistingHologram();
    }

    public void cleanupExistingHologram() {
        if (this.spawnerLocation == null || this.spawnerLocation.getWorld() == null) {
            return;
        }
        TextDisplay display = this.textDisplay.get();
        if (display != null) {
            Scheduler.runEntityTask((Entity)display, () -> {
                if (display.isValid()) {
                    display.remove();
                }
            });
            this.textDisplay.set(null);
        }
        Scheduler.runLocationTask(this.spawnerLocation, () -> {
            double searchRadius = 2.0;
            this.spawnerLocation.getWorld().getNearbyEntities(this.spawnerLocation, searchRadius, searchRadius, searchRadius).stream().filter(entity -> entity instanceof TextDisplay && entity.getCustomName() != null).filter(entity -> entity.getCustomName().equals(this.uniqueIdentifier)).forEach(entity -> Scheduler.runEntityTask(entity, () -> ((Entity)entity).remove()));
        });
    }
}

