/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.reload;

import com.mojang.brigadier.context.CommandContext;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.BaseSubCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ReloadSubCommand
extends BaseSubCommand {
    public ReloadSubCommand(SmartSpawner plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public String getPermission() {
        return "smartspawner.command.reload";
    }

    @Override
    public String getDescription() {
        return "Reload the plugin configuration and data";
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.reloadAll(sender);
        return 1;
    }

    private void reloadAll(CommandSender sender) {
        try {
            this.plugin.getMessageService().sendMessage(sender, "reload_command_start");
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.logCacheStats();
            }
            this.plugin.getSpawnerItemFactory().clearAllCaches();
            this.plugin.getMessageService().clearKeyExistsCache();
            this.plugin.reloadConfig();
            this.plugin.setUpHopperHandler();
            this.plugin.getItemPriceManager().reload();
            this.plugin.getSpawnerSettingsConfig().reload();
            this.plugin.getSpawnerManager().reloadSpawnerDropsAndConfigs();
            this.plugin.getLanguageManager().reloadLanguages();
            this.plugin.getSpawnerMenuUI().loadConfig();
            this.plugin.getSpawnerGuiViewManager().recheckTimerPlaceholders();
            this.plugin.getSpawnerItemFactory().reload();
            this.plugin.getSpawnerManager().reloadAllHolograms();
            this.plugin.reload();
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.logCacheStats();
            }
            this.plugin.getMessageService().sendMessage(sender, "reload_command_success");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during reload: " + e.getMessage());
            e.printStackTrace();
            this.plugin.getMessageService().sendMessage(sender, "reload_command_error");
        }
    }

    private void logCacheStats() {
        Map<String, Object> stats = this.plugin.getLanguageManager().getCacheStats();
        this.plugin.getLogger().info("Language cache statistics:");
        for (Map.Entry<String, Object> entry : stats.entrySet()) {
            this.plugin.getLogger().info("  " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
    }
}

