/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.economy.shops.providers.economyshopgui;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.shops.providers.ShopProvider;
import lombok.Generated;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.objects.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EconomyShopGUIProvider
implements ShopProvider {
    private final SmartSpawner plugin;
    private static final String[] PLUGIN_NAMES = new String[]{"EconomyShopGUI", "EconomyShopGUI-Premium"};

    @Override
    public String getPluginName() {
        if (this.plugin.getServer().getPluginManager().getPlugin("EconomyShopGUI-Premium") != null) {
            return "EconomyShopGUI-Premium";
        }
        return "EconomyShopGUI";
    }

    @Override
    public boolean isAvailable() {
        try {
            Plugin economyShopGUI = null;
            for (String pluginName : PLUGIN_NAMES) {
                economyShopGUI = Bukkit.getPluginManager().getPlugin(pluginName);
                if (economyShopGUI == null) continue;
                this.plugin.debug("Found " + pluginName + " plugin");
                break;
            }
            if (economyShopGUI != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error initializing EconomyShopGUI integration: " + e.getMessage());
        }
        return false;
    }

    @Override
    public double getSellPrice(Material material) {
        try {
            ItemStack item = new ItemStack(material);
            ShopItem shopItem = EconomyShopGUIHook.getShopItem((ItemStack)item);
            if (shopItem == null) {
                return 0.0;
            }
            Double sellPrice = EconomyShopGUIHook.getItemSellPrice((ShopItem)shopItem, (ItemStack)item);
            return sellPrice != null ? sellPrice : 0.0;
        }
        catch (Exception e) {
            this.plugin.debug("Error getting sell price for " + String.valueOf(material) + " from EconomyShopGUI: " + e.getMessage());
            return 0.0;
        }
    }

    @Generated
    public EconomyShopGUIProvider(SmartSpawner plugin) {
        this.plugin = plugin;
    }
}

