/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.protections.api;

import com.google.common.eventbus.Subscribe;
import com.plotsquared.core.events.PlotDeleteEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerPlaceEvent;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class PlotSquared
implements Listener {
    private HashMap<Plot, HashSet<org.bukkit.Location>> spawnersData = new HashMap();

    public static boolean canInteract(@NotNull Player player, @NotNull org.bukkit.Location location) {
        Plot plot = Plot.getPlot((Location)Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
        if (plot == null) {
            return true;
        }
        return plot.isAdded(player.getUniqueId());
    }

    @Subscribe
    public void onPlotDelete(PlotDeleteEvent event) {
        if (event.getEventResult() == Result.DENY) {
            return;
        }
        Plot plot = event.getPlot();
        if (!this.spawnersData.containsKey(plot)) {
            return;
        }
        for (org.bukkit.Location loc : this.spawnersData.get(plot)) {
            if (loc == null) {
                return;
            }
            SpawnerData spawner = SmartSpawner.getInstance().getSpawnerManager().getSpawnerByLocation(loc);
            if (spawner == null) continue;
            SmartSpawner.getInstance().getSpawnerManager().removeGhostSpawner(spawner.getSpawnerId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onSpawnerPlace(SpawnerPlaceEvent e) {
        org.bukkit.Location location = e.getLocation();
        if (location == null) {
            return;
        }
        Plot plot = Plot.getPlot((Location)Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
        if (plot == null) {
            return;
        }
        if (!this.spawnersData.containsKey(plot)) {
            this.spawnersData.put(plot, new HashSet());
        }
        this.spawnersData.get(plot).add(location);
    }
}

