/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.logging.discord;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.logging.SpawnerEventType;
import github.nighter.smartspawner.logging.SpawnerLogEntry;
import github.nighter.smartspawner.logging.discord.DiscordEmbed;
import github.nighter.smartspawner.logging.discord.DiscordWebhookConfig;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;

public class DiscordEmbedBuilder {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());

    public static DiscordEmbed buildEmbed(SpawnerLogEntry entry, DiscordWebhookConfig config, SmartSpawner plugin) {
        DiscordEmbed embed = new DiscordEmbed();
        embed.setColor(config.getColorForEvent(entry.getEventType()));
        Map<String, String> placeholders = DiscordEmbedBuilder.buildPlaceholders(entry);
        String eventIcon = DiscordEmbedBuilder.getEventIcon(entry.getEventType());
        String title = eventIcon + " " + DiscordEmbedBuilder.replacePlaceholders(config.getEmbedTitle(), placeholders);
        embed.setTitle(title);
        String description = DiscordEmbedBuilder.buildCompactDescription(entry, placeholders, config);
        embed.setDescription(description);
        String footer = DiscordEmbedBuilder.replacePlaceholders(config.getEmbedFooter(), placeholders);
        embed.setFooter(footer, "https://images.minecraft-heads.com/render2d/head/2e/2eaa2d8b7e9a098ebd33fcb6cf1120f4.webp");
        embed.setTimestamp(Instant.ofEpochMilli(System.currentTimeMillis()));
        if (config.isShowPlayerHead() && entry.getPlayerName() != null) {
            embed.setThumbnail(DiscordEmbedBuilder.getPlayerAvatarUrl(entry.getPlayerName()));
        }
        DiscordEmbedBuilder.addCompactFields(embed, entry);
        for (DiscordWebhookConfig.EmbedField customField : config.getCustomFields()) {
            String fieldName = DiscordEmbedBuilder.replacePlaceholders(customField.getName(), placeholders);
            String fieldValue = DiscordEmbedBuilder.replacePlaceholders(customField.getValue(), placeholders);
            embed.addField(fieldName, fieldValue, customField.isInline());
        }
        return embed;
    }

    private static String buildCompactDescription(SpawnerLogEntry entry, Map<String, String> placeholders, DiscordWebhookConfig config) {
        StringBuilder desc = new StringBuilder();
        String mainDesc = DiscordEmbedBuilder.replacePlaceholders(config.getEmbedDescription(), placeholders);
        desc.append(mainDesc);
        desc.append("\n\n");
        if (entry.getPlayerName() != null) {
            desc.append("\ud83d\udc64 `").append(entry.getPlayerName()).append("`");
        }
        if (entry.getLocation() != null) {
            Location loc = entry.getLocation();
            if (entry.getPlayerName() != null) {
                desc.append(" \u2022 ");
            }
            desc.append("\ud83d\udccd `").append(loc.getWorld().getName()).append(" (").append(loc.getBlockX()).append(", ").append(loc.getBlockY()).append(", ").append(loc.getBlockZ()).append(")`");
        }
        if (entry.getEntityType() != null) {
            desc.append("\n\ud83d\udc3e `").append(DiscordEmbedBuilder.formatEntityName(entry.getEntityType().name())).append("`");
        }
        return desc.toString();
    }

    private static void addCompactFields(DiscordEmbed embed, SpawnerLogEntry entry) {
        Map<String, Object> metadata = entry.getMetadata();
        if (metadata.isEmpty()) {
            return;
        }
        int fieldCount = 0;
        int maxFields = 6;
        for (Map.Entry<String, Object> metaEntry : metadata.entrySet()) {
            if (fieldCount >= maxFields) break;
            String key = DiscordEmbedBuilder.formatFieldName(metaEntry.getKey());
            String icon = DiscordEmbedBuilder.getFieldIcon(metaEntry.getKey());
            Object value = metaEntry.getValue();
            String formattedValue = DiscordEmbedBuilder.formatCompactValue(value);
            embed.addField(icon + " " + key, formattedValue, true);
            ++fieldCount;
        }
    }

    private static String formatCompactValue(Object value) {
        if (value == null) {
            return "`N/A`";
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Double || value instanceof Float) {
                return "`" + String.format("%.2f", num.doubleValue()) + "`";
            }
            return "`" + num.toString() + "`";
        }
        Object str = String.valueOf(value);
        if (((String)str).length() > 50) {
            str = ((String)str).substring(0, 47) + "...";
        }
        return "`" + (String)str + "`";
    }

    private static Map<String, String> buildPlaceholders(SpawnerLogEntry entry) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("description", entry.getEventType().getDescription());
        placeholders.put("event_type", entry.getEventType().name());
        placeholders.put("time", FORMATTER.format(Instant.ofEpochMilli(System.currentTimeMillis())));
        if (entry.getPlayerName() != null) {
            placeholders.put("player", entry.getPlayerName());
        }
        if (entry.getPlayerUuid() != null) {
            placeholders.put("player_uuid", entry.getPlayerUuid().toString());
        }
        if (entry.getLocation() != null) {
            Location loc = entry.getLocation();
            placeholders.put("world", loc.getWorld().getName());
            placeholders.put("x", String.valueOf(loc.getBlockX()));
            placeholders.put("y", String.valueOf(loc.getBlockY()));
            placeholders.put("z", String.valueOf(loc.getBlockZ()));
            placeholders.put("location", String.format("%s (%d, %d, %d)", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }
        if (entry.getEntityType() != null) {
            placeholders.put("entity", DiscordEmbedBuilder.formatEntityName(entry.getEntityType().name()));
        }
        for (Map.Entry<String, Object> metaEntry : entry.getMetadata().entrySet()) {
            placeholders.put(metaEntry.getKey(), String.valueOf(metaEntry.getValue()));
        }
        return placeholders;
    }

    private static String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null) {
            return "";
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private static String getPlayerAvatarUrl(String playerName) {
        return "https://mc-heads.net/avatar/" + playerName + "/64.png";
    }

    private static String formatFieldName(String fieldName) {
        String[] words = fieldName.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                result.append(word.substring(1).toLowerCase());
            }
            result.append(" ");
        }
        return result.toString().trim();
    }

    private static String formatEntityName(String entityType) {
        if (entityType == null || entityType.isEmpty()) {
            return entityType;
        }
        String[] words = entityType.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                result.append(word.substring(1));
            }
            result.append(" ");
        }
        return result.toString().trim();
    }

    private static String getFieldIcon(String fieldName) {
        String lower = fieldName.toLowerCase();
        if (lower.contains("command")) {
            return "\u2699\ufe0f";
        }
        if (lower.contains("amount") || lower.contains("count")) {
            return "\ud83d\udd22";
        }
        if (lower.contains("quantity")) {
            return "\ud83d\udcca";
        }
        if (lower.contains("price") || lower.contains("cost") || lower.contains("money")) {
            return "\ud83d\udcb0";
        }
        if (lower.contains("exp") || lower.contains("experience")) {
            return "\u2728";
        }
        if (lower.contains("stack")) {
            return "\ud83d\udcda";
        }
        if (lower.contains("type")) {
            return "\ud83c\udff7\ufe0f";
        }
        return "\u2022";
    }

    private static String getEventIcon(SpawnerEventType eventType) {
        String eventName = eventType.name();
        if (eventName.startsWith("COMMAND_")) {
            if (eventName.contains("PLAYER")) {
                return "\ud83d\udc64";
            }
            if (eventName.contains("CONSOLE")) {
                return "\ud83d\udda5\ufe0f";
            }
            if (eventName.contains("RCON")) {
                return "\ud83d\udd0c";
            }
            return "\u2699\ufe0f";
        }
        if (eventName.equals("SPAWNER_PLACE")) {
            return "\u2705";
        }
        if (eventName.equals("SPAWNER_BREAK")) {
            return "\u274c";
        }
        if (eventName.equals("SPAWNER_EXPLODE")) {
            return "\ud83d\udca5";
        }
        if (eventName.contains("STACK_HAND")) {
            return "\u270b";
        }
        if (eventName.contains("STACK_GUI")) {
            return "\ud83d\udce6";
        }
        if (eventName.contains("DESTACK")) {
            return "\ud83d\udce4";
        }
        if (eventName.contains("GUI_OPEN")) {
            return "\ud83d\udccb";
        }
        if (eventName.contains("STORAGE_OPEN")) {
            return "\ud83d\udce6";
        }
        if (eventName.contains("STACKER_OPEN")) {
            return "\ud83d\udd22";
        }
        if (eventName.contains("EXP_CLAIM")) {
            return "\u2728";
        }
        if (eventName.contains("SELL_ALL")) {
            return "\ud83d\udcb0";
        }
        if (eventName.contains("ITEM_TAKE_ALL")) {
            return "\ud83c\udf92";
        }
        if (eventName.contains("ITEM_DROP")) {
            return "\ud83d\uddd1\ufe0f";
        }
        if (eventName.contains("ITEMS_SORT")) {
            return "\ud83d\udd03";
        }
        if (eventName.contains("ITEM_FILTER")) {
            return "\ud83d\udd0d";
        }
        if (eventName.contains("DROP_PAGE_ITEMS")) {
            return "\ud83d\udcc4";
        }
        if (eventName.contains("EGG_CHANGE")) {
            return "\ud83e\udd5a";
        }
        return "\ud83d\udccc";
    }
}

