/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.config;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.ItemPriceManager;
import github.nighter.smartspawner.spawner.lootgen.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.lootgen.loot.LootItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionType;

public class ItemSpawnerSettingsConfig {
    private final SmartSpawner plugin;
    private FileConfiguration config;
    private final File configFile;
    private Material defaultMaterial;
    private final Map<Material, ItemHeadData> itemHeadMap = new EnumMap<Material, ItemHeadData>(Material.class);
    private final Set<Material> validItemSpawnerMaterials = new HashSet<Material>();
    private final Map<Material, EntityLootConfig> itemLootConfigs = new ConcurrentHashMap<Material, EntityLootConfig>();

    public ItemSpawnerSettingsConfig(SmartSpawner plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "item_spawners_settings.yml");
    }

    public void load() {
        if (!this.configFile.exists()) {
            this.saveDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.parseConfig();
    }

    private void saveDefaultConfig() {
        try {
            InputStream inputStream = this.plugin.getResource("item_spawners_settings.yml");
            if (inputStream == null) {
                this.plugin.getLogger().warning("Could not find item_spawners_settings.yml in plugin resources");
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            this.plugin.getLogger().info("Created default item_spawners_settings.yml configuration");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create default item_spawners_settings.yml: " + e.getMessage());
        }
    }

    private void parseConfig() {
        this.itemHeadMap.clear();
        this.validItemSpawnerMaterials.clear();
        this.itemLootConfigs.clear();
        String defaultMaterialName = this.config.getString("default_material", "SPAWNER");
        try {
            this.defaultMaterial = Material.valueOf((String)defaultMaterialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid default_material in item_spawners_settings.yml: " + defaultMaterialName + ", using SPAWNER");
            this.defaultMaterial = Material.SPAWNER;
        }
        for (String materialName : this.config.getKeys(false)) {
            Material material;
            if (materialName.equals("default_material")) continue;
            try {
                material = Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Material '" + materialName + "' is invalid or not available in server version " + this.plugin.getServer().getBukkitVersion());
                continue;
            }
            ConfigurationSection itemSection = this.config.getConfigurationSection(materialName);
            if (itemSection == null) continue;
            String configMaterial = itemSection.getString("material");
            if (configMaterial == null || !configMaterial.equalsIgnoreCase(materialName)) {
                this.plugin.getLogger().warning("Material mismatch for " + materialName + " in item_spawners_settings.yml");
                continue;
            }
            this.parseHeadTexture(material, itemSection);
            this.parseLootData(material, itemSection);
            this.validItemSpawnerMaterials.add(material);
        }
        this.plugin.getLogger().info("Loaded " + this.validItemSpawnerMaterials.size() + " item spawner configurations");
    }

    private void parseLootData(Material material, ConfigurationSection itemSection) {
        int experience = itemSection.getInt("experience", 0);
        ArrayList<LootItem> items = new ArrayList<LootItem>();
        ItemPriceManager priceManager = this.plugin.getItemPriceManager();
        ConfigurationSection lootSection = itemSection.getConfigurationSection("loot");
        if (lootSection != null) {
            for (String itemKey : lootSection.getKeys(false)) {
                ConfigurationSection lootItemSection = lootSection.getConfigurationSection(itemKey);
                if (lootItemSection == null) continue;
                try {
                    Material lootMaterial;
                    try {
                        lootMaterial = Material.valueOf((String)itemKey.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Material '" + itemKey + "' is not available in server version " + this.plugin.getServer().getBukkitVersion() + " - skipping for item spawner " + material.name());
                        continue;
                    }
                    String[] amounts = lootItemSection.getString("amount", "1-1").split("-");
                    int minAmount = Integer.parseInt(amounts[0]);
                    int maxAmount = Integer.parseInt(amounts.length > 1 ? amounts[1] : amounts[0]);
                    double chance = lootItemSection.getDouble("chance", 100.0);
                    double sellPrice = 0.0;
                    if (priceManager != null) {
                        sellPrice = priceManager.getPrice(lootMaterial);
                    }
                    Integer minDurability = null;
                    Integer maxDurability = null;
                    PotionType potionType = null;
                    LootItem lootItem = new LootItem(lootMaterial, minAmount, maxAmount, chance, minDurability, maxDurability, potionType, sellPrice);
                    items.add(lootItem);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error parsing loot item " + itemKey + " for item spawner " + material.name() + ": " + e.getMessage());
                }
            }
        }
        EntityLootConfig lootConfig = new EntityLootConfig(experience, items);
        this.itemLootConfigs.put(material, lootConfig);
    }

    private void parseHeadTexture(Material material, ConfigurationSection itemSection) {
        Material headMaterial;
        ConfigurationSection headSection = itemSection.getConfigurationSection("head_texture");
        if (headSection == null) {
            return;
        }
        String headMaterialName = headSection.getString("material", material.name());
        String customTexture = headSection.getString("custom_texture");
        try {
            headMaterial = Material.valueOf((String)headMaterialName.toUpperCase());
            if (!headMaterial.isItem()) {
                this.plugin.getLogger().warning("Material " + headMaterialName + " for " + String.valueOf(material) + " is not an item, using the item itself");
                headMaterial = material;
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid head material " + headMaterialName + " for " + String.valueOf(material) + ", using the item itself");
            headMaterial = material;
        }
        this.itemHeadMap.put(material, new ItemHeadData(headMaterial, customTexture));
    }

    public ItemHeadData getHeadData(Material material) {
        return this.itemHeadMap.getOrDefault(material, new ItemHeadData(this.defaultMaterial, null));
    }

    public EntityLootConfig getLootConfig(Material material) {
        return this.itemLootConfigs.get(material);
    }

    public boolean isValidItemSpawner(Material material) {
        return this.validItemSpawnerMaterials.contains(material);
    }

    public Set<Material> getValidItemSpawnerMaterials() {
        return Collections.unmodifiableSet(this.validItemSpawnerMaterials);
    }

    public void reload() {
        this.load();
    }

    public static class ItemHeadData {
        private final Material material;
        private final String customTexture;

        public ItemHeadData(Material material, String customTexture) {
            this.material = material;
            this.customTexture = customTexture;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getCustomTexture() {
            return this.customTexture;
        }

        public boolean hasCustomTexture() {
            return this.customTexture != null && !this.customTexture.isEmpty() && !this.customTexture.equalsIgnoreCase("null");
        }
    }
}

