/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.config;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.ItemPriceManager;
import github.nighter.smartspawner.spawner.lootgen.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.lootgen.loot.LootItem;
import github.nighter.smartspawner.updates.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;

public class SpawnerSettingsConfig {
    private final SmartSpawner plugin;
    private FileConfiguration config;
    private final File configFile;
    private static final String CONFIG_VERSION_KEY = "config_version";
    private final String CURRENT_CONFIG_VERSION;
    private Material defaultMaterial;
    private final Map<EntityType, MobHeadData> mobHeadMap = new EnumMap<EntityType, MobHeadData>(EntityType.class);
    private final Map<String, EntityLootConfig> entityLootConfigs = new ConcurrentHashMap<String, EntityLootConfig>();
    private final Set<Material> loadedMaterials = new HashSet<Material>();

    public SpawnerSettingsConfig(SmartSpawner plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "spawners_settings.yml");
        this.CURRENT_CONFIG_VERSION = plugin.getDescription().getVersion();
    }

    public void load() {
        if (!this.configFile.exists()) {
            this.saveDefaultConfig();
        }
        this.checkAndUpdateConfig();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.parseConfig();
    }

    private void checkAndUpdateConfig() {
        Version currentConfigVersion;
        if (!this.configFile.exists()) {
            return;
        }
        YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        String configVersionStr = currentConfig.getString(CONFIG_VERSION_KEY, "0.0.0");
        Version configVersion = new Version(configVersionStr);
        if (configVersion.compareTo(currentConfigVersion = new Version(this.CURRENT_CONFIG_VERSION)) >= 0) {
            return;
        }
        this.plugin.getLogger().info("Updating spawners_settings.yml from version " + configVersionStr + " to " + this.CURRENT_CONFIG_VERSION);
        try {
            Map<String, Object> userValues = this.flattenConfig((ConfigurationSection)currentConfig);
            File tempFile = new File(this.plugin.getDataFolder(), "spawners_settings_new.yml");
            this.createDefaultConfigWithHeader(tempFile);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)tempFile);
            newConfig.set(CONFIG_VERSION_KEY, (Object)this.CURRENT_CONFIG_VERSION);
            boolean configDiffers = this.hasConfigDifferences(userValues, (FileConfiguration)newConfig);
            if (configDiffers) {
                File backupFile = new File(this.plugin.getDataFolder(), "spawners_settings_backup_" + configVersionStr + ".yml");
                Files.copy(this.configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Config backup created at " + backupFile.getName());
            } else {
                this.plugin.debug("No significant config changes detected, skipping backup creation");
            }
            this.applyUserValues((FileConfiguration)newConfig, userValues);
            newConfig.save(this.configFile);
            tempFile.delete();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to update spawners_settings.yml", e);
        }
    }

    private void createDefaultConfigWithHeader(File destinationFile) {
        try {
            File parentDir = destinationFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (InputStream in = this.plugin.getResource("spawners_settings.yml");){
                if (in != null) {
                    List<String> defaultLines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().toList();
                    ArrayList<Object> newLines = new ArrayList<Object>();
                    newLines.add("# Configuration version - Do not modify this value");
                    newLines.add("config_version: " + this.CURRENT_CONFIG_VERSION);
                    newLines.add("");
                    newLines.addAll(defaultLines);
                    Files.write(destinationFile.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    this.plugin.getLogger().warning("Default spawners_settings.yml not found in the plugin's resources.");
                    destinationFile.createNewFile();
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create default spawners_settings.yml with header: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean hasConfigDifferences(Map<String, Object> userValues, FileConfiguration newConfig) {
        Map<String, Object> newConfigMap = this.flattenConfig((ConfigurationSection)newConfig);
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object oldValue = entry.getValue();
            if (path.equals(CONFIG_VERSION_KEY)) continue;
            if (!newConfig.contains(path)) {
                return true;
            }
            Object newDefaultValue = newConfig.get(path);
            if (newDefaultValue == null || newDefaultValue.equals(oldValue)) continue;
            return true;
        }
        for (String path : newConfigMap.keySet()) {
            if (path.equals(CONFIG_VERSION_KEY) || userValues.containsKey(path)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> flattenConfig(ConfigurationSection config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : config.getKeys(true)) {
            if (config.isConfigurationSection(key)) continue;
            result.put(key, config.get(key));
        }
        return result;
    }

    private void applyUserValues(FileConfiguration newConfig, Map<String, Object> userValues) {
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object value = entry.getValue();
            if (path.equals(CONFIG_VERSION_KEY)) continue;
            if (newConfig.contains(path)) {
                newConfig.set(path, value);
                continue;
            }
            this.plugin.getLogger().warning("Config path '" + path + "' from old config no longer exists in new config");
        }
    }

    private void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfigWithHeader(this.configFile);
            this.plugin.getLogger().info("Created default spawners_settings.yml configuration");
        }
    }

    private void parseConfig() {
        this.mobHeadMap.clear();
        this.entityLootConfigs.clear();
        this.loadedMaterials.clear();
        String defaultMaterialName = this.config.getString("default_material", "SPAWNER");
        try {
            this.defaultMaterial = Material.valueOf((String)defaultMaterialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid default_material in spawners_settings.yml: " + defaultMaterialName + ", using SPAWNER");
            this.defaultMaterial = Material.SPAWNER;
        }
        for (String entityName : this.config.getKeys(false)) {
            EntityType entityType;
            if (entityName.equals(CONFIG_VERSION_KEY) || entityName.equals("default_material")) continue;
            try {
                entityType = EntityType.valueOf((String)entityName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Entity type '" + entityName + "' is invalid or not available in server version " + this.plugin.getServer().getBukkitVersion());
                continue;
            }
            ConfigurationSection entitySection = this.config.getConfigurationSection(entityName);
            if (entitySection == null) continue;
            this.parseHeadTexture(entityType, entitySection);
            this.parseLootData(entityName, entitySection);
        }
    }

    private void parseHeadTexture(EntityType entityType, ConfigurationSection entitySection) {
        Material material;
        ConfigurationSection headSection = entitySection.getConfigurationSection("head_texture");
        if (headSection == null) {
            return;
        }
        String materialName = headSection.getString("material", "SPAWNER");
        String customTexture = headSection.getString("custom_texture");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
            if (!material.isItem()) {
                this.plugin.getLogger().warning("Material " + materialName + " for " + String.valueOf(entityType) + " is not an item, using default");
                material = this.defaultMaterial;
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material " + materialName + " for " + String.valueOf(entityType) + ", using default");
            material = this.defaultMaterial;
        }
        this.mobHeadMap.put(entityType, new MobHeadData(material, customTexture));
    }

    private void parseLootData(String entityName, ConfigurationSection entitySection) {
        int experience = entitySection.getInt("experience", 0);
        ArrayList<LootItem> items = new ArrayList<LootItem>();
        ItemPriceManager priceManager = this.plugin.getItemPriceManager();
        ConfigurationSection lootSection = entitySection.getConfigurationSection("loot");
        if (lootSection != null) {
            for (String itemKey : lootSection.getKeys(false)) {
                ConfigurationSection itemSection = lootSection.getConfigurationSection(itemKey);
                if (itemSection == null) continue;
                try {
                    String potionTypeName;
                    Material material;
                    try {
                        material = Material.valueOf((String)itemKey.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        material = null;
                    }
                    if (material == null) {
                        this.plugin.getLogger().warning("Material '" + itemKey + "' is not available in server version " + this.plugin.getServer().getBukkitVersion() + " - skipping for entity " + entityName);
                        continue;
                    }
                    this.loadedMaterials.add(material);
                    String[] amounts = itemSection.getString("amount", "1-1").split("-");
                    int minAmount = Integer.parseInt(amounts[0]);
                    int maxAmount = Integer.parseInt(amounts.length > 1 ? amounts[1] : amounts[0]);
                    double chance = itemSection.getDouble("chance", 100.0);
                    double sellPrice = 0.0;
                    if (priceManager != null) {
                        sellPrice = priceManager.getPrice(material);
                    }
                    Integer minDurability = null;
                    Integer maxDurability = null;
                    if (itemSection.contains("durability")) {
                        String[] durabilities = itemSection.getString("durability").split("-");
                        minDurability = Integer.parseInt(durabilities[0]);
                        maxDurability = Integer.parseInt(durabilities.length > 1 ? durabilities[1] : durabilities[0]);
                    }
                    PotionType potionType = null;
                    if (material == Material.TIPPED_ARROW && itemSection.contains("potion_type") && (potionTypeName = itemSection.getString("potion_type")) != null) {
                        try {
                            potionType = PotionType.valueOf((String)potionTypeName.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid potion type '" + potionTypeName + "' for entity " + entityName);
                            continue;
                        }
                    }
                    items.add(new LootItem(material, minAmount, maxAmount, chance, minDurability, maxDurability, potionType, sellPrice));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error processing material '" + itemKey + "' for entity " + entityName + ": " + e.getMessage());
                }
            }
        }
        this.entityLootConfigs.put(entityName.toLowerCase(), new EntityLootConfig(experience, items));
    }

    public Material getMaterial(EntityType entityType) {
        MobHeadData data = this.mobHeadMap.get(entityType);
        return data != null ? data.material : this.defaultMaterial;
    }

    public String getCustomTexture(EntityType entityType) {
        MobHeadData data = this.mobHeadMap.get(entityType);
        return data != null ? data.customTexture : null;
    }

    public boolean hasCustomTexture(EntityType entityType) {
        MobHeadData data = this.mobHeadMap.get(entityType);
        return data != null && data.customTexture != null && !data.customTexture.isEmpty();
    }

    public EntityLootConfig getLootConfig(EntityType entityType) {
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return null;
        }
        return this.entityLootConfigs.get(entityType.name().toLowerCase());
    }

    public Set<Material> getLoadedMaterials() {
        return new HashSet<Material>(this.loadedMaterials);
    }

    public void reload() {
        this.load();
    }

    private static class MobHeadData {
        final Material material;
        final String customTexture;

        MobHeadData(Material material, String customTexture) {
            this.material = material;
            this.customTexture = customTexture;
        }
    }
}

