/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.logging.SpawnerEventType;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.storage.ui.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemClickHandler;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveHelper;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveResult;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.lootgen.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.sell.SpawnerSellManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class SpawnerStorageAction
implements Listener {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final MessageService messageService;
    private final FilterConfigUI filterConfigUI;
    private final SpawnerSellManager spawnerSellManager;
    private final SpawnerManager spawnerManager;
    private static final int INVENTORY_SIZE = 54;
    private static final int STORAGE_SLOTS = 45;
    private final Map<ClickType, ItemClickHandler> clickHandlers;
    private final Map<UUID, Long> lastItemClickTime = new ConcurrentHashMap<UUID, Long>();
    private static final long CLICK_DELAY_MS = 300L;
    private final Random random = new Random();
    private GuiLayout layout;

    public SpawnerStorageAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.clickHandlers = this.initializeClickHandlers();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.messageService = plugin.getMessageService();
        this.filterConfigUI = plugin.getFilterConfigUI();
        this.spawnerSellManager = plugin.getSpawnerSellManager();
        this.spawnerManager = plugin.getSpawnerManager();
        this.loadConfig();
    }

    public void loadConfig() {
        GuiLayoutConfig guiLayoutConfig = this.plugin.getGuiLayoutConfig();
        this.layout = guiLayoutConfig.getCurrentLayout();
    }

    private Map<ClickType, ItemClickHandler> initializeClickHandlers() {
        EnumMap<ClickType, ItemClickHandler> handlers = new EnumMap<ClickType, ItemClickHandler>(ClickType.class);
        handlers.put(ClickType.RIGHT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, true));
        handlers.put(ClickType.LEFT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, false));
        return Collections.unmodifiableMap(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity;
        block21: {
            block20: {
                humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block20;
                player = (Player)humanEntity;
                humanEntity = event.getInventory().getHolder(false);
                if (humanEntity instanceof StoragePageHolder) break block21;
            }
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)humanEntity;
        SpawnerData spawner = holder.getSpawnerData();
        int slot = event.getRawSlot();
        event.setCancelled(true);
        if (!this.tryAcquireInventoryLock(spawner, player)) {
            return;
        }
        try {
            ItemStack clickedItem;
            if (!this.isGuiSyncValid(player, holder, spawner)) {
                player.closeInventory();
                return;
            }
            if ((event.getAction() == InventoryAction.DROP_ONE_SLOT || event.getAction() == InventoryAction.DROP_ALL_SLOT) && slot >= 0 && slot < 45 && (clickedItem = event.getCurrentItem()) != null && clickedItem.getType() != Material.AIR) {
                boolean dropStack = event.getAction() == InventoryAction.DROP_ALL_SLOT;
                this.handleItemDrop(player, spawner, event.getInventory(), slot, clickedItem, dropStack);
                return;
            }
            if (slot < 0 || slot >= 54) {
                return;
            }
            if (this.isControlSlot(slot)) {
                this.handleControlSlotClick(player, slot, holder, spawner, event.getInventory(), this.layout);
                return;
            }
            clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            ItemClickHandler handler = this.clickHandlers.get(event.getClick());
            if (handler != null) {
                handler.handle(player, event.getInventory(), slot, clickedItem, spawner);
            }
        }
        finally {
            spawner.getInventoryLock().unlock();
            spawner.getLootGenerationLock().unlock();
        }
    }

    private void handleControlSlotClick(Player player, int slot, StoragePageHolder holder, SpawnerData spawner, Inventory inventory, GuiLayout layout) {
        String buttonType;
        Optional<String> buttonTypeOpt = layout.getButtonTypeAtSlot(slot);
        if (buttonTypeOpt.isEmpty()) {
            return;
        }
        switch (buttonType = buttonTypeOpt.get()) {
            case "sort_items": {
                this.handleSortItemsClick(player, spawner, inventory);
                break;
            }
            case "item_filter": {
                this.openFilterConfig(player, spawner);
                break;
            }
            case "previous_page": {
                if (holder.getCurrentPage() <= 1) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() - 1, inventory, true);
                break;
            }
            case "take_all": {
                this.handleTakeAllItems(player, inventory);
                break;
            }
            case "next_page": {
                if (holder.getCurrentPage() >= holder.getTotalPages()) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() + 1, inventory, true);
                break;
            }
            case "drop_page": {
                this.handleDropPageItems(player, spawner, inventory);
                break;
            }
            case "sell_all": {
                if (!this.plugin.hasSellIntegration()) break;
                if (!player.hasPermission("smartspawner.sellall")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return;
                }
                if (this.isClickTooFrequent(player)) {
                    return;
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.spawnerSellManager.sellAllItems(player, spawner);
                break;
            }
            case "return": {
                this.openMainMenu(player, spawner);
            }
        }
    }

    private boolean isControlSlot(int slot) {
        return this.layout != null && this.layout.isSlotUsed(slot);
    }

    private boolean tryAcquireInventoryLock(SpawnerData spawner, Player player) {
        try {
            if (!spawner.getLootGenerationLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                return false;
            }
            try {
                if (!spawner.getInventoryLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                    spawner.getLootGenerationLock().unlock();
                    return false;
                }
            }
            catch (InterruptedException e) {
                spawner.getLootGenerationLock().unlock();
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean isGuiSyncValid(Player player, StoragePageHolder holder, SpawnerData spawner) {
        int cachedUsedSlots;
        if (!holder.getSpawnerData().getSpawnerId().equals(spawner.getSpawnerId())) {
            this.plugin.getLogger().warning("GUI sync error: holder spawner mismatch for player " + player.getName());
            return false;
        }
        Inventory currentInv = player.getOpenInventory().getTopInventory();
        InventoryHolder inventoryHolder = currentInv.getHolder(false);
        if (!(inventoryHolder instanceof StoragePageHolder)) {
            return false;
        }
        StoragePageHolder currentHolder = (StoragePageHolder)inventoryHolder;
        if (!currentHolder.getSpawnerData().getSpawnerId().equals(spawner.getSpawnerId())) {
            return false;
        }
        int actualUsedSlots = spawner.getVirtualInventory().getUsedSlots();
        if (Math.abs(actualUsedSlots - (cachedUsedSlots = holder.getOldUsedSlots())) > 45) {
            if (this.plugin.isDebugMode()) {
                this.plugin.debug("GUI out of sync for player " + player.getName() + ": actual=" + actualUsedSlots + ", cached=" + cachedUsedSlots);
            }
            this.refreshGuiFromVirtualInventory(player, spawner, currentInv);
            return false;
        }
        return true;
    }

    private void handleItemDrop(Player player, SpawnerData spawner, Inventory inventory, int slot, ItemStack item, boolean dropStack) {
        ItemStack actualItem = inventory.getItem(slot);
        if (actualItem == null || !actualItem.isSimilar(item) || actualItem.getAmount() != item.getAmount()) {
            this.plugin.getLogger().warning("Item desync detected in slot " + slot + " for player " + player.getName());
            this.refreshGuiFromVirtualInventory(player, spawner, inventory);
            return;
        }
        int amountToDrop = dropStack ? item.getAmount() : 1;
        ItemStack droppedItem = item.clone();
        droppedItem.setAmount(Math.min(amountToDrop, item.getAmount()));
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        itemsToRemove.add(droppedItem);
        spawner.removeItemsAndUpdateSellValue(itemsToRemove);
        int remaining = item.getAmount() - amountToDrop;
        if (remaining <= 0) {
            inventory.setItem(slot, null);
        } else {
            ItemStack remainingItem = item.clone();
            remainingItem.setAmount(remaining);
            inventory.setItem(slot, remainingItem);
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        double yaw = Math.toRadians(playerLoc.getYaw());
        double pitch = Math.toRadians(playerLoc.getPitch());
        double sinYaw = -Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = -Math.sin(pitch);
        Location dropLocation = playerLoc.clone();
        dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
        Item droppedItemWorld = world.dropItem(dropLocation, droppedItem, drop -> {
            drop.setThrower(playerUUID);
            drop.setPickupDelay(40);
        });
        Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
        droppedItemWorld.setVelocity(velocity);
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEM_DROP, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("item_type", droppedItem.getType().name()).metadata("amount_dropped", droppedItem.getAmount()).metadata("drop_stack", dropStack));
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
        spawner.updateHologramData();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder != null) {
            int newTotalPages;
            int oldTotalPages = holder.getTotalPages();
            if (oldTotalPages != (newTotalPages = this.calculateTotalPages(spawner))) {
                int currentPage = holder.getCurrentPage();
                int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
                holder.setTotalPages(newTotalPages);
                if (adjustedPage != currentPage) {
                    holder.setCurrentPage(adjustedPage);
                }
                this.updateInventoryTitle(player, spawner, adjustedPage, newTotalPages);
            }
            holder.updateOldUsedSlots();
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
        }
    }

    private void handleDropPageItems(Player player, SpawnerData spawner, Inventory inventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder == null) {
            return;
        }
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int itemsFoundCount = 0;
        for (int i = 0; i < 45; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            pageItems.add(item.clone());
            itemsFoundCount += item.getAmount();
            inventory.setItem(i, null);
        }
        if (pageItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_items_to_drop");
            return;
        }
        int itemsFound = itemsFoundCount;
        spawner.removeItemsAndUpdateSellValue(pageItems);
        this.dropItemsInDirection(player, pageItems);
        int newTotalPages = this.calculateTotalPages(spawner);
        if (holder.getCurrentPage() > newTotalPages) {
            holder.setCurrentPage(Math.max(1, newTotalPages));
        }
        holder.setTotalPages(newTotalPages);
        holder.updateOldUsedSlots();
        spawner.updateHologramData();
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
        if (!spawner.isInteracted()) {
            spawner.markInteracted();
        }
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_DROP_PAGE_ITEMS, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("items_dropped", itemsFound).metadata("page_number", holder.getCurrentPage()));
        }
        this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.8f, 0.8f);
    }

    private void dropItemsInDirection(Player player, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        double yaw = Math.toRadians(playerLoc.getYaw());
        double pitch = Math.toRadians(playerLoc.getPitch());
        double sinYaw = -Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = -Math.sin(pitch);
        Location dropLocation = playerLoc.clone();
        dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
        for (ItemStack item : items) {
            Item droppedItem = world.dropItem(dropLocation, item, drop -> {
                drop.setThrower(playerUUID);
                drop.setPickupDelay(40);
            });
            Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
            droppedItem.setVelocity(velocity);
        }
    }

    private void openFilterConfig(Player player, SpawnerData spawner) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        this.filterConfigUI.openFilterConfigGUI(player, spawner);
    }

    private void takeSingleItem(Player player, Inventory sourceInv, int slot, ItemStack item, SpawnerData spawner, boolean singleItem) {
        VirtualInventory virtualInv;
        PlayerInventory playerInv;
        ItemStack actualItem = sourceInv.getItem(slot);
        if (actualItem == null || !actualItem.isSimilar(item) || actualItem.getAmount() != item.getAmount()) {
            this.plugin.getLogger().warning("Item desync detected in takeSingleItem for player " + player.getName());
            this.refreshGuiFromVirtualInventory(player, spawner, sourceInv);
            return;
        }
        ItemMoveResult result = ItemMoveHelper.moveItems(item, singleItem ? 1 : item.getAmount(), playerInv = player.getInventory(), virtualInv = spawner.getVirtualInventory());
        if (result.amountMoved() > 0) {
            SpawnerStorageAction.updateInventorySlot(sourceInv, slot, item, result.amountMoved());
            spawner.removeItemsAndUpdateSellValue(result.movedItems());
            player.updateInventory();
            spawner.updateHologramData();
            StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder(false);
            if (holder != null) {
                int newTotalPages;
                int oldTotalPages = holder.getTotalPages();
                if (oldTotalPages != (newTotalPages = this.calculateTotalPages(spawner))) {
                    int currentPage = holder.getCurrentPage();
                    int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
                    holder.setTotalPages(newTotalPages);
                    if (adjustedPage != currentPage) {
                        holder.setCurrentPage(adjustedPage);
                    }
                    this.updateInventoryTitle(player, spawner, adjustedPage, newTotalPages);
                }
                holder.updateOldUsedSlots();
                this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(false);
                }
            }
        } else {
            this.messageService.sendMessage(player, "inventory_full");
        }
    }

    private static void updateInventorySlot(Inventory sourceInv, int slot, ItemStack item, int amountMoved) {
        if (amountMoved >= item.getAmount()) {
            sourceInv.setItem(slot, null);
            return;
        }
        ItemStack remaining = item.clone();
        remaining.setAmount(item.getAmount() - amountMoved);
        sourceInv.setItem(slot, remaining);
    }

    private void updatePageContent(Player player, SpawnerData spawner, int newPage, Inventory inventory, boolean uiClickSound) {
        SpawnerStorageUI spawnerStorageUI = this.plugin.getSpawnerStorageUI();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        int totalPages = this.calculateTotalPages(spawner);
        assert (holder != null);
        holder.setTotalPages(totalPages);
        holder.setCurrentPage(newPage);
        holder.updateOldUsedSlots();
        spawnerStorageUI.updateDisplay(inventory, spawner, newPage, totalPages);
        this.updateInventoryTitle(player, spawner, newPage, totalPages);
        if (uiClickSound) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private void updateInventoryTitle(Player player, SpawnerData spawner, int page, int totalPages) {
        String newTitle = this.languageManager.getGuiTitle("gui_title_storage", Map.of("current_page", String.valueOf(page), "total_pages", String.valueOf(totalPages)));
        try {
            player.getOpenInventory().setTitle(newTitle);
        }
        catch (Exception e) {
            this.openLootPage(player, spawner, page);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastItemClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastItemClickTime.remove(playerId);
    }

    private void openMainMenu(Player player, SpawnerData spawner) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (spawner.isInteracted()) {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
        if (this.isBedrockPlayer(player)) {
            if (this.plugin.getSpawnerMenuFormUI() != null) {
                this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
        }
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    private void handleSortItemsClick(Player player, SpawnerData spawner, Inventory inventory) {
        Material nextSort;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        if (spawner.getLootConfig() == null || spawner.getLootConfig().getAllItems() == null) {
            return;
        }
        List<LootItem> lootItems = spawner.getLootConfig().getAllItems();
        if (lootItems.isEmpty()) {
            return;
        }
        Material currentSort = spawner.getPreferredSortItem();
        List<Material> sortedLoot = lootItems.stream().map(LootItem::material).distinct().sorted(Comparator.comparing(Enum::name)).toList();
        if (sortedLoot.isEmpty()) {
            return;
        }
        if (currentSort == null) {
            nextSort = sortedLoot.getFirst();
        } else {
            int currentIndex = sortedLoot.indexOf(currentSort);
            if (currentIndex == -1) {
                nextSort = sortedLoot.getFirst();
            } else {
                int nextIndex = (currentIndex + 1) % sortedLoot.size();
                nextSort = sortedLoot.get(nextIndex);
            }
        }
        spawner.setPreferredSortItem(nextSort);
        if (!spawner.isInteracted()) {
            spawner.markInteracted();
        }
        this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        spawner.getVirtualInventory().sortItems(nextSort);
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder != null) {
            this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEMS_SORT, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("sort_item", nextSort.name()).metadata("previous_sort", currentSort != null ? currentSort.name() : "none"));
        }
    }

    private void openLootPage(Player player, SpawnerData spawner, int page) {
        SpawnerStorageUI spawnerStorageUI = this.plugin.getSpawnerStorageUI();
        int totalPages = this.calculateTotalPages(spawner);
        int finalPage = Math.max(1, Math.min(page, totalPages));
        Inventory pageInventory = spawnerStorageUI.createStorageInventory(spawner, finalPage, totalPages);
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_STORAGE_OPEN, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("page", finalPage).metadata("total_pages", totalPages));
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        player.openInventory(pageInventory);
    }

    public void handleTakeAllItems(Player player, Inventory sourceInventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
        SpawnerData spawner = holder.getSpawnerData();
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        HashMap<Integer, ItemStack> sourceItems = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < 45; ++i) {
            ItemStack item = sourceInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            sourceItems.put(i, item.clone());
        }
        if (sourceItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_items_to_take");
            return;
        }
        TransferResult result = this.transferItems(player, sourceInventory, sourceItems, virtualInv);
        this.sendTransferMessage(player, result);
        player.updateInventory();
        if (result.anyItemMoved) {
            int newTotalPages = this.calculateTotalPages(spawner);
            int currentPage = holder.getCurrentPage();
            int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
            holder.setTotalPages(newTotalPages);
            if (adjustedPage != currentPage) {
                holder.setCurrentPage(adjustedPage);
                SpawnerStorageUI spawnerStorageUI = this.plugin.getSpawnerStorageUI();
                spawnerStorageUI.updateDisplay(sourceInventory, spawner, adjustedPage, newTotalPages);
            }
            this.updateInventoryTitle(player, spawner, adjustedPage, newTotalPages);
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            if (this.plugin.getSpawnerActionLogger() != null) {
                int itemsLeft = spawner.getVirtualInventory().getUsedSlots();
                this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEM_TAKE_ALL, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("items_taken", result.totalMoved).metadata("items_left", itemsLeft));
            }
        }
    }

    private TransferResult transferItems(Player player, Inventory sourceInventory, Map<Integer, ItemStack> sourceItems, VirtualInventory virtualInv) {
        boolean anyItemMoved = false;
        boolean inventoryFull = false;
        PlayerInventory playerInv = player.getInventory();
        int totalAmountMoved = 0;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ItemStack> entry : sourceItems.entrySet()) {
            int sourceSlot = entry.getKey();
            ItemStack itemToMove = entry.getValue();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem == null || targetItem.getType() == Material.AIR) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    playerInv.setItem(i, newStack);
                    amountMoved += newStack.getAmount();
                    amountToMove -= newStack.getAmount();
                    anyItemMoved = true;
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                anyItemMoved = true;
            }
            if (amountMoved > 0) {
                totalAmountMoved += amountMoved;
                ItemStack movedItem = itemToMove.clone();
                movedItem.setAmount(amountMoved);
                itemsToRemove.add(movedItem);
                if (amountMoved == itemToMove.getAmount()) {
                    sourceInventory.setItem(sourceSlot, null);
                } else {
                    ItemStack remaining = itemToMove.clone();
                    remaining.setAmount(itemToMove.getAmount() - amountMoved);
                    sourceInventory.setItem(sourceSlot, remaining);
                    inventoryFull = true;
                }
            }
            if (!inventoryFull) continue;
            break;
        }
        if (!itemsToRemove.isEmpty()) {
            StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
            SpawnerData spawnerData = holder.getSpawnerData();
            spawnerData.removeItemsAndUpdateSellValue(itemsToRemove);
            spawnerData.updateHologramData();
            holder.updateOldUsedSlots();
        }
        return new TransferResult(anyItemMoved, inventoryFull, totalAmountMoved);
    }

    private void sendTransferMessage(Player player, TransferResult result) {
        if (!result.anyItemMoved) {
            this.messageService.sendMessage(player, "inventory_full");
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(result.totalMoved));
            this.messageService.sendMessage(player, "take_all_items", placeholders);
        }
    }

    private void refreshGuiFromVirtualInventory(Player player, SpawnerData spawner, Inventory inventory) {
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder == null) {
            return;
        }
        int totalPages = this.calculateTotalPages(spawner);
        int currentPage = Math.max(1, Math.min(holder.getCurrentPage(), totalPages));
        holder.setTotalPages(totalPages);
        holder.setCurrentPage(currentPage);
        holder.updateOldUsedSlots();
        SpawnerStorageUI spawnerStorageUI = this.plugin.getSpawnerStorageUI();
        spawnerStorageUI.updateDisplay(inventory, spawner, currentPage, totalPages);
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (this.plugin.isDebugMode()) {
            this.plugin.debug("GUI refreshed from VirtualInventory for player " + player.getName() + " on spawner " + spawner.getSpawnerId());
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof StoragePageHolder)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof StoragePageHolder)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventoryHolder;
        SpawnerData spawner = holder.getSpawnerData();
        if (spawner.isInteracted()) {
            this.plugin.getSpawnerManager().markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
    }

    private record TransferResult(boolean anyItemMoved, boolean inventoryFull, int totalMoved) {
    }
}

