/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization.managers;

import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ViewerTrackingManager {
    private final Map<UUID, ViewerInfo> playerToSpawnerMap = new ConcurrentHashMap<UUID, ViewerInfo>();
    private final Map<String, Set<UUID>> spawnerToPlayersMap = new ConcurrentHashMap<String, Set<UUID>>();
    private final Map<UUID, ViewerInfo> mainMenuViewers = new ConcurrentHashMap<UUID, ViewerInfo>();
    private final Map<String, Set<UUID>> spawnerToMainMenuViewers = new ConcurrentHashMap<String, Set<UUID>>();
    private final Map<String, Set<UUID>> spawnerToFilterViewersMap = new ConcurrentHashMap<String, Set<UUID>>();

    public void trackViewer(UUID playerId, SpawnerData spawner, ViewerType viewerType) {
        ViewerInfo info = new ViewerInfo(spawner, viewerType);
        this.playerToSpawnerMap.put(playerId, info);
        this.spawnerToPlayersMap.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        if (viewerType == ViewerType.MAIN_MENU) {
            this.mainMenuViewers.put(playerId, info);
            this.spawnerToMainMenuViewers.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        }
        if (viewerType == ViewerType.FILTER) {
            this.spawnerToFilterViewersMap.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        }
    }

    public void untrackViewer(UUID playerId) {
        SpawnerData spawner;
        Set<UUID> mainMenuViewerSet;
        ViewerInfo mainMenuInfo;
        ViewerInfo info = this.playerToSpawnerMap.remove(playerId);
        if (info != null) {
            Set<UUID> filterViewers;
            SpawnerData spawner2 = info.spawnerData;
            String spawnerId = spawner2.getSpawnerId();
            Set<UUID> viewers = this.spawnerToPlayersMap.get(spawnerId);
            if (viewers != null) {
                viewers.remove(playerId);
                if (viewers.isEmpty()) {
                    this.spawnerToPlayersMap.remove(spawnerId);
                }
            }
            if ((filterViewers = this.spawnerToFilterViewersMap.get(spawnerId)) != null) {
                filterViewers.remove(playerId);
                if (filterViewers.isEmpty()) {
                    this.spawnerToFilterViewersMap.remove(spawnerId);
                }
            }
        }
        if ((mainMenuInfo = this.mainMenuViewers.remove(playerId)) != null && (mainMenuViewerSet = this.spawnerToMainMenuViewers.get((spawner = mainMenuInfo.spawnerData).getSpawnerId())) != null) {
            mainMenuViewerSet.remove(playerId);
            if (mainMenuViewerSet.isEmpty()) {
                this.spawnerToMainMenuViewers.remove(spawner.getSpawnerId());
            }
        }
    }

    public Set<Player> getViewers(String spawnerId) {
        Set<UUID> viewerIds = this.spawnerToPlayersMap.get(spawnerId);
        if (viewerIds == null || viewerIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Player> onlineViewers = new HashSet<Player>(viewerIds.size());
        for (UUID id : viewerIds) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline()) continue;
            onlineViewers.add(player);
        }
        return onlineViewers;
    }

    public boolean hasViewers(SpawnerData spawner) {
        Set<UUID> viewers = this.spawnerToPlayersMap.get(spawner.getSpawnerId());
        return viewers != null && !viewers.isEmpty();
    }

    public ViewerInfo getViewerInfo(UUID playerId) {
        return this.playerToSpawnerMap.get(playerId);
    }

    public Map<UUID, ViewerInfo> getMainMenuViewers() {
        return this.mainMenuViewers;
    }

    public Set<UUID> getMainMenuViewersForSpawner(String spawnerId) {
        return this.spawnerToMainMenuViewers.get(spawnerId);
    }

    public Map<UUID, ViewerInfo> getAllViewers() {
        return this.playerToSpawnerMap;
    }

    public Set<UUID> getViewerIds(String spawnerId) {
        return this.spawnerToPlayersMap.get(spawnerId);
    }

    public Set<UUID> getFilterViewersForSpawner(String spawnerId) {
        return this.spawnerToFilterViewersMap.get(spawnerId);
    }

    public boolean hasAnyViewers() {
        return !this.playerToSpawnerMap.isEmpty();
    }

    public boolean hasMainMenuViewers() {
        return !this.mainMenuViewers.isEmpty();
    }

    public void clearAll() {
        this.playerToSpawnerMap.clear();
        this.spawnerToPlayersMap.clear();
        this.mainMenuViewers.clear();
        this.spawnerToMainMenuViewers.clear();
        this.spawnerToFilterViewersMap.clear();
    }

    public static class ViewerInfo {
        private final SpawnerData spawnerData;
        private final long lastUpdateTime;
        private final ViewerType viewerType;

        public ViewerInfo(SpawnerData spawnerData, ViewerType viewerType) {
            this.spawnerData = spawnerData;
            this.lastUpdateTime = System.currentTimeMillis();
            this.viewerType = viewerType;
        }

        public SpawnerData getSpawnerData() {
            return this.spawnerData;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public ViewerType getViewerType() {
            return this.viewerType;
        }
    }

    public static enum ViewerType {
        MAIN_MENU,
        STORAGE,
        FILTER;

    }
}

