/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization.services;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuHolder;
import github.nighter.smartspawner.spawner.gui.synchronization.managers.SlotCacheManager;
import github.nighter.smartspawner.spawner.gui.synchronization.managers.ViewerTrackingManager;
import github.nighter.smartspawner.spawner.gui.synchronization.utils.LootPreGenerationHelper;
import github.nighter.smartspawner.spawner.gui.synchronization.utils.TimerFormatter;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TimerUpdateService {
    private static final int MAX_PLAYERS_PER_BATCH = 10;
    private static final Pattern TIMER_PATTERN = Pattern.compile("\\d{2}:\\d{2}");
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final LootPreGenerationHelper lootHelper;
    private final ViewerTrackingManager viewerTrackingManager;
    private final SlotCacheManager slotCacheManager;
    private String cachedInactiveText;
    private String cachedFullText;
    private String cachedNoLootText;
    private volatile Boolean hasTimerPlaceholders = null;
    private final Map<UUID, Long> lastTimerUpdate = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> lastTimerValue = new ConcurrentHashMap<UUID, String>();
    private final Map<String, Integer> timerLineIndexCache = new ConcurrentHashMap<String, Integer>();

    public TimerUpdateService(SmartSpawner plugin, ViewerTrackingManager viewerTrackingManager, SlotCacheManager slotCacheManager) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.lootHelper = new LootPreGenerationHelper(plugin);
        this.viewerTrackingManager = viewerTrackingManager;
        this.slotCacheManager = slotCacheManager;
        this.initializeCachedStrings();
    }

    private void initializeCachedStrings() {
        this.cachedInactiveText = this.languageManager.getGuiItemName("spawner_info_item.lore_inactive");
        this.cachedFullText = this.languageManager.getGuiItemName("spawner_info_item.lore_full");
        this.cachedNoLootText = this.languageManager.getGuiItemName("spawner_info_item.lore_no_loot");
        this.checkTimerPlaceholderUsage();
    }

    private void checkTimerPlaceholderUsage() {
        try {
            String[] loreLines = this.languageManager.getGuiItemLore("spawner_info_item.lore");
            String[] loreNoShopLines = this.languageManager.getGuiItemLore("spawner_info_item.lore_no_shop");
            boolean hasTimers = false;
            if (loreLines != null) {
                for (String line : loreLines) {
                    if (line == null || !line.contains("{time}")) continue;
                    hasTimers = true;
                    break;
                }
            }
            if (!hasTimers && loreNoShopLines != null) {
                for (String line : loreNoShopLines) {
                    if (line == null || !line.contains("{time}")) continue;
                    hasTimers = true;
                    break;
                }
            }
            this.hasTimerPlaceholders = hasTimers;
        }
        catch (Exception e) {
            this.hasTimerPlaceholders = true;
        }
    }

    public boolean isTimerPlaceholdersEnabled() {
        return this.hasTimerPlaceholders == null || this.hasTimerPlaceholders != false;
    }

    public boolean shouldProcessTimerUpdates() {
        return this.hasTimerPlaceholders == null || this.hasTimerPlaceholders != false;
    }

    public void recheckTimerPlaceholders() {
        this.timerLineIndexCache.clear();
        this.lastTimerUpdate.clear();
        this.lastTimerValue.clear();
        this.initializeCachedStrings();
    }

    public String calculateTimerDisplay(SpawnerData spawner, Player player) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return "";
        }
        if (player != null && player.getGameMode() == GameMode.SPECTATOR) {
            return this.cachedInactiveText;
        }
        if (spawner.hasNoLootOrExperience()) {
            return this.cachedNoLootText;
        }
        if (spawner.getIsAtCapacity().booleanValue()) {
            return this.cachedFullText;
        }
        long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
        if (timeUntilNextSpawn == -1L) {
            return this.cachedInactiveText;
        }
        return TimerFormatter.formatTime(timeUntilNextSpawn);
    }

    public void processTimerUpdates() {
        if (this.hasTimerPlaceholders != null && !this.hasTimerPlaceholders.booleanValue()) {
            return;
        }
        if (!this.viewerTrackingManager.hasMainMenuViewers()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashMap<String, List> spawnerViewers = new HashMap<String, List>();
        Map<UUID, ViewerTrackingManager.ViewerInfo> mainMenuViewers = this.viewerTrackingManager.getMainMenuViewers();
        for (Map.Entry<UUID, ViewerTrackingManager.ViewerInfo> entry : mainMenuViewers.entrySet()) {
            UUID playerId = entry.getKey();
            ViewerTrackingManager.ViewerInfo viewerInfo = entry.getValue();
            SpawnerData spawner = viewerInfo.getSpawnerData();
            Long lastUpdate = this.lastTimerUpdate.get(playerId);
            if (lastUpdate != null && currentTime - lastUpdate < 800L) continue;
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) {
                this.viewerTrackingManager.untrackViewer(playerId);
                continue;
            }
            Inventory openInventory = player.getOpenInventory().getTopInventory();
            if (openInventory == null || !(openInventory.getHolder(false) instanceof SpawnerMenuHolder)) {
                this.viewerTrackingManager.untrackViewer(playerId);
                continue;
            }
            spawnerViewers.computeIfAbsent(spawner.getSpawnerId(), k -> new ArrayList()).add(new PlayerViewerContext(playerId, player, openInventory, player.getLocation()));
        }
        int processedPlayers = 0;
        for (Map.Entry spawnerGroup : spawnerViewers.entrySet()) {
            List viewers = (List)spawnerGroup.getValue();
            if (viewers.isEmpty()) continue;
            PlayerViewerContext firstViewer = (PlayerViewerContext)viewers.get(0);
            ViewerTrackingManager.ViewerInfo viewerInfo = mainMenuViewers.get(firstViewer.playerId);
            if (viewerInfo == null) continue;
            SpawnerData spawner = viewerInfo.getSpawnerData();
            String newTimerValue = this.calculateTimerDisplayInternal(spawner);
            for (PlayerViewerContext context : viewers) {
                if (processedPlayers >= 10) break;
                String lastValue = this.lastTimerValue.get(context.playerId);
                if (lastValue != null && lastValue.equals(newTimerValue)) continue;
                this.lastTimerUpdate.put(context.playerId, currentTime);
                this.lastTimerValue.put(context.playerId, newTimerValue);
                ++processedPlayers;
                if (context.location == null) continue;
                String finalTimerValue = newTimerValue;
                UUID finalPlayerId = context.playerId;
                Scheduler.runLocationTask(context.location, () -> {
                    if (!context.player.isOnline() || !mainMenuViewers.containsKey(finalPlayerId)) {
                        return;
                    }
                    Inventory currentInv = context.player.getOpenInventory().getTopInventory();
                    if (currentInv == null || !(currentInv.getHolder(false) instanceof SpawnerMenuHolder)) {
                        this.viewerTrackingManager.untrackViewer(finalPlayerId);
                        return;
                    }
                    int spawnerInfoSlot = this.slotCacheManager.getSpawnerInfoSlot();
                    if (spawnerInfoSlot >= 0) {
                        this.updateSpawnerInfoItemTimer(currentInv, spawner, finalTimerValue, spawnerInfoSlot);
                        context.player.updateInventory();
                    }
                });
            }
            if (processedPlayers < 10) continue;
            break;
        }
    }

    public void forceStateChangeUpdate(SpawnerData spawner) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        Set<UUID> mainMenuViewerSet = this.viewerTrackingManager.getMainMenuViewersForSpawner(spawner.getSpawnerId());
        if (mainMenuViewerSet == null || mainMenuViewerSet.isEmpty()) {
            return;
        }
        for (UUID viewerId : mainMenuViewerSet) {
            this.lastTimerUpdate.remove(viewerId);
            this.lastTimerValue.remove(viewerId);
        }
        this.updateMainMenuViewers(spawner);
    }

    public void forceTimerUpdateInactive(Player player, SpawnerData spawner) {
        spawner.clearPreGeneratedLoot();
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        if (!this.isValidGuiSession(player)) {
            return;
        }
        Location playerLocation = player.getLocation();
        if (playerLocation == null) {
            return;
        }
        Scheduler.runLocationTask(playerLocation, () -> {
            if (!player.isOnline()) {
                return;
            }
            Inventory openInventory = player.getOpenInventory().getTopInventory();
            if (openInventory == null || !(openInventory.getHolder(false) instanceof SpawnerMenuHolder)) {
                return;
            }
            int spawnerInfoSlot = this.slotCacheManager.getSpawnerInfoSlot();
            if (spawnerInfoSlot >= 0) {
                String timerValue = this.cachedInactiveText;
                this.updateSpawnerInfoItemTimer(openInventory, spawner, timerValue, spawnerInfoSlot);
                player.updateInventory();
            }
        });
    }

    private String calculateTimerDisplayInternal(SpawnerData spawner) {
        if (spawner.hasNoLootOrExperience()) {
            return this.cachedNoLootText;
        }
        if (spawner.getIsAtCapacity().booleanValue()) {
            return this.cachedFullText;
        }
        if (spawner.getSpawnerStop().get()) {
            spawner.clearPreGeneratedLoot();
            return this.cachedInactiveText;
        }
        long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
        return TimerFormatter.formatTime(timeUntilNextSpawn);
    }

    private void updateMainMenuViewers(SpawnerData spawner) {
        Set<UUID> mainMenuViewerSet = this.viewerTrackingManager.getMainMenuViewersForSpawner(spawner.getSpawnerId());
        if (mainMenuViewerSet == null || mainMenuViewerSet.isEmpty()) {
            return;
        }
        String timerValue = this.calculateTimerDisplayInternal(spawner);
        for (UUID viewerId : new HashSet<UUID>(mainMenuViewerSet)) {
            Player viewer = Bukkit.getPlayer((UUID)viewerId);
            if (!this.isValidGuiSession(viewer)) {
                this.viewerTrackingManager.untrackViewer(viewerId);
                continue;
            }
            Location loc = viewer.getLocation();
            if (loc == null) continue;
            String finalTimerValue = timerValue;
            UUID finalViewerId = viewerId;
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline() || !this.viewerTrackingManager.getMainMenuViewers().containsKey(finalViewerId)) {
                    return;
                }
                Inventory openInv = viewer.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder(false) instanceof SpawnerMenuHolder)) {
                    this.viewerTrackingManager.untrackViewer(finalViewerId);
                    return;
                }
                this.updateSpawnerInfoItemTimer(openInv, spawner, finalTimerValue, this.slotCacheManager.getSpawnerInfoSlot());
                viewer.updateInventory();
            });
        }
    }

    private long calculateTimeUntilNextSpawn(SpawnerData spawner) {
        long cachedDelay = spawner.getCachedSpawnDelay();
        if (cachedDelay == 0L) {
            cachedDelay = (spawner.getSpawnDelay() + 20L) * 50L;
            spawner.setCachedSpawnDelay(cachedDelay);
        }
        long currentTime = System.currentTimeMillis();
        long lastSpawnTime = spawner.getLastSpawnTime();
        long timeElapsed = currentTime - lastSpawnTime;
        long timeUntilNextSpawn = cachedDelay - timeElapsed;
        if (this.lootHelper.shouldPreGenerateLoot(timeUntilNextSpawn = Math.max(0L, Math.min(timeUntilNextSpawn, cachedDelay)))) {
            this.lootHelper.preGenerateLoot(spawner);
        }
        if (this.lootHelper.shouldAddLootEarly(timeUntilNextSpawn)) {
            this.lootHelper.addPreGeneratedLootEarly(spawner, cachedDelay);
        }
        return timeUntilNextSpawn;
    }

    private void updateSpawnerInfoItemTimer(Inventory inventory, SpawnerData spawner, String timeDisplay, int spawnerInfoSlot) {
        if (spawnerInfoSlot < 0) {
            return;
        }
        ItemStack spawnerItem = inventory.getItem(spawnerInfoSlot);
        if (spawnerItem == null) {
            return;
        }
        ItemMeta meta = spawnerItem.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return;
        }
        String spawnerId = spawner.getSpawnerId();
        Integer cachedIndex = this.timerLineIndexCache.get(spawnerId);
        boolean needsUpdate = false;
        int updatedIndex = -1;
        String updatedLine = null;
        if (cachedIndex != null && cachedIndex >= 0 && cachedIndex < lore.size()) {
            String line = (String)lore.get(cachedIndex);
            updatedLine = this.tryUpdateTimerLine(line, timeDisplay);
            if (updatedLine != null && !updatedLine.equals(line)) {
                updatedIndex = cachedIndex;
                needsUpdate = true;
            } else if (updatedLine == null) {
                this.timerLineIndexCache.remove(spawnerId);
                cachedIndex = null;
            }
        }
        if (!needsUpdate && cachedIndex == null) {
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                updatedLine = this.tryUpdateTimerLine(line, timeDisplay);
                if (updatedLine == null || updatedLine.equals(line)) continue;
                updatedIndex = i;
                needsUpdate = true;
                this.timerLineIndexCache.put(spawnerId, i);
                break;
            }
        }
        if (needsUpdate && updatedIndex >= 0) {
            lore.set(updatedIndex, updatedLine);
            meta.setLore(lore);
            spawnerItem.setItemMeta(meta);
            inventory.setItem(spawnerInfoSlot, spawnerItem);
        }
    }

    private String tryUpdateTimerLine(String line, String timeDisplay) {
        if (line.contains("{time}")) {
            return line.replace("{time}", timeDisplay);
        }
        if (line.indexOf(58) == -1) {
            return null;
        }
        String updatedLine = this.updateExistingTimerLine(line, timeDisplay);
        if (!updatedLine.equals(line)) {
            return updatedLine;
        }
        return null;
    }

    private String updateExistingTimerLine(String line, String newTimeDisplay) {
        int colonIndex = line.indexOf(58);
        if (colonIndex == -1) {
            return line;
        }
        if (TIMER_PATTERN.matcher(line).find()) {
            return TIMER_PATTERN.matcher(line).replaceFirst(newTimeDisplay);
        }
        return line;
    }

    private boolean isValidGuiSession(Player player) {
        return player != null && player.isOnline();
    }

    public void clearPlayerTracking(UUID playerId) {
        this.lastTimerUpdate.remove(playerId);
        this.lastTimerValue.remove(playerId);
    }

    public void clearAllTracking() {
        this.lastTimerUpdate.clear();
        this.lastTimerValue.clear();
    }

    private static class PlayerViewerContext {
        final UUID playerId;
        final Player player;
        final Inventory inventory;
        final Location location;

        PlayerViewerContext(UUID playerId, Player player, Inventory inventory, Location location) {
            this.playerId = playerId;
            this.player = player;
            this.inventory = inventory;
            this.location = location;
        }
    }
}

