/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.spawner.lootgen.PlayerRangeWrapper;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

class RangeMath {
    private final List<SpawnerData> spawners;
    private final PlayerRangeWrapper[] rangePlayers;

    public RangeMath(PlayerRangeWrapper[] players, List<SpawnerData> spawners) {
        this.spawners = spawners;
        this.rangePlayers = players;
    }

    public boolean[] getActiveSpawners() {
        boolean[] activeSpawners = new boolean[this.spawners.size()];
        for (int i = 0; i < this.spawners.size(); ++i) {
            World locWorld;
            SpawnerData s = this.spawners.get(i);
            Location spawnerLoc = s.getSpawnerLocation();
            if (spawnerLoc == null || (locWorld = spawnerLoc.getWorld()) == null) continue;
            UUID worldUID = locWorld.getUID();
            double rangeSq = s.getSpawnerRange() * s.getSpawnerRange();
            boolean playerFound = false;
            for (PlayerRangeWrapper p : this.rangePlayers) {
                if (!p.spawnConditions() || !worldUID.equals(p.worldUID()) || !(p.distanceSquared(spawnerLoc) <= rangeSq)) continue;
                playerFound = true;
                break;
            }
            activeSpawners[i] = playerFound;
        }
        return activeSpawners;
    }
}

