/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.lootgen.LootResult;
import github.nighter.smartspawner.spawner.lootgen.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class SpawnerLootGenerator {
    private final SmartSpawner plugin;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final SpawnerManager spawnerManager;
    private final Random random;

    public SpawnerLootGenerator(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.spawnerManager = plugin.getSpawnerManager();
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spawnLootToSpawner(SpawnerData spawner) {
        boolean lockAcquired = spawner.getLootGenerationLock().tryLock();
        if (!lockAcquired) {
            return;
        }
        try {
            long spawnTime;
            int maxMobs;
            int minMobs;
            AtomicInteger maxSlots;
            AtomicInteger usedSlots;
            if (!spawner.getDataLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            try {
                usedSlots = new AtomicInteger(spawner.getVirtualInventory().getUsedSlots());
                maxSlots = new AtomicInteger(spawner.getMaxSpawnerLootSlots());
                if (usedSlots.get() >= maxSlots.get() && spawner.getSpawnerExp() >= spawner.getMaxStoredExp()) {
                    if (spawner.getIsAtCapacity() != false) return;
                    spawner.setIsAtCapacity(true);
                    return;
                }
                minMobs = spawner.getMinMobs();
                maxMobs = spawner.getMaxMobs();
                spawnTime = currentTime;
            }
            finally {
                spawner.getDataLock().unlock();
            }
            Scheduler.runTaskAsync(() -> {
                LootResult loot = this.generateLoot(minMobs, maxMobs, spawner);
                if (loot.items().isEmpty() && loot.experience() == 0) {
                    return;
                }
                Scheduler.runLocationTask(spawner.getSpawnerLocation(), () -> {
                    boolean updateLockAcquired = spawner.getLootGenerationLock().tryLock();
                    if (!updateLockAcquired) {
                        return;
                    }
                    try {
                        boolean changed = false;
                        if (loot.experience() > 0 && spawner.getSpawnerExp() < spawner.getMaxStoredExp()) {
                            int currentExp = spawner.getSpawnerExp();
                            int maxExp = spawner.getMaxStoredExp();
                            int newExp = Math.min(currentExp + loot.experience(), maxExp);
                            if (newExp != currentExp) {
                                spawner.setSpawnerExp(newExp);
                                changed = true;
                            }
                        }
                        maxSlots.set(spawner.getMaxSpawnerLootSlots());
                        usedSlots.set(spawner.getVirtualInventory().getUsedSlots());
                        if (!loot.items().isEmpty() && usedSlots.get() < maxSlots.get()) {
                            List<ItemStack> itemsToAdd = new ArrayList<ItemStack>(loot.items());
                            int totalRequiredSlots = this.calculateRequiredSlots(itemsToAdd, spawner.getVirtualInventory());
                            if (totalRequiredSlots > maxSlots.get()) {
                                itemsToAdd = this.limitItemsToAvailableSlots(itemsToAdd, spawner);
                            }
                            if (!itemsToAdd.isEmpty()) {
                                spawner.addItemsAndUpdateSellValue(itemsToAdd);
                                changed = true;
                            }
                        }
                        if (!changed) {
                            return;
                        }
                        boolean updateDataLockAcquired = spawner.getDataLock().tryLock();
                        if (updateDataLockAcquired) {
                            try {
                                spawner.setLastSpawnTime(spawnTime);
                            }
                            finally {
                                spawner.getDataLock().unlock();
                            }
                        }
                        spawner.updateCapacityStatus();
                        this.handleGuiUpdates(spawner);
                        this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
                    }
                    finally {
                        spawner.getLootGenerationLock().unlock();
                    }
                });
            });
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            spawner.getLootGenerationLock().unlock();
        }
    }

    public LootResult generateLoot(int minMobs, int maxMobs, SpawnerData spawner) {
        int mobCount = this.random.nextInt(maxMobs - minMobs + 1) + minMobs;
        int totalExperience = spawner.getEntityExperienceValue() * mobCount;
        List<LootItem> validItems = spawner.getValidLootItems();
        if (validItems.isEmpty()) {
            return new LootResult(Collections.emptyList(), totalExperience);
        }
        HashMap<ItemStack, Integer> consolidatedLoot = new HashMap<ItemStack, Integer>();
        for (LootItem lootItem : validItems) {
            ItemStack prototype;
            int successfulDrops = 0;
            for (int i = 0; i < mobCount; ++i) {
                if (!(this.random.nextDouble() * 100.0 <= lootItem.chance())) continue;
                ++successfulDrops;
            }
            if (successfulDrops <= 0 || (prototype = lootItem.createItemStack(this.random)) == null) continue;
            int totalAmount = 0;
            for (int i = 0; i < successfulDrops; ++i) {
                totalAmount += lootItem.generateAmount(this.random);
            }
            if (totalAmount <= 0) continue;
            consolidatedLoot.merge(prototype, totalAmount, Integer::sum);
        }
        ArrayList<ItemStack> finalLoot = new ArrayList<ItemStack>(consolidatedLoot.size());
        for (Map.Entry entry : consolidatedLoot.entrySet()) {
            ItemStack extraStack;
            ItemStack item = ((ItemStack)entry.getKey()).clone();
            item.setAmount(Math.min((Integer)entry.getValue(), item.getMaxStackSize()));
            finalLoot.add(item);
            for (int remaining = (Integer)entry.getValue() - item.getMaxStackSize(); remaining > 0; remaining -= extraStack.getAmount()) {
                extraStack = item.clone();
                extraStack.setAmount(Math.min(remaining, item.getMaxStackSize()));
                finalLoot.add(extraStack);
            }
        }
        return new LootResult(finalLoot, totalExperience);
    }

    private List<ItemStack> limitItemsToAvailableSlots(List<ItemStack> items, SpawnerData spawner) {
        VirtualInventory currentInventory = spawner.getVirtualInventory();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        if (currentInventory.getUsedSlots() >= maxSlots) {
            return Collections.emptyList();
        }
        HashMap<VirtualInventory.ItemSignature, Long> simulatedInventory = new HashMap<VirtualInventory.ItemSignature, Long>(currentInventory.getConsolidatedItems());
        ArrayList<ItemStack> acceptedItems = new ArrayList<ItemStack>();
        items.sort(Comparator.comparing(item -> item.getType().name()));
        for (ItemStack item2 : items) {
            long maxAddAmount;
            if (item2 == null || item2.getAmount() <= 0) continue;
            HashMap<VirtualInventory.ItemSignature, Long> tempSimulation = new HashMap<VirtualInventory.ItemSignature, Long>(simulatedInventory);
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item2);
            tempSimulation.merge(sig, Long.valueOf(item2.getAmount()), Long::sum);
            int slotsNeeded = this.calculateSlots(tempSimulation);
            if (slotsNeeded <= maxSlots) {
                acceptedItems.add(item2);
                simulatedInventory = tempSimulation;
                continue;
            }
            int maxStackSize = item2.getMaxStackSize();
            long currentAmount = simulatedInventory.getOrDefault(sig, 0L);
            int remainingSlots = maxSlots - this.calculateSlots(simulatedInventory);
            if (remainingSlots <= 0 || (maxAddAmount = (long)remainingSlots * (long)maxStackSize - currentAmount % (long)maxStackSize) <= 0L) break;
            ItemStack partialItem = item2.clone();
            partialItem.setAmount((int)Math.min(maxAddAmount, (long)item2.getAmount()));
            acceptedItems.add(partialItem);
            simulatedInventory.merge(sig, Long.valueOf(partialItem.getAmount()), Long::sum);
            break;
        }
        return acceptedItems;
    }

    private int calculateSlots(Map<VirtualInventory.ItemSignature, Long> items) {
        return items.entrySet().stream().mapToInt(entry -> {
            long amount = (Long)entry.getValue();
            int maxStackSize = ((VirtualInventory.ItemSignature)entry.getKey()).getTemplateRef().getMaxStackSize();
            return (int)((amount + (long)maxStackSize - 1L) / (long)maxStackSize);
        }).sum();
    }

    private int calculateRequiredSlots(List<ItemStack> items, VirtualInventory inventory) {
        HashMap<VirtualInventory.ItemSignature, Long> simulatedItems = new HashMap<VirtualInventory.ItemSignature, Long>();
        if (inventory != null) {
            simulatedItems.putAll(inventory.getConsolidatedItems());
        }
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item);
            simulatedItems.merge(sig, Long.valueOf(item.getAmount()), Long::sum);
        }
        return this.calculateSlots(simulatedItems);
    }

    private void handleGuiUpdates(SpawnerData spawner) {
        Location loc;
        World world;
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (this.plugin.getConfig().getBoolean("particle.spawner_generate_loot", true) && (world = (loc = spawner.getSpawnerLocation()).getWorld()) != null) {
            Scheduler.runLocationTask(loc, () -> world.spawnParticle(Particle.HAPPY_VILLAGER, loc.clone().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.0));
        }
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            spawner.updateHologramData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preGenerateLoot(SpawnerData spawner, LootGenerationCallback callback) {
        if (!spawner.getLootGenerationLock().tryLock()) {
            callback.onLootGenerated(Collections.emptyList(), 0);
            return;
        }
        try {
            int maxMobs;
            int minMobs;
            if (!spawner.getDataLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                callback.onLootGenerated(Collections.emptyList(), 0);
                return;
            }
            try {
                boolean atCapacity;
                int usedSlots = spawner.getVirtualInventory().getUsedSlots();
                int maxSlots = spawner.getMaxSpawnerLootSlots();
                boolean bl = atCapacity = usedSlots >= maxSlots && spawner.getSpawnerExp() >= spawner.getMaxStoredExp();
                if (atCapacity) {
                    callback.onLootGenerated(Collections.emptyList(), 0);
                    return;
                }
                minMobs = spawner.getMinMobs();
                maxMobs = spawner.getMaxMobs();
            }
            finally {
                spawner.getDataLock().unlock();
            }
            Scheduler.runTaskAsync(() -> {
                LootResult loot = this.generateLoot(minMobs, maxMobs, spawner);
                callback.onLootGenerated((List<ItemStack>)(loot.items() != null ? new ArrayList<ItemStack>(loot.items()) : Collections.emptyList()), loot.experience());
            });
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            callback.onLootGenerated(Collections.emptyList(), 0);
            return;
        }
        finally {
            spawner.getLootGenerationLock().unlock();
        }
    }

    public void addPreGeneratedLoot(SpawnerData spawner, List<ItemStack> items, int experience) {
        this.addPreGeneratedLoot(spawner, items, experience, System.currentTimeMillis());
    }

    public void addPreGeneratedLoot(SpawnerData spawner, List<ItemStack> items, int experience, long spawnTime) {
        if ((items == null || items.isEmpty()) && experience == 0) {
            return;
        }
        Location spawnerLocation = spawner.getSpawnerLocation();
        if (spawnerLocation == null) {
            return;
        }
        Scheduler.runLocationTask(spawnerLocation, () -> {
            if (!spawner.getLootGenerationLock().tryLock()) {
                return;
            }
            try {
                if (!spawner.getDataLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                try {
                    boolean capacityCheck;
                    int usedSlots = spawner.getVirtualInventory().getUsedSlots();
                    int maxSlots = spawner.getMaxSpawnerLootSlots();
                    boolean bl = capacityCheck = usedSlots >= maxSlots && spawner.getSpawnerExp() >= spawner.getMaxStoredExp();
                    if (capacityCheck) {
                        return;
                    }
                }
                finally {
                    spawner.getDataLock().unlock();
                }
                Scheduler.runTaskAsync(() -> {
                    int maxExp;
                    int currentExp;
                    int newExp;
                    boolean changed = false;
                    if (experience > 0 && spawner.getSpawnerExp() < spawner.getMaxStoredExp() && (newExp = Math.min((currentExp = spawner.getSpawnerExp().intValue()) + experience, maxExp = spawner.getMaxStoredExp())) != currentExp) {
                        spawner.setSpawnerExp(newExp);
                        changed = true;
                    }
                    if (items != null && !items.isEmpty()) {
                        ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
                        for (ItemStack item : items) {
                            if (item == null || item.getType() == Material.AIR) continue;
                            validItems.add(item.clone());
                        }
                        if (!validItems.isEmpty()) {
                            spawner.addItemsAndUpdateSellValue(validItems);
                            changed = true;
                        }
                    }
                    if (!changed) {
                        return;
                    }
                    if (spawner.getDataLock().tryLock()) {
                        try {
                            spawner.setLastSpawnTime(spawnTime);
                        }
                        finally {
                            spawner.getDataLock().unlock();
                        }
                    }
                    spawner.updateCapacityStatus();
                    this.handleGuiUpdates(spawner);
                    this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
                });
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                spawner.getLootGenerationLock().unlock();
            }
        });
    }

    @FunctionalInterface
    public static interface LootGenerationCallback {
        public void onLootGenerated(List<ItemStack> var1, int var2);
    }
}

